/*
 * Decompiled with CFR 0.152.
 */
package is2.util;

import is2.data.SentenceData09;
import is2.io.CONLLReader09;

public class ParserEvaluator {
    public static final String PUNCT = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

    public static Results evaluate(String act_file, String pred_file) throws Exception {
        CONLLReader09 goldReader = new CONLLReader09(act_file, -1);
        CONLLReader09 predictedReader = new CONLLReader09(pred_file, -1);
        int total = 0;
        int corr = 0;
        int corrL = 0;
        int numsent = 0;
        int corrsent = 0;
        int corrsentL = 0;
        SentenceData09 goldInstance = goldReader.getNext();
        SentenceData09 predInstance = predictedReader.getNext();
        while (goldInstance != null) {
            int instanceLength = goldInstance.length();
            if (instanceLength != predInstance.length()) {
                System.out.println("Lengths do not match on sentence " + numsent);
            }
            int[] goldHeads = goldInstance.heads;
            String[] goldLabels = goldInstance.labels;
            int[] predHeads = predInstance.pheads;
            String[] predLabels = predInstance.plabels;
            boolean whole = true;
            boolean wholeL = true;
            int punc = 0;
            int i = 1;
            while (i < instanceLength) {
                if (predHeads[i] == goldHeads[i]) {
                    ++corr;
                    if (goldLabels[i].equals(predLabels[i])) {
                        ++corrL;
                    } else {
                        wholeL = false;
                    }
                } else {
                    whole = false;
                    wholeL = false;
                }
                ++i;
            }
            total += instanceLength - 1 - punc;
            if (whole) {
                ++corrsent;
            }
            if (wholeL) {
                ++corrsentL;
            }
            ++numsent;
            goldInstance = goldReader.getNext();
            predInstance = predictedReader.getNext();
        }
        Results r = new Results();
        r.total = total;
        r.corr = corr;
        r.las = (float)Math.round((double)corrL / (double)total * 100000.0) / 1000.0f;
        r.ula = (float)Math.round((double)corr / (double)total * 100000.0) / 1000.0f;
        System.out.print("Total: " + total + " \tCorrect: " + corr + " ");
        System.out.println("LAS: " + (double)Math.round((double)corrL / (double)total * 100000.0) / 1000.0 + " \tTotal: " + (double)Math.round((double)corrsentL / (double)numsent * 100000.0) / 1000.0 + " \tULA: " + (double)Math.round((double)corr / (double)total * 100000.0) / 1000.0 + " \tTotal: " + (double)Math.round((double)corrsent / (double)numsent * 100000.0) / 1000.0);
        return r;
    }

    public static float round(double v) {
        return (float)Math.round(v * 10000.0) / 10000.0f;
    }

    public static class Results {
        public int total;
        public int corr;
        public float las;
        public float ula;
    }
}

