/*
 * Decompiled with CFR 0.152.
 */
package is2.util;

import is2.util.OptionsSuper;
import java.io.File;
import java.io.IOException;

public final class Options
extends OptionsSuper {
    public Options(String[] args) {
        int i = 0;
        while (i < args.length) {
            String[] pair = args[i].split(":");
            if (pair[0].equals("--help")) {
                this.explain();
            } else if (pair[0].equals("-train")) {
                this.train = true;
                this.trainfile = args[i + 1];
            } else if (pair[0].equals("-eval")) {
                this.eval = true;
                this.goldfile = args[i + 1];
                ++i;
            } else if (pair[0].equals("-test")) {
                this.test = true;
                this.testfile = args[i + 1];
                ++i;
            } else if (pair[0].equals("-i")) {
                this.numIters = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (pair[0].equals("-out")) {
                this.outfile = args[i + 1];
                ++i;
            } else if (pair[0].equals("-decode")) {
                this.decodeProjective = args[i + 1].equals("proj");
                ++i;
            } else if (pair[0].equals("-confidence")) {
                this.conf = true;
            } else if (pair[0].equals("-count")) {
                this.count = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (pair[0].equals("-model")) {
                this.modelName = args[i + 1];
                ++i;
            } else if (pair[0].equals("-device")) {
                this.device = args[i + 1];
                ++i;
            } else if (pair[0].equals("-tmp")) {
                this.tmp = args[i + 1];
                ++i;
            } else if (pair[0].equals("-format")) {
                this.formatTask = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (pair[0].equals("-allfeatures")) {
                this.allFeatures = true;
            } else if (pair[0].equals("-nonormalize")) {
                this.normalize = false;
            } else if (pair[0].equals("-nframes")) {
                this.nbframes = args[i + 1];
                ++i;
            } else if (pair[0].equals("-pframes")) {
                this.pbframes = args[i + 1];
                ++i;
            } else if (pair[0].equals("-nopred")) {
                this.nopred = true;
            } else if (pair[0].equals("-divide")) {
                this.keep = true;
            } else if (pair[0].equals("-lexicon")) {
                this.lexicon = args[i + 1];
                ++i;
            } else {
                super.addOption(args, i);
            }
            ++i;
        }
        try {
            if (this.trainfile != null) {
                if (this.keep && this.tmp != null) {
                    this.trainforest = new File(this.tmp);
                    if (!this.trainforest.exists()) {
                        this.keep = false;
                    }
                } else if (this.tmp != null) {
                    this.trainforest = File.createTempFile("train", ".tmp", new File(this.tmp));
                    this.trainforest.deleteOnExit();
                } else {
                    this.trainforest = File.createTempFile("train", ".tmp");
                    this.trainforest.deleteOnExit();
                }
            }
        }
        catch (IOException e) {
            System.out.println("Unable to create tmp files for feature forests!");
            System.out.println(e);
            System.exit(0);
        }
    }

    private void explain() {
        System.out.println("Usage: ");
        System.out.println("java -class mate.jar is2.parser.Parser [Options]");
        System.out.println();
        System.out.println("Example: ");
        System.out.println(" java -class mate.jar is2.parser.Parser -model eps3.model -train corpora/conll08st/train/train.closed -test corpora/conll08st/devel/devel.closed  -out b3.test -eval corpora/conll08st/devel/devel.closed  -count 2000 -i 6");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("");
        System.out.println(" -train  <file>    the corpus a model is trained on; default " + this.trainfile);
        System.out.println(" -test   <file>    the input corpus for testing; default " + this.testfile);
        System.out.println(" -out    <file>    the output corpus (result) of a test run; default " + this.outfile);
        System.out.println(" -model  <file>    the parsing model for traing the model is stored in the files");
        System.out.println("                   and for parsing the model is load from this file; default " + this.modelName);
        System.out.println(" -i      <number>  the number of training iterations; good numbers are 10 for smaller corpora and 6 for bigger; default " + this.numIters);
        System.out.println(" -count  <number>  the n first sentences of the corpus are take for the training default " + this.count);
        System.out.println(" -format <number>  conll format of the year 8 or 9; default " + this.formatTask);
        System.exit(0);
    }
}

