/*
 * Decompiled with CFR 0.152.
 */
package is2.util;

public final class IntStack {
    public final int[] stack;
    public int position = -1;

    public IntStack(int size) {
        this.stack = size <= 0 ? new int[1] : new int[size + 1];
    }

    public IntStack(IntStack s) {
        this.stack = s.stack;
        this.position = s.position;
    }

    public int peek() {
        return this.position == -1 ? -1 : this.stack[this.position];
    }

    public void push(int i) {
        this.stack[++this.position] = i;
    }

    public int pop() {
        return this.position == -1 ? -1 : this.stack[this.position--];
    }

    public int size() {
        return this.position + 1;
    }

    public boolean isEmpty() {
        return this.position == -1;
    }

    public int get(int p) {
        return this.stack[p];
    }

    public void clear() {
        this.position = -1;
    }

    public void addAll(IntStack b) {
        this.position = b.position;
        if (this.position < 0) {
            return;
        }
        int k = 0;
        while (k <= this.position) {
            this.stack[k] = b.stack[k];
            ++k;
        }
    }

    public boolean contains(int s) {
        int k = 0;
        while (k <= this.position) {
            if (this.stack[k] == s) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        int k = this.position;
        while (k >= 0) {
            s.append(k).append(":").append(this.stack[k]).append(" ");
            --k;
        }
        return s.toString();
    }
}

