/*
 * Decompiled with CFR 0.152.
 */
package is2.util;

public final class BloomFilter {
    int[] storage;
    int size;
    int hits;

    public BloomFilter(int s, int h) {
        this.storage = new int[s];
        this.size = s * 32;
        this.hits = h;
    }

    public int computeHashCode(long value) {
        return (int)((value ^ (value & 0xFFFFFFFF00000000L) >>> 27) * 5L);
    }

    public boolean lookup(long h) {
        int x = Math.abs(this.computeHashCode(h) % this.size);
        int y = Math.abs((int)h % this.size);
        if ((this.storage[x >> 7] & 1 << (x & 0x1F)) == 0) {
            return false;
        }
        int i = 0;
        while (i <= this.hits) {
            if ((this.storage[(x = Math.abs(x + y) % this.size) >> 7] & 1 << (x & 0x1F)) == 0) {
                return false;
            }
            y = (y + i) % this.size;
            ++i;
        }
        return true;
    }

    public void put(long h) {
        int x = Math.abs(this.computeHashCode(h) % this.size);
        int y = Math.abs((int)h % this.size);
        this.storage[x >> 7] = this.storage[x >> 7] | 1 << (x & 0x1F);
        int i = 0;
        while (i <= this.hits) {
            x = (x + y) % this.size;
            y = (y + i) % this.size;
            this.storage[x >> 7] = this.storage[x >> 7] | 1 << (x & 0x1F);
            ++i;
        }
    }
}

