/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Parse;
import is2.transitionR6j.O;
import is2.util.IntStack;
import java.util.ArrayList;

public final class StateCopy
implements Comparable<StateCopy> {
    ArrayList<O> history;
    IntStack s;
    IntStack b;
    short[] pos;
    short[] nth;
    Parse p;
    private float score = 0.0f;
    public float incompScore = 0.0f;
    public float compScore = 0.0f;
    boolean[][] done;
    int steps = 0;
    String sig;

    public StateCopy(int size, boolean train) {
        this.s = new IntStack(size);
        this.b = new IntStack(size);
        this.p = new Parse(size);
        int k = 0;
        while (k < size) {
            this.p.heads[k] = -1;
            ++k;
        }
        k = size - 1;
        while (k >= 0) {
            this.b.push(k);
            --k;
        }
        this.history = new ArrayList();
        this.done = new boolean[size][4];
        this.pos = new short[size];
        this.nth = new short[size];
    }

    public StateCopy() {
    }

    public static void perform(O o, StateCopy t) {
        if (o.o == 3) {
            t.s.push(t.b.pop());
        } else if (o.o == 1) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.p.heads[i] = (short)j;
            t.p.labels[i] = (short)o.l;
            t.s.push(j);
        } else if (o.o == 2) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.p.heads[j] = (short)i;
            t.p.labels[j] = (short)o.l;
            t.s.push(i);
        } else if (o.o == 5) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.s.push(j);
            t.b.push(i);
        }
        t.score += o.p;
        ++t.steps;
        if (t.history != null) {
            t.history.add(o);
        }
    }

    public StateCopy clone(O o1) {
        StateCopy c = new StateCopy();
        if (o1.o == 3 || o1.o == 5) {
            c.done = this.done;
            c.p = this.p;
        } else {
            c.done = new boolean[this.done.length][this.done[0].length];
            int i = 0;
            while (i < this.done.length) {
                int k = 0;
                while (k < this.done[i].length) {
                    c.done[i][k] = this.done[i][k];
                    ++k;
                }
                ++i;
            }
            c.p = this.p.clone();
        }
        c.s = new IntStack(this.s.stack.length);
        c.s.addAll(this.s);
        c.b = new IntStack(this.b.stack.length);
        c.b.addAll(this.b);
        c.score = this.score;
        c.steps = this.steps;
        c.compScore = this.compScore;
        c.incompScore = this.incompScore;
        if (this.history != null) {
            c.history = new ArrayList();
            c.history.addAll(this.history);
        }
        c.pos = this.pos;
        c.nth = this.nth;
        return c;
    }

    @Override
    public int compareTo(StateCopy o) {
        float s1 = (this.score + this.incompScore) / (float)(this.steps + 1);
        float s2 = (o.score + o.incompScore) / (float)(o.steps + 1);
        return s1 < s2 ? 1 : (s1 == s2 ? 0 : -1);
    }

    public String toString() {
        return " " + this.score() + " " + " s " + this.s + " b " + this.b + "  steps " + this.steps + " " + this.history;
    }

    public float score() {
        return (this.score + this.incompScore) / (float)(this.steps + 1);
    }

    public boolean contains(StateCopy x) {
        if (x.history.size() != this.history.size()) {
            return false;
        }
        int k = 0;
        while (k < this.history.size()) {
            if (this.history.get((int)k).o != x.history.get((int)k).o || this.history.get((int)k).l != x.history.get((int)k).l) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public int diff(StateCopy x) {
        if (x.history.size() != this.history.size()) {
            return Math.abs(x.history.size() - this.history.size());
        }
        int c = 0;
        int k = 0;
        while (k < this.history.size()) {
            if (this.history.get((int)k).o != x.history.get((int)k).o || this.history.get((int)k).l != x.history.get((int)k).l) {
                ++c;
            }
            ++k;
        }
        return c;
    }

    public void signature() {
        StringBuilder b = new StringBuilder();
        for (O o : this.history) {
            b.append((char)o.o).append((char)o.l);
        }
        this.sig = b.toString();
    }
}

