/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Parse;
import is2.transitionR6j.O;
import is2.util.IntStack;
import java.util.ArrayList;
import java.util.Collections;

public final class State
implements Comparable<State> {
    O oper;
    State previous;
    IntStack s;
    IntStack b;
    short[] pos;
    short[] nth;
    Parse p;
    private float score = 0.0f;
    public float incompScore = 0.0f;
    public float compScore = 0.0f;
    String sig;
    boolean[][] done;
    int steps = 0;

    public State(int size, boolean train) {
        this.s = new IntStack(1);
        this.b = new IntStack(size);
        this.p = new Parse(size);
        int k = 0;
        while (k < size) {
            this.p.heads[k] = -1;
            ++k;
        }
        k = size - 1;
        while (k >= 0) {
            this.b.push(k);
            --k;
        }
        this.done = new boolean[size][4];
        this.pos = new short[size];
        this.nth = new short[size];
    }

    public State() {
    }

    public static State perform(O o, State it) {
        State t = it.clone(o);
        if (o.o == 3) {
            t.s.push(t.b.pop());
        } else if (o.o == 1) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.p.heads[i] = (short)j;
            t.p.labels[i] = (short)o.l;
            t.s.push(j);
        } else if (o.o == 2) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.p.heads[j] = (short)i;
            t.p.labels[j] = (short)o.l;
            t.s.push(i);
        } else if (o.o == 5) {
            int j = t.s.pop();
            int i = t.s.pop();
            t.s.push(j);
            t.b.push(i);
        }
        t.score += o.p;
        ++t.steps;
        t.oper = o;
        return t;
    }

    private State clone(O o1) {
        State c = new State();
        c.previous = this;
        if (o1.o == 3 || o1.o == 5) {
            c.done = this.done;
            c.p = this.p;
            c.s = new IntStack(this.s.position + 1);
            c.s.addAll(this.s);
            if (o1.o == 5) {
                c.b = new IntStack(this.b.position + 1);
                c.b.addAll(this.b);
            } else {
                c.b = new IntStack(this.b);
            }
        } else {
            c.s = new IntStack(this.s.stack.length);
            c.s.addAll(this.s);
            c.b = this.b;
            c.done = new boolean[this.done.length][this.done[0].length];
            int i = 0;
            while (i < this.done.length) {
                int k = 0;
                while (k < this.done[i].length) {
                    c.done[i][k] = this.done[i][k];
                    ++k;
                }
                ++i;
            }
            c.p = this.p.clone();
        }
        c.score = this.score;
        c.steps = this.steps;
        c.compScore = this.compScore;
        c.incompScore = this.incompScore;
        c.pos = this.pos;
        c.nth = this.nth;
        return c;
    }

    @Override
    public int compareTo(State o) {
        float s1 = (this.score + this.incompScore) / (float)(this.steps + 1);
        float s2 = (o.score + o.incompScore) / (float)(o.steps + 1);
        return s1 < s2 ? 1 : (s1 == s2 ? 0 : -1);
    }

    public String toString() {
        return " " + this.score() + " " + " s " + this.s + " b " + this.b + "  steps " + this.steps + " ";
    }

    public float score() {
        return (this.score + this.incompScore) / (float)(this.steps + 1);
    }

    public boolean contains(State x) {
        if (x.steps != this.steps) {
            return false;
        }
        State p1 = this;
        State p2 = x;
        int k = 0;
        while (k < x.steps) {
            if (p1.oper.o != p2.oper.o || p1.oper.l != p2.oper.l) {
                return false;
            }
            p1 = p1.previous;
            p2 = p2.previous;
            ++k;
        }
        return true;
    }

    public int diff(State x) {
        if (x.steps != this.steps) {
            return Math.abs(x.steps - this.steps);
        }
        int c = 0;
        State p1 = this;
        State p2 = x;
        int k = 0;
        while (k < this.steps) {
            if (p1.oper.o != p2.oper.o || p1.oper.l != p2.oper.l) {
                ++c;
            }
            p1 = p1.previous;
            p2 = p2.previous;
            ++k;
        }
        return c;
    }

    public void signature() {
        if (this.previous != null && this.previous.sig != null) {
            StringBuilder b = new StringBuilder(this.previous.sig.length() + 2);
            b.append(this.previous.sig).append((char)this.oper.o).append((char)this.oper.l);
            this.sig = b.toString();
            return;
        }
        StringBuilder b = new StringBuilder(this.steps * 2);
        State p = this;
        int i = 0;
        while (i < this.steps) {
            b.append((char)p.oper.o).append((char)p.oper.l);
            p = p.previous;
            ++i;
        }
        StringBuilder b2 = new StringBuilder(b.length());
        int l = b.length() - 1;
        do {
            b2.append(b.charAt(l - 1)).append(b.charAt(l));
        } while ((l -= 2) > 0);
        this.sig = b2.toString();
    }

    public ArrayList<O> getHistory() {
        ArrayList<O> h = new ArrayList<O>();
        State p = this;
        int i = 0;
        while (i < this.steps) {
            h.add(p.oper);
            p = p.previous;
            ++i;
        }
        Collections.reverse(h);
        return h;
    }
}

