/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Cluster;
import is2.data.Instances;
import is2.data.InstancesTagger;
import is2.data.Parse;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.transitionR6j.Edges;
import is2.transitionR6j.ExtractorPet;
import is2.transitionR6j.ExtractorR;
import is2.transitionR6j.ExtractorT2;
import is2.transitionR6j.MFO;
import is2.util.OptionsSuper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Pipe
extends PipeGen {
    public ExtractorPet[] extractor;
    public static final MFO mf = new MFO();
    Cluster cl;
    public static final int _FC = 160;
    public static final int _FD = 70;
    private OptionsSuper options;
    public static long timeExtract;

    public Pipe(OptionsSuper o) {
        this.options = o;
    }

    /*
     * WARNING - void declaration
     */
    public void createInstances(String file, InstancesTagger is) throws Exception {
        void var8_12;
        SentenceData09 instance;
        CONLLReader09 depReader = new CONLLReader09(file);
        mf.register("REL", "<root-type>");
        mf.register("POS", "<root-POS>");
        mf.register("WORD", "<root>");
        System.out.print("Registering feature parts of sentence: ");
        HashMap w2f = new HashMap();
        int ic = 0;
        int del = 0;
        while ((instance = depReader.getNext()) != null) {
            if (++ic % 1000 == 0) {
                del = Pipe.outValue(ic, del);
            }
            String[] stringArray = instance.labels;
            int i1 = 0;
            while (i1 < stringArray.length) {
                mf.register("REL", stringArray[i1]);
                ++i1;
            }
            String[] w = instance.forms;
            int i12 = 0;
            while (i12 < w.length) {
                this.registerChars("C", w[i12]);
                ++i12;
            }
            int i13 = 0;
            while (i13 < w.length) {
                this.registerChars("C", w[i13].toLowerCase());
                ++i13;
            }
            i13 = 0;
            while (i13 < w.length) {
                mf.register("WORD", depReader.normalize(w[i13]));
                ++i13;
            }
            w = instance.plemmas;
            i13 = 0;
            while (i13 < w.length) {
                mf.register("WORD", depReader.normalize(w[i13]));
                ++i13;
            }
            i13 = 0;
            while (i13 < w.length) {
                mf.register("WORD", w[i13]);
                ++i13;
            }
            i13 = 0;
            while (i13 < w.length) {
                this.registerChars("C", w[i13]);
                ++i13;
            }
            i13 = 0;
            while (i13 < w.length) {
                this.registerChars("C", w[i13].toLowerCase());
                ++i13;
            }
            w = instance.ppos;
            i13 = 0;
            while (i13 < w.length) {
                mf.register("POS", w[i13]);
                ++i13;
            }
            w = instance.gpos;
            i13 = 0;
            while (i13 < w.length) {
                mf.register("POS", w[i13]);
                ++i13;
            }
            if (instance.feats != null) {
                String[][] fs = instance.feats;
                int i132 = 0;
                while (i132 < fs.length) {
                    w = fs[i132];
                    if (w != null) {
                        int i2 = 0;
                        while (i2 < w.length) {
                            mf.register("F", w[i2]);
                            ++i2;
                        }
                    }
                    ++i132;
                }
            }
            if (ic - 1 <= this.options.count) continue;
        }
        del = Pipe.outValue(ic, del);
        System.out.println();
        ExtractorPet.initFeatures();
        ArrayList<Map.Entry> wds = new ArrayList<Map.Entry>();
        for (Map.Entry entry : w2f.entrySet()) {
            wds.add(entry);
        }
        Collections.sort(wds, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() == o2.getValue() ? 0 : (o1.getValue() > o2.getValue() ? -1 : 1);
            }
        });
        ExtractorPet.maxForm = mf.getFeatureCounter().get("WORD");
        ExtractorR.maxForm = mf.getFeatureCounter().get("WORD");
        ExtractorT2.corpusWrds = mf.getFeatureCounter().get("WORD");
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, mf, 6);
        mf.calculateBits();
        ExtractorPet.initStat();
        System.out.println(mf.toString());
        depReader.startReading(file);
        boolean bl = false;
        is.init(ic, new MFO());
        Edges.init(mf.getFeatureCounter().get("POS"));
        System.out.print("Creating edge filters and read corpus: ");
        del = 0;
        while (true) {
            SentenceData09 instance1;
            if (var8_12 % 100 == false) {
                del = Pipe.outValue((int)var8_12, del);
            }
            if ((instance1 = depReader.getNext(is)) == null) break;
            is.fillChars(instance1, (int)var8_12, ExtractorT2._CEND);
            int last = is.size() - 1;
            short[] pos = is.gpos[last];
            int k = 0;
            while (k < is.length(last)) {
                if (is.heads[last][k] >= 0) {
                    if (k < is.heads[last][k]) {
                        Edges.put(pos[k], pos[is.heads[last][k]], is.labels[last][k]);
                        Edges.put(pos[k], pos[is.heads[last][k]], is.labels[last][k]);
                        Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                        Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                    } else {
                        Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                        Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                        Edges.put(pos[k], pos[is.heads[last][k]], is.labels[last][k]);
                        Edges.put(pos[k], pos[is.heads[last][k]], is.labels[last][k]);
                    }
                }
                ++k;
            }
            if (!this.options.allFeatures && var8_12 > this.options.count) break;
            ++var8_12;
        }
        del = Pipe.outValue((int)var8_12, del);
        System.out.println();
        Edges.findDefault();
    }

    private void registerChars(String type, String word) {
        int i = 0;
        while (i < word.length()) {
            mf.register(type, Character.toString(word.charAt(i)));
            ++i;
        }
    }

    public static double errors(Instances is, int ic, Parse p) {
        short[] act = is.heads[ic];
        double correct = 0.0;
        int i = 1;
        while (i < act.length) {
            if (p.heads[i] == act[i]) {
                correct += 0.5;
                if (p.labels[i] == is.labels[ic][i]) {
                    correct += 0.5;
                }
            }
            ++i;
        }
        double x = (double)act.length - 1.0 - correct;
        p.f1 = correct / (double)(act.length - 1);
        return x;
    }
}

