/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Cluster;
import is2.data.InstancesTagger;
import is2.data.Long2Int;
import is2.data.Long2IntInterface;
import is2.data.Parse;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.io.CONLLWriter09;
import is2.tools.Tool;
import is2.transitionR6j.Decoder;
import is2.transitionR6j.Edges;
import is2.transitionR6j.ExtractorPet;
import is2.transitionR6j.ExtractorR;
import is2.transitionR6j.ExtractorT2;
import is2.transitionR6j.GuideOracle;
import is2.transitionR6j.MFO;
import is2.transitionR6j.Options;
import is2.transitionR6j.POS;
import is2.transitionR6j.Parameters;
import is2.transitionR6j.ParametersFloat;
import is2.transitionR6j.Pipe;
import is2.transitionR6j.Tagger2;
import is2.util.DB;
import is2.util.Evaluator;
import is2.util.OptionsSuper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Parser
implements Tool {
    private static int _TAGGERITERATIONS = 2;
    public static final boolean SELECTPOS = true;
    private static final boolean MAX_INFO = true;
    public static int THREADS = 4;
    static Long2IntInterface long2int;
    static int taggerTrainingRange;
    private static Long2Int long2intTagger;
    ParametersFloat params;
    static ParametersFloat[] paramsTagger;
    static ParametersFloat paramsTaggerAll;
    static ParametersFloat paramsTaggerAll7;
    static MFO mf;
    Pipe pipe;
    OptionsSuper options;
    Decoder decoder;

    static {
        taggerTrainingRange = 0;
    }

    public Parser(OptionsSuper options) {
        this.options = options;
        this.pipe = new Pipe(options);
        this.params = new ParametersFloat(0);
        try {
            Parser.readModel(options, this.pipe, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parser(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        Pipe pipe;
        Runtime runtime = Runtime.getRuntime();
        THREADS = runtime.availableProcessors();
        long start = System.currentTimeMillis();
        Options options = new Options(args);
        if (options.cores < THREADS && options.cores > 0) {
            THREADS = options.cores;
        }
        DB.println("Found " + runtime.availableProcessors() + " cores use " + THREADS);
        Decoder.beam = options.beam;
        Tagger2.size = options.tsize;
        Tagger2.THRESHOLD = options.thresholdTag;
        Decoder.half = options.half;
        DB.println("tag window size (-tsize <number>) " + Tagger2.size);
        DB.println("tag window size (-half <number>) " + Decoder.half);
        DB.println("tag threshold (-tthreshold <float-number>) " + options.thresholdTag);
        DB.println("beam size (-beam <number>) " + options.beam);
        CONLLReader09.joint = options.joint.replace("\"", "");
        DB.println("joint tagging of (-joint <regex>) " + options.joint.replace("\"", ""));
        _TAGGERITERATIONS = options.tx;
        if (options.train) {
            ExtractorR.p3a = options.third.contains("a");
            ExtractorR.p3b = options.third.contains("b");
            ExtractorR.p3c = options.third.contains("c");
            ExtractorR.p2a = options.second.contains("a");
            ExtractorR.p2b = options.second.contains("b");
            ExtractorR.p2c = options.second.contains("c");
            ExtractorR.p2d = options.second.contains("d");
            ExtractorR.p1a = options.first.contains("a");
            if (options.first.contains("0")) {
                ExtractorR.p1a = false;
            }
            long2int = new Long2Int(options.hsize);
            pipe = new Pipe(options);
            InstancesTagger is = new InstancesTagger();
            ExtractorPet.initFeatures();
            ExtractorT2.initFeatures();
            ExtractorR.initFeatures();
            pipe.createInstances(options.trainfile, is);
            ExtractorR.initStat(1);
            int tagger = options.tnumber;
            DB.println("number of tagger (-tnumber <number>)" + tagger);
            if (options.tagger.contains("train")) {
                void var13_29;
                long2intTagger = new Long2Int(options.thsize);
                paramsTagger = new ParametersFloat[tagger];
                int part = is.size() / tagger;
                DB.println("part-size:" + part + " " + is.size());
                ArrayList<Tagger2> callables = new ArrayList<Tagger2>();
                ArrayList<Tagger2> jacknife = new ArrayList<Tagger2>();
                int i = 0;
                while (i < tagger) {
                    ExtractorT2 extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
                    extractor.initValues();
                    int n = i * part;
                    int gapEnd = (i + 1) * part;
                    if (i == tagger - 1) {
                        gapEnd = is.size();
                    }
                    DB.println("training tagger " + i + " gap start " + n + " gap end " + gapEnd);
                    Parser.paramsTagger[i] = new ParametersFloat(long2intTagger.size());
                    callables.add(new Tagger2(paramsTagger[i], long2intTagger, extractor, n, gapEnd, options, is));
                    ++i;
                }
                jacknife.addAll(callables);
                paramsTaggerAll = new ParametersFloat(long2intTagger.size());
                ExtractorT2 extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
                extractor.initValues();
                DB.println("training tagger full data set");
                callables.add(new Tagger2(paramsTaggerAll, long2intTagger, extractor, 0, 0, options, is));
                ExecutorService executerService = Executors.newFixedThreadPool(THREADS);
                try {
                    executerService.invokeAll(callables);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                System.out.println("Jacknife training set");
                for (Callable callable : jacknife) {
                    ((Tagger2)callable).train = false;
                }
                try {
                    executerService.invokeAll(jacknife);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                boolean bl = false;
                int count = 0;
                for (Tagger2 t : jacknife) {
                    var13_29 += t.correct;
                    count += t.count;
                }
                System.out.println("tagging accuracy of jaacknifed part: " + (float)var13_29 / (float)count);
                callables.clear();
                paramsTaggerAll7 = new ParametersFloat(long2intTagger.size());
                Tagger2 m7 = new Tagger2(paramsTaggerAll7, long2intTagger, extractor, 0, 0, options, is);
                callables.add(m7);
                m7.feat2 = true;
                try {
                    executerService.invokeAll(callables);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                executerService.shutdown();
                Parser.writeTaggers(options.modelName, paramsTagger, paramsTaggerAll, paramsTaggerAll7, pipe.cl, is.size());
            }
            paramsTagger = Parser.readTagger(options.modelName, pipe);
            tagger = paramsTagger.length;
            ExtractorT2 extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
            extractor.initValues();
            if (options.tagger.contains("test") && options.eval) {
                int k = 0;
                while (k < paramsTagger.length) {
                    Parser.tag(options, pipe, paramsTagger[k], extractor);
                    DB.println("testing model " + k);
                    Evaluator.evaluateTagger(options.goldfile, options.outfile, "pos");
                    System.out.println();
                    ++k;
                }
                DB.println("testing full model");
                Parser.tag(options, pipe, paramsTaggerAll, extractor);
                Evaluator.evaluateTagger(options.goldfile, options.outfile, "pos");
                DB.println("testing 7tagger model");
                Parser.tag(options, pipe, paramsTaggerAll7, extractor, true, paramsTaggerAll);
                Evaluator.evaluateTagger(options.goldfile, options.outfile, "pos");
                System.out.println();
            }
            Tagger2[] tgg = new Tagger2[tagger];
            int k = 0;
            while (k < tagger) {
                extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
                extractor.initValues();
                tgg[k] = new Tagger2(paramsTagger[k], long2intTagger, extractor);
                ++k;
            }
            DB.println("cross tagging done");
            String[] wds = MFO.reverse(MFO.getFeatureSet().get("WORD"));
            int numInstances = is.size();
            int part = is.size() / paramsTagger.length;
            POS[][][] pOSArray = new POS[numInstances][][];
            int n = 0;
            while (n < numInstances - 1) {
                int g = n / part;
                if (g >= tgg.length) {
                    DB.println("set g to " + (tgg.length - 1));
                    g = tgg.length - 1;
                }
                g = 0;
                while (g < paramsTagger.length - 1) {
                    if (n > g * part && n < (g + 1) * part) break;
                    ++g;
                }
                String[] forms = new String[is.length(n)];
                int k2 = 0;
                while (k2 < forms.length) {
                    forms[k2] = is.forms[n][k2] != -1 ? wds[is.forms[n][k2]] : wds[is.formlc[n][k2]];
                    ++k2;
                }
                pOSArray[n] = tgg[g].tag(is, n, null, forms, _TAGGERITERATIONS, false, null);
                ++n;
            }
            DB.println("cross tagging done - dropping the taggers");
            Tagger2[] tagger2Array = tgg;
            int forms = tgg.length;
            int g = 0;
            while (g < forms) {
                Tagger2 t = tagger2Array[g];
                t.params.clear();
                t.params = null;
                ++g;
            }
            System.gc();
            extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
            extractor.initValues();
            Tagger2 tggAll = new Tagger2(paramsTaggerAll, long2intTagger, extractor);
            extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
            extractor.initValues();
            Tagger2 tggAll7 = new Tagger2(paramsTaggerAll7, long2intTagger, extractor);
            ParametersFloat params = new ParametersFloat(long2int.size());
            Parser.train(options, pipe, params, is, pipe.cl, long2int, taggerTrainingRange, tggAll, tggAll7, pOSArray);
            Parser.writeModell(options, params, null, pipe.cl);
        }
        if (options.test) {
            pipe = new Pipe(options);
            ExtractorPet.initFeatures();
            ExtractorT2.initFeatures();
            ExtractorR.initFeatures();
            ParametersFloat params = new ParametersFloat(0);
            paramsTagger = Parser.readTagger(options.modelName, pipe);
            Parser.readModel(options, pipe, params);
            long2intTagger = new Long2Int(paramsTagger[0].size());
            Tagger2[] tgg = new Tagger2[paramsTagger.length];
            int t = 0;
            while (t < paramsTagger.length) {
                ExtractorT2 extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
                extractor.initValues();
                tgg[t] = new Tagger2(paramsTagger[paramsTagger.length - 1], long2intTagger, extractor);
                ++t;
            }
            ExtractorT2 extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
            extractor.initValues();
            Tagger2 tggAll = new Tagger2(paramsTaggerAll, long2intTagger, extractor);
            extractor = new ExtractorT2(options, new MFO(), long2intTagger, pipe.cl);
            extractor.initValues();
            Tagger2 tggAll7 = new Tagger2(paramsTaggerAll7, long2intTagger, extractor);
            Parser.out(options, pipe, params, false, tggAll, tggAll7);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            Evaluator.evaluate(options.goldfile, options.outfile);
        }
        long end = System.currentTimeMillis();
        System.out.println("used time " + (float)((end - start) / 100L) / 10.0f);
        System.out.println("end.");
    }

    private static ParametersFloat[] readTagger(String modelName, Pipe pipe) {
        ParametersFloat[] params = null;
        try {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(String.valueOf(modelName) + "-tag")));
            zis.getNextEntry();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(zis));
            mf = new MFO();
            mf.read(dis);
            pipe.cl = new Cluster(dis);
            int modelCount = dis.readInt();
            params = new ParametersFloat[modelCount];
            int i = 0;
            while (i < modelCount) {
                params[i] = new ParametersFloat(0);
                params[i].read(dis);
                ++i;
            }
            paramsTaggerAll = new ParametersFloat(0);
            paramsTaggerAll.read(dis);
            paramsTaggerAll7 = new ParametersFloat(0);
            paramsTaggerAll7.read(dis);
            ExtractorT2.corpusWrds = dis.readInt();
            taggerTrainingRange = dis.readInt();
            dis.close();
            DB.println("Reading data finnished");
            long2intTagger = new Long2Int(params[0].size());
            ExtractorPet.initStat();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    private static void writeTaggers(String name, ParametersFloat[] params, ParametersFloat parametersTaggerAll, ParametersFloat parametersTaggerAll7, Cluster cl, int size) {
        DB.println("Writting tagger models");
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(name) + "-tag")));
            zos.putNextEntry(new ZipEntry("data"));
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            MFO.writeData(dos);
            cl.write(dos);
            dos.writeInt(params.length);
            int i = 0;
            while (i < params.length) {
                params[i].write(dos);
                ++i;
            }
            parametersTaggerAll.write(dos);
            parametersTaggerAll7.write(dos);
            dos.writeInt(ExtractorT2.corpusWrds);
            dos.writeInt(size);
            dos.close();
            zos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DB.println("Writting models finnished");
    }

    public static void readModel(OptionsSuper options, Pipe pipe, Parameters params) throws IOException {
        DataInputStream dis;
        block3: {
            DB.println("Reading data started");
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
            Pipe.mf.read(dis);
            pipe.cl = new Cluster(dis);
            params.read(dis);
            long2int = new Long2Int(params.size());
            DB.println("parsing -- li size " + long2int.size());
            ExtractorPet.initFeatures();
            ExtractorPet.initStat();
            ExtractorR.initFeatures();
            ExtractorR.initStat(1);
            Edges.read(dis);
            options.decodeProjective = dis.readBoolean();
            ExtractorR.p3a = dis.readBoolean();
            ExtractorR.p3b = dis.readBoolean();
            ExtractorR.p3c = dis.readBoolean();
            ExtractorR.p2a = dis.readBoolean();
            ExtractorR.p2b = dis.readBoolean();
            ExtractorR.p2c = dis.readBoolean();
            ExtractorR.p2d = dis.readBoolean();
            ExtractorR.p1a = dis.readBoolean();
            DB.println("projective\t" + options.decodeProjective);
            ExtractorR.maxForm = ExtractorPet.maxForm = dis.readInt();
            System.out.print("1st " + (ExtractorR.p1a ? "a" : "") + " 2nd " + (ExtractorR.p2a ? "a" : "") + (ExtractorR.p2b ? "b" : "") + (ExtractorR.p2c ? "c" : "") + (ExtractorR.p2d ? "d" : ""));
            System.out.println(" 3rd " + (ExtractorR.p3a ? "a" : "") + (ExtractorR.p3b ? "b" : "") + (ExtractorR.p3c ? "c" : ""));
            boolean foundInfo = false;
            try {
                String info = null;
                int icnt = dis.readInt();
                int i = 0;
                while (i < icnt) {
                    info = dis.readUTF();
                    System.out.println(info);
                    ++i;
                }
            }
            catch (Exception e) {
                if (foundInfo) break block3;
                System.out.println("no info about training");
            }
        }
        dis.close();
        DB.println("Reading data finnished");
        ExtractorPet.initStat();
    }

    static void train(Options options, Pipe pipe, ParametersFloat params, InstancesTagger is, Cluster cluster, Long2IntInterface l2i, int taggerTrainingRangex, Tagger2 tggAll, Tagger2 tggAll7, POS[][][] pxx) throws IOException, InterruptedException {
        System.out.println("\nTraining Information ");
        System.out.println("-------------------- ");
        if (options.decodeProjective) {
            System.out.println("Decoding: " + (options.decodeProjective ? "projective" : "non-projective"));
        } else {
            System.out.println(Decoder.getInfo());
        }
        int numInstances = is.size();
        int maxLenInstances = 0;
        int i = 0;
        while (i < numInstances) {
            if (maxLenInstances < is.length(i)) {
                maxLenInstances = is.length(i);
            }
            ++i;
        }
        int iter = 0;
        int del = 0;
        float f1 = 0.0f;
        int upd = numInstances * options.numIters + 1;
        DB.println("cluster size " + pipe.cl.size());
        long t3a = 0L;
        while (iter < options.numIters) {
            Decoder decoder = new Decoder(l2i, params, cluster, options.startPosSelection, iter);
            System.out.print("Iteration " + iter + ": ");
            long start = System.currentTimeMillis();
            long last = System.currentTimeMillis();
            f1 = 0.0f;
            DB.println("beam " + Decoder.beam);
            Decoder.errors = 0;
            Decoder.count = 0;
            Decoder.allNth = 0.0f;
            int n = 0;
            while (n < numInstances - 1) {
                --upd;
                String info = " td " + (float)Decoder.timeDecoder / 1000000.0f + " nthx " + Decoder.allNth / (float)n + " pos " + (float)Decoder.correctPos / ((float)Decoder.correctPos + (float)Decoder.wrongPos);
                if ((n + 1) % 500 == 0) {
                    del = PipeGen.outValueErr(n + 1, Math.round(Decoder.errors * 1000) / 1000, f1 / (float)n, del, last, upd, info);
                }
                GuideOracle guide = new GuideOracle(is.heads[n], is.labels[n], options.decodeProjective);
                decoder.decode(options.decodeProjective, guide, params, upd, is, n, pipe.cl, pxx[n]);
                ++n;
            }
            System.out.println("\nglobal init \t" + Parser.roundSeconds(Decoder.t1) + "\t local init t2 \t" + Parser.roundSeconds(Decoder.t2) + "\t extender t3\t" + Parser.roundSeconds(Decoder.t3) + "\t sort&select t4\t" + Parser.roundSeconds(Decoder.t4) + "\t gold in beam t5\t" + Parser.roundSeconds(Decoder.t5) + "\t rest t6\t" + Parser.roundSeconds(Decoder.t6) + "\t update t7\t" + Parser.roundSeconds(Decoder.t7) + " all ext " + Parser.roundSeconds(t3a += Decoder.t3));
            Decoder.t1 = 0L;
            Decoder.t2 = 0L;
            Decoder.t2 = 0L;
            Decoder.t3 = 0L;
            Decoder.t4 = 0L;
            Decoder.t5 = 0L;
            Decoder.t6 = 0L;
            Decoder.t7 = 0L;
            String info = " td " + (float)Decoder.timeDecoder / 1000000.0f + " nthx " + Decoder.allNth / (float)numInstances + " pos acc " + (float)Decoder.correctPos / ((float)Decoder.correctPos + (float)Decoder.wrongPos) + " " + " nz " + params.countNZ() + " error " + Decoder.errors + " count " + Decoder.count + " " + (Decoder.count - Decoder.errors) / Decoder.count;
            PipeGen.outValueErr(numInstances, Math.round(Decoder.errors * 1000) / 1000, f1 / (float)numInstances, del, last, upd, info);
            del = 0;
            long end = System.currentTimeMillis();
            System.out.println(" time:" + (end - start));
            Decoder.correctPos = 0;
            Decoder.wrongPos = 0;
            ParametersFloat pf = params.average2((iter + 1) * is.size());
            try {
                if (options.testfile != null) {
                    Parser.out(options, pipe, pf, false, tggAll, tggAll7);
                    Evaluator.evaluate(options.goldfile, options.outfile, false);
                    Evaluator.evaluateTagger(options.goldfile, options.outfile, "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Decoder.timeDecoder = 0L;
            Pipe.timeExtract = 0L;
            Decoder.correctPos = 0;
            Decoder.wrongPos = 0;
            if (decoder != null) {
                decoder.executerService.shutdownNow();
            }
            ++iter;
        }
        DB.println("average with " + iter * is.size());
        params.average(iter * is.size());
    }

    private static String roundSeconds(long t1) {
        float t = (float)Math.round((double)t1 / 1000000.0) / 1000.0f;
        return "" + t;
    }

    private static void out(Options options, Pipe pipe, ParametersFloat params, boolean maxInfo, Tagger2 tggAll, Tagger2 tggAll7) throws Exception {
        long start = System.currentTimeMillis();
        CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
        CONLLWriter09 depWriter = new CONLLWriter09(options.outfile, options.formatTask);
        int cnt = 0;
        int del = 0;
        long last = System.currentTimeMillis();
        if (maxInfo) {
            System.out.println("\nParsing Information ");
        }
        if (maxInfo) {
            System.out.println("------------------- ");
        }
        String[] types = new String[Pipe.mf.getFeatureCounter().get("REL").intValue()];
        for (Map.Entry<String, Integer> e : Pipe.mf.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        String[] pos = MFO.reverse(Pipe.mf.getFeatureSet().get("POS"));
        System.out.print("Processing Sentence: ");
        Decoder decoder = new Decoder(long2int, params, pipe.cl);
        Decoder.allNth = 0.0f;
        DB.println("beam " + Decoder.beam);
        int correctTags = 0;
        int allTags = 0;
        int correctRetags = 0;
        int las = 0;
        int rlas = 0;
        float correctOracle = 0.0f;
        float countOracle = 0.0f;
        try {
            while (true) {
                InstancesTagger is = new InstancesTagger();
                is.init(1, mf);
                SentenceData09 instance = depReader.getNext(is);
                if (instance == null || instance.forms == null) break;
                ExtractorT2 cfr_ignored_0 = tggAll.extractor;
                is.fillChars(instance, 0, ExtractorT2._CEND);
                ++cnt;
                int k = 0;
                while (k < is.length(0)) {
                    is.pposs[0][k] = 0;
                    ++k;
                }
                String[] forms = (String[])instance.forms.clone();
                POS[][] pxx = tggAll.tag(is, 0, null, forms, _TAGGERITERATIONS, false, null);
                int k2 = 0;
                while (k2 < pxx[0].length) {
                    is.pposs[0][k2] = (short)pxx[0][k2].p;
                    ++k2;
                }
                k2 = 1;
                while (k2 < pxx[0].length) {
                    int t = 0;
                    while (t < options.tsize) {
                        if (pxx[t][k2].p == is.gpos[0][k2]) {
                            correctOracle += 1.0f;
                        }
                        ++t;
                    }
                    countOracle += 1.0f;
                    ++k2;
                }
                Decoder.R prs = decoder.decode(options.decodeProjective, null, params, 1, is, 0, pipe.cl, pxx);
                Parse p = prs.parse;
                int i = 1;
                while (i < p.heads.length) {
                    if (p.heads[i] == is.heads[0][i] && p.labels[i] == is.labels[0][i]) {
                        ++las;
                    }
                    ++i;
                }
                int k3 = 1;
                while (k3 < pxx[0].length) {
                    if (pxx[0][k3].p == is.gpos[0][k3]) {
                        ++correctTags;
                    }
                    ++allTags;
                    ++k3;
                }
                if (options.tsize > 1) {
                    k3 = 0;
                    while (k3 < pxx[0].length) {
                        is.pposs[0][k3] = (short)pxx[0][k3].p;
                        ++k3;
                    }
                    pxx = tggAll7.tag(is, 0, null, forms, _TAGGERITERATIONS, true, prs.parse.heads);
                    k3 = 1;
                    while (k3 < pxx[0].length) {
                        if (pxx[0][k3].p == is.gpos[0][k3]) {
                            ++correctRetags;
                        }
                        ++k3;
                    }
                    prs = decoder.decode(options.decodeProjective, null, params, 1, is, 0, pipe.cl, pxx);
                    p = prs.parse;
                    i = 1;
                    while (i < p.heads.length) {
                        if (p.heads[i] == is.heads[0][i] && p.labels[i] == is.labels[0][i]) {
                            ++rlas;
                        }
                        ++i;
                    }
                }
                SentenceData09 i09 = new SentenceData09(instance);
                i09.createSemantic(instance);
                int j = 0;
                while (j < forms.length - 1) {
                    i09.plabels[j] = types[prs.parse.labels[j + 1]];
                    i09.pheads[j] = prs.parse.heads[j + 1];
                    i09.ppos[j] = pos[prs.pos[j + 1]];
                    ++j;
                }
                depWriter.write(i09);
                del = PipeGen.outValue(cnt, del, last);
            }
            depWriter.finishWriting();
            long end = System.currentTimeMillis();
            System.out.println("\ntime " + (end - start) + " choosen tag avg " + Decoder.allNth / (float)cnt + " oracle pos " + correctOracle / countOracle);
            DB.println("1st best tagger " + correctTags + " all tags " + allTags + " " + (float)correctTags / (float)allTags + " retag acc " + (float)correctRetags / (float)allTags + " las " + 100.0f * (float)las / (float)allTags + " rlas " + 100.0f * (float)rlas / (float)allTags + " forced stop " + Decoder.forcedStop);
            DB.println("oracle tagging accuracy" + correctOracle / countOracle);
            Decoder.forcedStop = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decoder != null) {
            decoder.executerService.shutdownNow();
        }
    }

    public SentenceData09 parse(SentenceData09 instance) {
        System.out.println("method parse has to be implemented !!!");
        System.exit(0);
        return null;
    }

    @Override
    public SentenceData09 apply(SentenceData09 snt09) {
        this.parse(snt09);
        return snt09;
    }

    private static void writeModell(OptionsSuper options, ParametersFloat params, String extension, Cluster cs) throws FileNotFoundException, IOException {
        String name = extension == null ? options.modelName : String.valueOf(options.modelName) + extension;
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
        zos.putNextEntry(new ZipEntry("data"));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
        MFO.writeData(dos);
        cs.write(dos);
        params.write(dos);
        Edges.write(dos);
        dos.writeBoolean(options.decodeProjective);
        dos.writeBoolean(ExtractorR.p3a);
        dos.writeBoolean(ExtractorR.p3b);
        dos.writeBoolean(ExtractorR.p3c);
        dos.writeBoolean(ExtractorR.p2a);
        dos.writeBoolean(ExtractorR.p2b);
        dos.writeBoolean(ExtractorR.p2c);
        dos.writeBoolean(ExtractorR.p2d);
        dos.writeBoolean(ExtractorR.p1a);
        dos.writeInt(ExtractorPet.maxForm);
        dos.writeInt(5);
        dos.writeUTF("Used parser   " + Parser.class.toString());
        dos.writeUTF("Creation date " + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()));
        dos.writeUTF("Training data " + options.trainfile);
        dos.writeUTF("Iterations    " + options.numIters + " Used sentences " + options.count);
        dos.writeUTF("Cluster       " + options.clusterFile);
        dos.writeUTF("3rd       " + ExtractorR.p3a);
        dos.writeUTF("3rd       " + ExtractorR.p3b);
        dos.writeUTF("3rd       " + ExtractorR.p3c);
        dos.writeUTF("2nd       " + ExtractorR.p2a);
        dos.writeUTF("2nd       " + ExtractorR.p2b);
        dos.writeUTF("2nd       " + ExtractorR.p2c);
        dos.writeUTF("2nd       " + ExtractorR.p2d);
        dos.writeUTF("1st       " + ExtractorR.p1a);
        dos.flush();
        dos.close();
    }

    public static void tag(OptionsSuper options, Pipe pipe, ParametersFloat params, ExtractorT2 extractor) {
        Parser.tag(options, pipe, params, extractor, false, null);
    }

    public static void tag(OptionsSuper options, Pipe pipe, ParametersFloat params, ExtractorT2 extractor, boolean stack, ParametersFloat paramsStandard) {
        try {
            String[] wds = MFO.reverse(MFO.getFeatureSet().get("WORD"));
            String[] tags = MFO.reverse(MFO.getFeatureSet().get("POS"));
            long start = System.currentTimeMillis();
            CONLLReader09 depReader = new CONLLReader09(options.testfile);
            CONLLWriter09 depWriter = new CONLLWriter09(options.outfile);
            System.out.print("Processing Sentence: ");
            Tagger2 tgg = new Tagger2(params, long2intTagger, extractor);
            Tagger2 tggStandard = new Tagger2(paramsStandard, long2intTagger, extractor);
            int cnt = 0;
            int del = 0;
            int correct = 0;
            int all = 0;
            while (true) {
                int j;
                POS[][] pxx;
                InstancesTagger is = new InstancesTagger();
                is.init(1, mf);
                SentenceData09 instance = depReader.getNext(is);
                if (instance == null || instance.forms == null) break;
                is.fillChars(instance, 0, ExtractorT2._CEND);
                ++cnt;
                String[] forms = instance.forms;
                if (stack) {
                    pxx = tggStandard.tag(is, 0, null, forms, _TAGGERITERATIONS, false, null);
                    j = 0;
                    while (j < is.length(0)) {
                        is.pposs[0][j] = (short)pxx[0][j].p;
                        ++j;
                    }
                }
                pxx = tgg.tag(is, 0, is.pposs[0], forms, _TAGGERITERATIONS, stack, stack ? is.heads[0] : null);
                j = 0;
                while (j < instance.length()) {
                    instance.ppos[j] = tags[pxx[0][j].p];
                    ++j;
                }
                int k = 1;
                while (k < pxx[0].length) {
                    if (is.gpos[0][k] == pxx[0][k].p) {
                        ++correct;
                    }
                    ++all;
                    ++k;
                }
                SentenceData09 i09 = new SentenceData09(instance);
                i09.createSemantic(instance);
                depWriter.write(i09);
                if (cnt % 100 != 0) continue;
                del = PipeGen.outValue(cnt, del);
            }
            del = PipeGen.outValue(cnt, del);
            depWriter.finishWriting();
            long end = System.currentTimeMillis();
            System.out.println(PipeGen.getSecondsPerInstnace(cnt, end - start));
            System.out.println(PipeGen.getUsedTime(end - start));
            System.out.println("correct " + correct + " all " + all + (float)correct / (float)all);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

