/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.F2SF;
import is2.data.F2SP;
import is2.data.FV;
import is2.data.Instances;
import is2.data.IntIntHash;
import is2.data.Parse;
import is2.transitionR6j.Parameters;
import is2.util.DB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ParametersFloat
extends Parameters {
    private float[] parameters;
    private float[] total;
    private IntIntHash hm1;
    private IntIntHash hm2;

    public ParametersFloat(int size) {
        this.parameters = new float[size];
        this.total = new float[size];
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = 0.0f;
            this.total[i] = 0.0f;
            ++i;
        }
    }

    public ParametersFloat(float[] p) {
        this.parameters = p;
    }

    @Override
    public void average(double avVal) {
        float min = 100.0f;
        float max = -100.0f;
        int j = 0;
        while (j < this.total.length) {
            this.parameters[j] = this.total[j] / (float)avVal;
            if (this.parameters[j] < min) {
                min = this.parameters[j];
            }
            if (this.parameters[j] > max) {
                max = this.parameters[j];
            }
            ++j;
        }
        this.total = null;
    }

    public ParametersFloat average2(double avVal) {
        float[] px = new float[this.parameters.length];
        int j = 0;
        while (j < this.total.length) {
            px[j] = this.total[j] / (float)avVal;
            ++j;
        }
        ParametersFloat pf = new ParametersFloat(px);
        return pf;
    }

    @Override
    public void update(FV act, FV pred, Instances isdx, int instcx, Parse d, double upd, double e) {
        float lam_dist = this.getScore(act) - this.getScore(pred);
        float b = (float)e - lam_dist;
        FV dist = act.getDistVector(pred);
        dist.update(this.parameters, this.total, this.hildreth(dist, b), upd, false);
    }

    public void update(FV act, FV pred, double upd, double e) {
        float lam_dist = this.getScore(act) - this.getScore(pred);
        float b = (float)e - lam_dist;
        FV dist = act.getDistVector(pred);
        double h = this.hildreth(dist, b);
        dist.update(this.parameters, this.total, h, upd, false);
    }

    public void update(FV act, FV pred, double upd, double e, int s1, int s2) {
        float lam_dist = this.getScore(act) / (float)s1 - this.getScore(pred) / (float)s2;
        float b = (float)e - lam_dist;
        FV dist = act.getDistVector(pred);
        double h = this.hildreth(dist, b);
        dist.update(this.parameters, this.total, h, upd, false);
    }

    protected double hildreth(FV a, double b) {
        double A = this.dotProduct(a, a);
        if (A <= 1.0E-19) {
            return 0.0;
        }
        return b / A;
    }

    public int dotProduct(FV fl, FV fl2) {
        if (this.hm1 == null) {
            this.hm1 = new IntIntHash(fl.size(), 0.4f);
        } else {
            this.hm1.clear();
        }
        fl.addFeaturesToMap(this.hm1);
        if (this.hm2 == null) {
            this.hm2 = new IntIntHash(fl2.size(), 0.4f);
        } else {
            this.hm2.clear();
        }
        fl2.addFeaturesToMap(this.hm2);
        int[] keys = this.hm1.keys();
        int result = 0;
        int i = 0;
        while (i < keys.length) {
            result += this.hm1.get(keys[i]) * this.hm2.get(keys[i]);
            ++i;
        }
        return result;
    }

    public float getScore(FV fv) {
        if (fv == null) {
            return 0.0f;
        }
        return fv.getScore(this.parameters, false);
    }

    @Override
    public final void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.parameters.length);
        float[] fArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            dos.writeFloat(d);
            ++n2;
        }
    }

    @Override
    public void read(DataInputStream dis) throws IOException {
        this.parameters = new float[dis.readInt()];
        int notZero = 0;
        int i = 0;
        while (i < this.parameters.length) {
            this.parameters[i] = dis.readFloat();
            if (this.parameters[i] != 0.0f) {
                ++notZero;
            }
            ++i;
        }
        DB.println("read parameters " + this.parameters.length + " not zero " + notZero);
    }

    public int countNZ() {
        int notZero = 0;
        int i = 0;
        while (i < this.parameters.length) {
            if (this.parameters[i] != 0.0f) {
                ++notZero;
            }
            ++i;
        }
        return notZero;
    }

    @Override
    public F2SF getFV() {
        return new F2SF(this.parameters);
    }

    public F2SP getFVP() {
        return new F2SP(this.parameters);
    }

    @Override
    public int size() {
        return this.parameters.length;
    }

    public void clear() {
        this.parameters = null;
        this.total = null;
    }
}

