/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Parse;
import is2.transitionR6j.O;
import is2.util.IntStack;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Stack;

public final class GuideOracle {
    final short[] _heads;
    final short[] _labels;
    Parse gold;
    final boolean proj;
    int[] order;

    public GuideOracle(short[] heads, short[] types, boolean proj) {
        this._heads = heads;
        this._labels = types;
        this.gold = new Parse(heads, types, 0.0f);
        this.order = GuideOracle.inorder(this.gold);
        this.proj = proj;
    }

    public O getOperation(IntStack s, IntStack input, int b, Parse p) {
        int j;
        int i = s.size() > 1 ? s.get(s.size() - 2) : -1;
        int n = j = s.size() > 0 ? s.get(s.size() - 1) : -1;
        if (!this.proj && i >= 0 && this.order[j] < this.order[i] && this.necessarySwapNV(this.gold, p, j, b, input, this.order)) {
            O o = new O(5);
            return o;
        }
        if (s.size() > 1 && i != 0 && this._heads[i] == j && this.done(this._heads, p, i)) {
            O o = new O(1);
            o.l = this._labels[i];
            return o;
        }
        if (s.size() > 1 && this._heads[j] == i && this.done(this._heads, p, j)) {
            O o = new O(2);
            o.l = this._labels[j];
            return o;
        }
        return O.SHIFT;
    }

    private boolean done(short[] _heads2, Parse p, int w1) {
        int i = 0;
        while (i < _heads2.length) {
            if (_heads2[i] == w1 && p.heads[i] != w1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasDependent(short[] _heads2, int w1) {
        int k = 0;
        while (k < _heads2.length) {
            if (this._heads[k] == w1) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private boolean necessarySwapNV(Parse gold, Parse parse, int left, int right, IntStack input, int[] order) {
        int index = input.size() - 1;
        if (index < 0) {
            return true;
        }
        int rc = -1;
        while (this.projectiveInterval(parse, left, right, order)) {
            if (rc == right) {
                return false;
            }
            if (gold.heads[left] == right) {
                return !this.leftComplete(gold, parse, left);
            }
            if (gold.heads[right] == left) {
                if (this.hasRightDependent(gold, right)) {
                    rc = this.getRightmostDescendant(gold, right);
                } else {
                    return false;
                }
            }
            if (index <= 0) break;
            left = right;
            right = input.get(index--);
        }
        return true;
    }

    private boolean necessarySwap(Parse gold, Parse parse, int node, IntStack input, int[] order) {
        int left = node;
        int index = input.size() - 1;
        if (index < 0) {
            return true;
        }
        int right = input.peek();
        int rc = -1;
        while (this.projectiveInterval(parse, left, right, order)) {
            if (rc == right) {
                return false;
            }
            if (gold.heads[node] == right) {
                return !this.leftComplete(gold, parse, node);
            }
            if (gold.heads[right] == node) {
                if (this.hasRightDependent(gold, right)) {
                    rc = this.getRightmostDescendant(gold, right);
                } else {
                    return false;
                }
            }
            if (index <= 0) break;
            left = right;
            right = input.get(--index);
        }
        return true;
    }

    private int getRightmostDescendant(Parse gold, int right) {
        Stack<Integer> s = new Stack<Integer>();
        HashSet<Integer> done = new HashSet<Integer>();
        int rightmost = -1;
        s.push(right);
        while (s.size() > 0) {
            int n = (Integer)s.pop();
            if (done.contains(n)) continue;
            int k1 = n + 1;
            while (k1 < gold.heads.length) {
                if (gold.heads[k1] == n) {
                    s.push(n);
                }
                ++k1;
            }
            done.add(n);
            if (rightmost >= n) continue;
            rightmost = n;
        }
        return rightmost;
    }

    private boolean hasRightDependent(Parse gold, int right) {
        int k = right + 1;
        while (k < gold.heads.length) {
            if (gold.heads[k] == right) {
                return true;
            }
            ++k;
        }
        return false;
    }

    private boolean projectiveInterval(Parse parse, int left, int right, int[] swapArray) {
        int l = swapArray[left];
        int r = swapArray[right];
        int node = -1;
        if (l > r) {
            return false;
        }
        int i = l + 1;
        while (i < r) {
            int j = 0;
            while (j < swapArray.length) {
                if (swapArray[j] == i) {
                    node = j;
                    break;
                }
                ++j;
            }
            while (parse.heads[node] >= 0) {
                node = parse.heads[node];
            }
            if (node != left && node != right) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean leftComplete(Parse gold, Parse parse, int right) {
        if (!this.hasLeftDependent(gold, right)) {
            return true;
        }
        if (!this.hasLeftDependent(parse, right)) {
            return false;
        }
        return this.getLeftmostDependent(gold, right) == this.getLeftmostDependent(parse, right);
    }

    private int getLeftmostDependent(Parse p, int right) {
        int i = 0;
        while (i < right) {
            if (p.heads[i] == right) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasLeftDependent(Parse gold, int right) {
        int i = 0;
        while (i < right) {
            if (gold.heads[i] == right) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] inorder(Parse p) {
        int[] order = new int[p.heads.length];
        Stack<Integer> stack = new Stack<Integer>();
        stack.push(0);
        int cnt = 0;
        BitSet done = new BitSet();
        while (!stack.isEmpty()) {
            int m;
            int k;
            int[] r;
            int n = (Integer)stack.pop();
            if (done.get(n)) continue;
            int[] l = GuideOracle.childrenLeft(n, p);
            boolean leftDone = true;
            if (l != null) {
                int k2 = 0;
                while (k2 < l.length) {
                    if (!done.get(l[k2])) {
                        leftDone = false;
                        break;
                    }
                    ++k2;
                }
            }
            if ((r = GuideOracle.childrenRight(n, p)) != null) {
                k = r.length - 1;
                while (k >= 0) {
                    m = r[k];
                    stack.push(m);
                    --k;
                }
            }
            if (l == null || leftDone) {
                order[n] = cnt++;
                done.set(n);
                continue;
            }
            stack.push(n);
            k = l.length - 1;
            while (k >= 0) {
                m = l[k];
                stack.push(m);
                --k;
            }
        }
        return order;
    }

    private static int[] childrenLeft(int h, Parse p) {
        int cnt = 0;
        int k = 0;
        while (k < p.heads.length) {
            if (p.heads[k] == h && k < h) {
                ++cnt;
            }
            ++k;
        }
        if (cnt == 0) {
            return null;
        }
        int[] chlds = new int[cnt];
        cnt = 0;
        int k2 = 0;
        while (k2 < p.heads.length) {
            if (p.heads[k2] == h && k2 < h) {
                chlds[cnt++] = k2;
            }
            ++k2;
        }
        return chlds;
    }

    private static int[] childrenRight(int h, Parse p) {
        int cnt = 0;
        int k = 0;
        while (k < p.heads.length) {
            if (p.heads[k] == h && k > h) {
                ++cnt;
            }
            ++k;
        }
        if (cnt == 0) {
            return null;
        }
        int[] chlds = new int[cnt];
        cnt = 0;
        int k2 = 0;
        while (k2 < p.heads.length) {
            if (p.heads[k2] == h && k2 > h) {
                chlds[cnt++] = k2;
            }
            ++k2;
        }
        return chlds;
    }
}

