/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Cluster;
import is2.data.D6;
import is2.data.Instances;
import is2.data.InstancesTagger;
import is2.data.Long2IntInterface;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.transitionR6j.MFO;
import is2.util.OptionsSuper;
import java.io.IOException;

public final class ExtractorT2
extends PipeGen {
    static final int _MAX = 67;
    private static final String STWRD = "STWRD";
    public static int s_pos;
    public static int s_word;
    public static int s_char;
    public static int s_type;
    public static int _ewrd;
    static int _CEND;
    public final MFO mf;
    public final D6 d1;
    public final D6 d2;
    public final D6 d3;
    public final D6 dw;
    public final D6 dwp;
    private Cluster cl;
    private OptionsSuper options;
    public static int corpusWrds;

    static {
        corpusWrds = 0;
    }

    public ExtractorT2(OptionsSuper options, MFO mf, Long2IntInterface li, Cluster cl) throws IOException {
        this.mf = mf;
        this.options = options;
        this.d1 = new D6(li);
        this.d2 = new D6(li);
        this.d3 = new D6(li);
        this.dw = new D6(li);
        this.dwp = new D6(li);
        this.cl = cl;
    }

    public Instances createInstances(String file, int skipStart, int skipEnd) {
        SentenceData09 instance1;
        InstancesTagger is = new InstancesTagger();
        CONLLReader09 depReader = new CONLLReader09(false);
        depReader.startReading(file);
        this.mf.register("POS", "<root-POS>");
        this.mf.register("WORD", "<root>");
        System.out.println("Registering feature parts ");
        int ic = 0;
        while ((instance1 = depReader.getNext()) != null) {
            ++ic;
            String[] w = instance1.forms;
            int i1 = 0;
            while (i1 < w.length) {
                this.mf.register("WORD", w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < w.length) {
                this.registerChars("C", w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < w.length) {
                this.registerChars("C", w[i1].toLowerCase());
                ++i1;
            }
            w = instance1.plemmas;
            i1 = 0;
            while (i1 < w.length) {
                this.mf.register("WORD", w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < w.length) {
                this.registerChars("C", w[i1]);
                ++i1;
            }
            w = instance1.gpos;
            i1 = 0;
            while (i1 < w.length) {
                this.mf.register("POS", w[i1]);
                ++i1;
            }
        }
        corpusWrds = this.mf.getFeatureCounter().get("WORD");
        System.out.println("words in corpus " + corpusWrds);
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, this.mf, 6);
        ExtractorT2.initFeatures();
        this.mf.calculateBits();
        this.initValues();
        System.out.println(this.mf.toString());
        depReader.startReading(file);
        int num1 = 0;
        int instanceCount = 0;
        System.out.print("Creating Instances: ");
        is.init(ic, this.mf);
        int del = 0;
        while (true) {
            SentenceData09 instance12;
            if (num1 % 100 == 0) {
                del = ExtractorT2.outValue(num1, del);
            }
            if (num1 >= skipStart && num1 < skipEnd && skipStart >= 0) {
                instance12 = depReader.getNext();
                if (instance12 == null) break;
                ++num1;
                continue;
            }
            instance12 = depReader.getNext(is);
            if (instance12 == null) break;
            is.fillChars(instance12, instanceCount, _CEND);
            if (num1 > this.options.count) break;
            ++num1;
            ++instanceCount;
        }
        ExtractorT2.outValue(num1, del);
        System.out.println();
        return is;
    }

    private void registerChars(String type, String word) {
        int i = 0;
        while (i < word.length()) {
            this.mf.register(type, Character.toString(word.charAt(i)));
            ++i;
        }
    }

    public void initValues() {
        s_pos = this.mf.getFeatureCounter().get("POS");
        s_word = this.mf.getFeatureCounter().get("WORD");
        s_type = 84;
        s_char = this.mf.getFeatureCounter().get("C");
        this.d1.a0 = s_type;
        this.d1.a1 = s_pos;
        this.d1.a2 = s_word;
        this.d1.a3 = s_word;
        this.d1.fix();
        this.d2.a0 = s_type;
        this.d2.a1 = s_pos;
        this.d2.a2 = s_pos;
        this.d2.a3 = s_pos;
        this.d2.a4 = s_pos;
        this.d2.a5 = s_pos;
        this.d2.a6 = s_pos;
        this.d2.fix();
        this.d3.a0 = s_type;
        this.d3.a1 = s_pos;
        this.d3.a2 = s_char;
        this.d3.a3 = s_char;
        this.d3.a4 = s_char;
        this.d3.a5 = s_char;
        this.d3.a6 = s_char;
        this.d3.a7 = s_char;
        this.d3.fix();
        this.dw.a0 = s_type;
        this.dw.a1 = s_pos;
        this.dw.a2 = s_word;
        this.dw.a3 = s_word;
        this.dw.a4 = s_word;
        this.dw.a5 = s_word;
        this.dw.a6 = s_word;
        this.dw.a7 = s_word;
        this.dw.fix();
        this.dwp.a0 = s_type;
        this.dwp.a1 = s_pos;
        this.dwp.a2 = s_word;
        this.dwp.a3 = s_pos;
        this.dwp.a4 = s_word;
        this.dwp.fix();
    }

    public static void initFeatures() {
        MFO mf = new MFO();
        _ewrd = mf.register("WORD", "END");
        _CEND = mf.register("C", "END");
    }

    public final void addFeatures(InstancesTagger is, int ic, String fs, int i, int[] forms, int[] lemmas, long[] vs) {
        short c0 = is.chars[ic][i][0];
        short c1 = is.chars[ic][i][1];
        short c2 = is.chars[ic][i][2];
        short c3 = is.chars[ic][i][3];
        short c4 = is.chars[ic][i][4];
        short c5 = is.chars[ic][i][5];
        short e0 = is.chars[ic][i][6];
        short e1 = is.chars[ic][i][7];
        short e2 = is.chars[ic][i][8];
        short e3 = is.chars[ic][i][9];
        short e4 = is.chars[ic][i][10];
        int f = 1;
        int n = 0;
        int upper = 0;
        int number = 1;
        int k1 = 0;
        while (k1 < fs.length()) {
            char c = fs.charAt(k1);
            if (Character.isUpperCase(c)) {
                if (k1 == 0) {
                    upper = 1;
                } else if (upper == 1) {
                    upper = 3;
                } else if (upper == 0) {
                    upper = 2;
                }
            }
            if (Character.isDigit(c) && k1 == 0) {
                number = 2;
            } else if (Character.isDigit(c) && number == 1) {
                number = 3;
            }
            ++k1;
        }
        int form = forms[i];
        int form2 = forms[i] < corpusWrds ? forms[i] : -1;
        int len = forms.length;
        this.d1.v0 = f++;
        this.d1.v2 = form2;
        vs[n++] = this.d1.c3();
        this.d1.v0 = f++;
        this.d1.v2 = is.formlc[ic][i];
        vs[n++] = this.d1.c3();
        this.d3.v2 = c0;
        this.d3.v3 = c1;
        this.d3.v4 = c2;
        this.d3.v5 = c3;
        this.d3.v6 = c4;
        this.d3.v0 = f++;
        vs[n++] = this.d3.c3();
        this.d3.v0 = f++;
        vs[n++] = this.d3.c4();
        this.d3.v0 = f++;
        vs[n++] = this.d3.c5();
        this.d3.v0 = f++;
        vs[n++] = this.d3.c6();
        this.d3.v0 = f++;
        vs[n++] = this.d3.c7();
        if (form != -1) {
            this.d3.v2 = c2;
            this.d3.v3 = c3;
            this.d3.v4 = c4;
            this.d3.v5 = c5;
            this.d3.v6 = this.cl.getLP(form);
            this.d3.v0 = f;
            vs[n++] = this.d3.c6();
            this.d3.v0 = f + 1;
            vs[n++] = this.d3.c7();
        }
        f += 2;
        if (form > 0) {
            this.d3.v0 = f;
            this.d3.v5 = this.cl.getLP(form);
            vs[n++] = this.d3.c6();
            this.d3.v0 = f + 1;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.d3.c5();
            this.d3.v0 = f + 2;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.d3.c4();
        }
        f += 3;
        this.d3.v2 = e0;
        this.d3.v3 = e1;
        this.d3.v4 = e2;
        this.d3.v5 = e3;
        this.d3.v6 = e4;
        this.d3.v0 = f++;
        vs[n++] = this.d3.c3();
        this.d3.v0 = f++;
        vs[n++] = this.d3.c4();
        vs[n++] = this.d3.csa(3, upper);
        this.d3.v0 = f++;
        vs[n++] = this.d3.c5();
        vs[n++] = this.d3.csa(3, upper);
        this.d3.v0 = f++;
        vs[n++] = this.d3.c6();
        vs[n++] = this.d3.csa(3, upper);
        this.d3.v0 = f++;
        vs[n++] = this.d3.c7();
        vs[n++] = this.d3.csa(3, upper);
        if (form > 0) {
            this.d3.v0 = f;
            this.d3.v5 = this.cl.getLP(form);
            vs[n++] = this.d3.c6();
            this.d3.v0 = f + 1;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.d3.c5();
            this.d3.v0 = f + 2;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.d3.c4();
            this.d3.v2 = e0;
            this.d3.v3 = e1;
            this.d3.v4 = e2;
            this.d3.v0 = f + 3;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.d3.c5();
            this.d3.v0 = f + 4;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.d3.c4();
        }
        f += 5;
        this.d3.v0 = f++;
        this.d3.v2 = c1;
        this.d3.v3 = c2;
        this.d3.v4 = c3;
        vs[n++] = this.d3.c5();
        this.d3.v0 = f++;
        this.d3.v2 = c2;
        this.d3.v3 = c3;
        this.d3.v4 = c4;
        vs[n++] = this.d3.c5();
        this.d3.v0 = f++;
        this.d3.v2 = c3;
        this.d3.v3 = c4;
        this.d3.v4 = c5;
        vs[n++] = this.d3.c5();
        this.d3.v0 = f++;
        this.d3.v2 = c1;
        this.d3.v3 = c2;
        this.d3.v4 = c3;
        this.d3.v5 = c4;
        vs[n++] = this.d3.c6();
        this.d3.v0 = f++;
        this.d3.v2 = c2;
        this.d3.v3 = c3;
        this.d3.v4 = c4;
        this.d3.v5 = c5;
        vs[n++] = this.d3.c6();
        if (i + 1 < len && forms[i + 1] < corpusWrds) {
            this.dw.v0 = f;
            this.dw.v2 = forms[i + 1];
            this.dw.v3 = form2;
            vs[n++] = this.dw.c4();
        }
        ++f;
        if (len > i + 1) {
            if (forms[i + 1] < corpusWrds) {
                this.dw.v0 = f;
                this.dw.v2 = forms[i + 1];
                vs[n++] = this.dw.c3();
            }
            this.d3.v0 = f + 1;
            this.d3.v2 = is.chars[ic][i + 1][0];
            vs[n++] = this.d3.c3();
            this.d3.v0 = f + 2;
            this.d3.v2 = is.chars[ic][i + 1][6];
            vs[n++] = this.d3.c3();
            this.d3.v2 = e0;
            this.d3.v3 = e1;
            this.d3.v0 = f + 3;
            this.d3.v4 = is.chars[ic][i + 1][0];
            vs[n++] = this.d3.c5();
            this.d3.v0 = f + 4;
            this.d3.v4 = is.chars[ic][i + 1][6];
            vs[n++] = this.d3.c5();
            if (is.chars[ic][i + 1][11] > 1) {
                this.d3.v0 = f + 5;
                this.d3.v2 = is.chars[ic][i + 1][0];
                this.d3.v3 = is.chars[ic][i + 1][1];
                vs[n++] = this.d3.c4();
                this.d3.v0 = f + 6;
                this.d3.v2 = is.chars[ic][i + 1][6];
                this.d3.v3 = is.chars[ic][i + 1][7];
                vs[n++] = this.d3.c4();
                this.d3.v2 = e0;
                this.d3.v3 = e1;
                this.d3.v0 = f + 7;
                this.d3.v4 = is.chars[ic][i + 1][0];
                this.d3.v5 = is.chars[ic][i + 1][1];
                vs[n++] = this.d3.c6();
                this.d3.v0 = f + 8;
                this.d3.v4 = is.chars[ic][i + 1][6];
                this.d3.v5 = is.chars[ic][i + 1][7];
                vs[n++] = this.d3.c6();
                if (forms[i + 1] > 0) {
                    this.d3.v0 = f + 9;
                    this.d3.v2 = is.chars[ic][i + 1][0];
                    this.d3.v3 = is.chars[ic][i + 1][1];
                    this.d3.v4 = this.cl.getLP(forms[i + 1]);
                    vs[n++] = this.d3.c5();
                    this.d3.v0 = f + 10;
                    this.d3.v2 = is.chars[ic][i + 1][6];
                    this.d3.v3 = is.chars[ic][i + 1][7];
                    this.d3.v4 = this.cl.getLP(forms[i + 1]);
                    vs[n++] = this.d3.c5();
                }
            }
            if (forms[i + 1] > 0) {
                this.dw.v0 = f + 11;
                this.dw.v2 = this.cl.getLP(forms[i + 1]);
                this.dw.v3 = form2;
                vs[n++] = this.dw.c4();
            }
            if (len > i + 2 && forms[i + 2] < corpusWrds && forms[i + 1] < corpusWrds) {
                this.dw.v0 = f + 12;
                this.dw.v2 = forms[i + 2];
                this.dw.v3 = forms[i + 1];
                vs[n++] = this.dw.c4();
                vs[n++] = this.dw.c3();
            }
            if (len > i + 3 && forms[i + 3] < corpusWrds && forms[i + 2] < corpusWrds) {
                this.dw.v0 = f + 14;
                this.dw.v2 = forms[i + 3];
                this.dw.v3 = forms[i + 2];
                vs[n++] = this.dw.c4();
                vs[n++] = this.dw.c3();
            }
        }
        f += 15;
        this.d2.v0 = f++;
        this.d2.v2 = is.chars[ic][i][11];
        vs[n++] = this.d2.c3();
        this.d2.v0 = f++;
        this.d2.v2 = number;
        vs[n++] = this.d2.c3();
        if (lemmas[i] < corpusWrds) {
            this.d1.v0 = f;
            this.d1.v2 = lemmas[i];
            vs[n++] = this.d1.c3();
        }
        ++f;
        if (i != 0 && len > i + 1 && lemmas[i - 1] < corpusWrds && lemmas[i + 1] < corpusWrds) {
            this.dw.v0 = f;
            this.dw.v2 = lemmas[i - 1];
            this.dw.v3 = lemmas[i + 1];
            vs[n++] = this.dw.c4();
        }
        ++f;
        if (i > 0) {
            this.dw.v0 = f;
            this.dw.v2 = forms[i - 1] < corpusWrds ? forms[i - 1] : -1;
            vs[n++] = this.dw.c3();
            ++f;
            if (lemmas[i - 1] < corpusWrds) {
                this.dw.v0 = f;
                this.dw.v2 = lemmas[i - 1];
                vs[n++] = this.dw.c3();
            }
            ++f;
            if (i > 1) {
                if (forms[i - 2] < corpusWrds) {
                    this.dw.v0 = f;
                    this.dw.v2 = forms[i - 2];
                    vs[n++] = this.dw.c3();
                }
                ++f;
                if (i > 2) {
                    if (forms[i - 3] < corpusWrds && forms[i - 2] < corpusWrds) {
                        this.dw.v0 = f;
                        this.dw.v2 = forms[i - 3];
                        this.dw.v3 = forms[i - 2];
                        vs[n++] = this.dw.c4();
                    }
                    ++f;
                }
            }
        }
        vs[n] = Integer.MIN_VALUE;
    }

    public final void addFeatPos(int i, short[] pos, int[] forms, long[] vs) {
        int n = 0;
        int f = 57;
        int len = pos.length;
        if (i + 2 < len) {
            this.d2.v0 = f;
            this.d2.v2 = pos[i + 1];
            this.d2.v3 = pos[i + 2];
            vs[n++] = this.d2.c4();
        }
        ++f;
        if (i + 1 < len) {
            this.d2.v0 = f;
            this.d2.v2 = pos[i + 1];
            vs[n++] = this.d2.c3();
        }
        ++f;
        if (i > 0) {
            this.d2.v0 = f++;
            this.d2.v2 = pos[i - 1];
            vs[n++] = this.d2.c3();
            if (len > i + 1) {
                this.d2.v0 = f;
                this.d2.v2 = pos[i - 1];
                this.d2.v3 = pos[i + 1];
                vs[n++] = this.d2.c4();
            }
            ++f;
            if (i > 1) {
                this.d2.v0 = f++;
                this.d2.v2 = pos[i - 2];
                vs[n++] = this.d2.c3();
                this.d2.v0 = f++;
                this.d2.v2 = pos[i - 1];
                this.d2.v3 = pos[i - 2];
                vs[n++] = this.d2.c4();
                if (forms[i - 1] < corpusWrds) {
                    this.dwp.v0 = f;
                    this.dwp.v2 = forms[i - 1];
                    this.dwp.v3 = pos[i - 2];
                    vs[n++] = this.dwp.c4();
                }
                ++f;
                if (forms[i - 2] < corpusWrds) {
                    this.dwp.v0 = f;
                    this.dwp.v2 = forms[i - 2];
                    this.dwp.v3 = pos[i - 1];
                    vs[n++] = this.dwp.c4();
                }
                ++f;
                if (i > 2) {
                    this.d2.v0 = f++;
                    this.d2.v2 = pos[i - 3];
                    vs[n++] = this.d2.c3();
                    this.d2.v0 = f++;
                    this.d2.v2 = pos[i - 2];
                    this.d2.v3 = pos[i - 3];
                    vs[n++] = this.d2.c4();
                }
            }
        }
        vs[n] = Integer.MIN_VALUE;
    }

    public final void addFeatPos2(short[] heads, int i, short[] pos, int[] forms, long[] vs) {
        int n = 0;
        int f = 68;
        short tc = pos[i];
        short th = heads[i];
        int thp = th >= 0 ? pos[th] : -1;
        this.d2.v0 = f++;
        this.d2.v2 = tc;
        this.d2.v3 = thp;
        vs[n++] = this.d2.c4();
        this.d2.v0 = f++;
        this.d2.v2 = thp;
        vs[n++] = this.d2.c3();
        this.dw.v0 = f++;
        this.dw.v2 = tc;
        this.dw.v3 = th >= 0 ? forms[th] : -1;
        vs[n++] = this.dw.c4();
        this.d2.v0 = f++;
        int[] children = this.getChildren(i, heads);
        this.d2.v2 = children.length > 0 ? pos[children[0]] : -1;
        this.d2.v3 = children.length > 1 ? pos[children[1]] : -1;
        this.d2.v4 = children.length > 2 ? pos[children[2]] : -1;
        vs[n++] = this.d2.c3();
        vs[n++] = this.d2.c4();
        vs[n++] = this.d2.c5();
        this.d2.v0 = f++;
        children = this.getChildren(th, heads);
        this.d2.v0 = f++;
        this.d2.v2 = children.length > 0 ? pos[children[0]] : -1;
        this.d2.v3 = children.length > 1 ? pos[children[1]] : -1;
        this.d2.v4 = children.length > 2 ? pos[children[2]] : -1;
        vs[n++] = this.d2.c3();
        vs[n++] = this.d2.c4();
        vs[n++] = this.d2.c5();
        int thm1 = th > 0 ? pos[th - 1] : -1;
        int thp1 = th < pos.length - 1 ? pos[th + 1] : -1;
        this.d2.v0 = f++;
        this.d2.v2 = tc;
        this.d2.v3 = thp;
        vs[n++] = this.d2.c4();
        this.d2.v0 = f++;
        this.d2.v3 = thp1;
        vs[n++] = this.d2.c4();
        this.d2.v0 = f++;
        this.d2.v3 = thm1;
        vs[n++] = this.d2.c4();
        this.d2.v0 = f++;
        this.d2.v3 = thp;
        this.d2.v4 = thm1;
        vs[n++] = this.d2.c5();
        this.d2.v0 = f++;
        this.d2.v3 = thp;
        this.d2.v4 = thp1;
        vs[n++] = this.d2.c5();
        vs[n] = Integer.MIN_VALUE;
    }

    private int[] getChildren(int h, short[] heads) {
        int cnt = 0;
        int i = 0;
        while (i < heads.length) {
            if (heads[i] == h) {
                ++cnt;
            }
            ++i;
        }
        int[] children = new int[cnt];
        cnt = 0;
        int i2 = 0;
        while (i2 < heads.length) {
            if (heads[i2] == h) {
                children[cnt++] = i2;
            }
            ++i2;
        }
        return children;
    }
}

