/*
 * Decompiled with CFR 0.152.
 */
package is2.transitionR6j;

import is2.data.Cluster;
import is2.data.F2SF;
import is2.data.Instances;
import is2.data.InstancesTagger;
import is2.data.Long2IntInterface;
import is2.data.Parse;
import is2.transitionR6j.Edges;
import is2.transitionR6j.Encoder;
import is2.transitionR6j.Extender;
import is2.transitionR6j.ExtractorPet;
import is2.transitionR6j.ExtractorR;
import is2.transitionR6j.Guide;
import is2.transitionR6j.GuideOracle;
import is2.transitionR6j.O;
import is2.transitionR6j.POS;
import is2.transitionR6j.ParametersFloat;
import is2.transitionR6j.Parser;
import is2.transitionR6j.Pipe;
import is2.transitionR6j.State;
import is2.transitionR6j.Tagger2;
import is2.util.IntStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Decoder {
    static final int LA = 1;
    static final int RA = 2;
    static final int SHIFT = 3;
    static final int REDUCE = 4;
    static final int SWAP = 5;
    public static long timeDecoder;
    public static long t1;
    public static long t2;
    public static long t3;
    public static long t4;
    public static long t5;
    public static long t6;
    public static long t7;
    static int beam;
    static int half;
    public ExecutorService executerService = Executors.newFixedThreadPool(Parser.THREADS);
    private final Guide g;
    ExtractorPet[] extp;
    ExtractorR[] extractor;
    Extender[] extender;
    public static int correctPos;
    public static int wrongPos;
    Long2IntInterface li;
    public static float allNth;
    static int errors;
    static int count;
    public static int forcedStop;

    static {
        beam = 200;
        half = 20;
        correctPos = 0;
        wrongPos = 0;
        allNth = 0.0f;
        errors = 0;
        count = 0;
    }

    public Decoder(Long2IntInterface long2int, ParametersFloat params, Cluster cl) {
        this(long2int, params, cl, 0, 0);
    }

    public Decoder(Long2IntInterface li, ParametersFloat params, Cluster cluster, int startPosSelection, int currentTrainingIteration) {
        int size = beam + half + 2;
        this.extp = new ExtractorPet[size];
        this.extractor = new ExtractorR[size];
        this.extender = new Extender[size];
        this.li = li;
        if (this.extractor[0] == null) {
            int k1 = 0;
            while (k1 < this.extractor.length) {
                this.extractor[k1] = new ExtractorR(li, false, 1);
                this.extractor[k1].init();
                ++k1;
            }
        }
        int k = 0;
        while (k < this.extp.length) {
            this.extp[k] = new ExtractorPet(params.getFVP(), cluster, li);
            ++k;
        }
        this.g = new Guide();
    }

    public R decode(boolean projective, GuideOracle goldGuide, ParametersFloat params, int upd, InstancesTagger is, int ic, Cluster cluster, POS[][] pxx) throws InterruptedException {
        boolean all;
        int k1;
        State gs;
        long ts = System.nanoTime();
        this.g.initialize(is, ic);
        State state = gs = goldGuide == null ? null : new State(is.pposs[ic].length, true);
        if (goldGuide != null) {
            int k = 0;
            while (k < pxx[0].length) {
                gs.pos[k] = (short)pxx[0][k].p;
                ++k;
            }
            k = 0;
            while (k < pxx[0].length) {
                int k2 = 1;
                while (k2 < Tagger2.size) {
                    if (pxx[k2][k].p == is.gpos[ic][k] && !(pxx[0][k].s - pxx[k2][k].s > Tagger2.THRESHOLD)) {
                        gs.pos[k] = (short)pxx[k2][k].p;
                        gs.nth[k] = (short)k2;
                    }
                    ++k2;
                }
                ++k;
            }
        }
        if (this.executerService.isShutdown()) {
            this.executerService = Executors.newCachedThreadPool();
        }
        ArrayList<State> outs = new ArrayList<State>();
        State s0 = new State(is.length(ic), goldGuide != null);
        outs.add(s0);
        s0.pos = new short[pxx[0].length];
        int k = 0;
        while (k < pxx[0].length) {
            s0.pos[k] = (short)pxx[0][k].p;
            ++k;
        }
        ArrayList exstsset = new ArrayList();
        ArrayList<Extender> exts = new ArrayList<Extender>();
        ArrayList<Encoder> encoder = new ArrayList<Encoder>();
        if (this.extender[0] == null) {
            k1 = 0;
            while (k1 < this.extender.length) {
                this.extender[k1] = new Extender(this.extractor[k1], this.extp[k1], params.getFV(), goldGuide != null, cluster, pxx);
                ++k1;
            }
        }
        k1 = 0;
        while (k1 < this.extender.length) {
            this.extender[k1].is = is;
            this.extender[k1].i = ic;
            this.extender[k1].g = this.g;
            this.extender[k1].px = pxx;
            ++k1;
        }
        HashMap<String, State> bestParses = new HashMap<String, State>();
        ArrayList<State> alternatives = new ArrayList<State>();
        long ts2 = System.nanoTime();
        t1 += ts2 - ts;
        int j = 0;
        int max = is.length(ic) * 10;
        do {
            long ts3 = System.nanoTime();
            if (++j > max) {
                ++forcedStop;
                break;
            }
            if (goldGuide != null) {
                O go = goldGuide.getOperation(gs.s, gs.b, gs.b.size() > 0 ? gs.b.peek() : -1, gs.p);
                if (go.o == 1 || go.o == 2) {
                    int sm0 = gs.s.size() > 1 ? gs.s.get(gs.s.size() - 2) : -1;
                    int sm1 = gs.s.size() > 0 ? gs.s.get(gs.s.size() - 1) : -1;
                    short[] labels = Edges.get(gs.pos[sm0], gs.pos[sm1]);
                    boolean found = false;
                    short[] sArray = labels;
                    int n = labels.length;
                    int n2 = 0;
                    while (n2 < n) {
                        short l = sArray[n2];
                        if (go.l == l) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) {
                        Edges.put(gs.pos[sm1], gs.pos[sm0], (short)go.l);
                        Edges.put(gs.pos[sm0], gs.pos[sm1], (short)go.l);
                    }
                }
                if (go == null || !Decoder.possible(go.o, gs.s, gs.b.peek(), gs.p)) break;
                gs = State.perform(go, gs);
            }
            exts.clear();
            int k2 = 0;
            while (k2 < outs.size()) {
                this.extender[k2].s = (State)outs.get(k2);
                exts.add(this.extender[k2]);
                ++k2;
            }
            long ts4 = System.nanoTime();
            t2 += ts4 - ts3;
            this.executerService.invokeAll(exts);
            long ts5 = System.nanoTime();
            t3 += ts5 - ts4;
            bestParses.clear();
            alternatives.clear();
            for (Extender e : exts) {
                block10: for (State s : e.r) {
                    State bestState = (State)bestParses.get(s.sig);
                    if (bestState == null) {
                        bestParses.put(s.sig, s);
                        continue;
                    }
                    if (bestState.sig.equals(s.sig) && s.score() == bestState.score()) {
                        alternatives.add(s);
                        continue;
                    }
                    if (bestState.score() < s.score()) {
                        bestParses.put(s.sig, s);
                        alternatives.add(bestState);
                        int k3 = 0;
                        while (k3 < bestState.pos.length) {
                            if (bestState.pos[k3] != s.pos[k3]) continue block10;
                            ++k3;
                        }
                        continue;
                    }
                    alternatives.add(s);
                }
            }
            exstsset.clear();
            exstsset.addAll(bestParses.values());
            Collections.sort(exstsset);
            outs.clear();
            if (exstsset.size() > beam) {
                outs.addAll(exstsset.subList(0, beam));
            } else {
                outs.addAll(exstsset);
            }
            Collections.sort(alternatives);
            int counter = 0;
            for (State s : alternatives) {
                outs.add(s);
                if (counter++ >= half) break;
            }
            alternatives.clear();
            exstsset.clear();
            long ts6 = System.nanoTime();
            t4 += ts6 - ts5;
            if (goldGuide != null) {
                boolean beamContainsGold = false;
                for (State x : outs) {
                    beamContainsGold = gs.contains(x);
                    if (beamContainsGold) break;
                }
                if (!beamContainsGold) break;
            }
            long ts7 = System.nanoTime();
            t5 += ts7 - ts6;
            all = true;
            for (State f : outs) {
                if (f.b.size() > 0 || f.s.size() > 1) {
                    all = false;
                }
                if (!f.b.isEmpty() || f.s.size() >= 2 || max <= 2 * f.steps) continue;
                max = 2 * f.steps;
            }
            long ts8 = System.nanoTime();
            t6 += ts8 - ts7;
        } while (!all);
        long ts9 = System.nanoTime();
        if (goldGuide != null) {
            State s = (State)outs.get(0);
            double errs = Pipe.errors(is, ic, s.p);
            errors = (int)((double)errors + errs);
            count += is.length(ic);
            if (!gs.contains(s) && errs > 0.0) {
                float ee = gs.diff(s) + 1;
                encoder.clear();
                encoder.add(new Encoder(is, ic, s.pos, s.p.heads, s.p.labels, cluster, new State(is.pposs[ic].length, true), false, this.extractor[0], this.extp[0], pxx, s.getHistory(), s.nth, "pred"));
                encoder.add(new Encoder(is, ic, gs.pos, gs.p.heads, gs.p.labels, cluster, new State(is.pposs[ic].length, true), false, this.extractor[1], this.extp[1], pxx, gs.getHistory(), gs.nth, "gold"));
                this.executerService.invokeAll(encoder);
                params.update(((Encoder)encoder.get((int)1)).f, ((Encoder)encoder.get((int)0)).f, upd, ee, s.steps, gs.steps);
            }
        }
        long ts10 = System.nanoTime();
        t7 += ts9 - ts10;
        State s = (State)outs.get(0);
        Parse out = ((State)outs.get((int)0)).p;
        int k4 = 1;
        while (k4 < s.nth.length) {
            if (is.gpos[ic][k4] == s.pos[k4]) {
                ++correctPos;
            } else {
                ++wrongPos;
            }
            ++k4;
        }
        float nthx = 0.0f;
        int k5 = 1;
        while (k5 < s.nth.length) {
            nthx += (float)s.nth[k5];
            ++k5;
        }
        allNth += nthx / (float)(s.nth.length - 1);
        out.heads[0] = -1;
        if (goldGuide == null) {
            int i = 1;
            while (i < out.heads.length) {
                if (out.heads[i] == -1) {
                    Decoder.attach(is, ic, this.extp[0], this.g, goldGuide, params, out, 3, i, pxx, s.pos, s.nth, s);
                }
                ++i;
            }
        }
        timeDecoder += System.nanoTime() - ts;
        return new R(out, s.pos);
    }

    private static void attach(Instances is, int ic, ExtractorPet ex2, Guide g, GuideOracle goldGuide, ParametersFloat params, Parse out, int last, int i, POS[][] pxx, short[] pos, short[] nth, State state) {
        IntStack s = new IntStack(out.heads.length);
        IntStack b = new IntStack(out.heads.length);
        F2SF fx = params.getFV();
        int bestH = -1;
        int bestL = 0;
        float best = -100.0f;
        int p = 0;
        while (p < out.heads.length) {
            s.clear();
            b.clear();
            if (p < i) {
                s.push(p);
                s.push(i);
                for (O o : g.getOperation(fx, ex2, state, pxx)) {
                    if (o.o != 2 || !(best < o.p)) continue;
                    best = o.p;
                    bestH = p;
                    bestL = o.l;
                }
            } else if (p > i) {
                s.push(i);
                s.push(p);
                for (O o : g.getOperation(fx, ex2, state, pxx)) {
                    if (o.o != 1 || !(best < o.p)) continue;
                    best = o.p;
                    bestH = p;
                    bestL = o.l;
                }
            }
            ++p;
        }
        out.heads[i] = (short)bestH;
        out.labels[i] = (short)bestL;
    }

    static boolean hasHead(Parse p, Integer peek) {
        if (peek == null) {
            return false;
        }
        return p.heads[peek] >= 0;
    }

    public static String getInfo() {
        return "Beam size: " + beam;
    }

    public static final boolean possible(int op, IntStack s, int b, Parse p) {
        if (op == 3 && b >= 0) {
            return true;
        }
        if (op == 1 && s.size() > 1 && s.get(s.size() - 2) != 0) {
            return true;
        }
        if (op == 2 && s.size() > 1) {
            return true;
        }
        return op == 5 && s.size() > 1 && s.get(s.size() - 2) < s.peek();
    }

    public static class R {
        Parse parse;
        short[] pos;

        public R(Parse parse, short[] pos) {
            this.parse = parse;
            this.pos = pos;
        }
    }
}

