/*
 * Decompiled with CFR 0.152.
 */
package is2.tag;

import is2.data.Cluster;
import is2.data.F2SF;
import is2.data.Instances;
import is2.data.InstancesTagger;
import is2.data.Long2IntInterface;
import is2.data.ParametersFloat;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.tag.Lexicon;
import is2.tag.MFO;
import is2.tag.POS;
import is2.tools.IPipe;
import is2.util.OptionsSuper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class ExtractorT2
extends PipeGen
implements IPipe {
    static final int _MAX = 71;
    private static final String STWRD = "STWRD";
    private static final String STPOS = "STPOS";
    private static short s_pos;
    private static short s_word;
    private static short s_char;
    protected static short s_type;
    private static int _strp;
    private static int _ewrd;
    static int _CEND;
    public String[] types;
    public final MFO mf;
    final MFO.Data4 d1 = new MFO.Data4();
    final MFO.Data4 d2 = new MFO.Data4();
    final MFO.Data4 d3 = new MFO.Data4();
    final MFO.Data4 dw = new MFO.Data4();
    final MFO.Data4 dwp = new MFO.Data4();
    Cluster cl;
    private OptionsSuper options;
    public HashMap<Integer, int[]> _pps = new HashMap();
    private Lexicon lx;
    public int corpusWrds = 0;

    public ExtractorT2(OptionsSuper options, MFO mf) throws IOException {
        this.mf = mf;
        this.options = options;
    }

    @Override
    public Instances createInstances(String file) {
        return this.createInstances(file, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public Instances createInstances(String file, int skipStart, int skipEnd) {
        void var8_12;
        int k;
        SentenceData09 sentenceData09;
        InstancesTagger is = new InstancesTagger();
        CONLLReader09 depReader = new CONLLReader09(false);
        depReader.startReading(file);
        this.mf.register("POS", "<root-POS>");
        this.mf.register("WORD", "<root>");
        System.out.println("Registering feature parts ");
        HashMap pps = new HashMap();
        int ic = 0;
        while ((sentenceData09 = depReader.getNext()) != null) {
            ++ic;
            Object w = sentenceData09.forms;
            int i1 = 0;
            while (i1 < ((Object)w).length) {
                this.mf.register("WORD", (String)w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < ((Object)w).length) {
                this.registerChars("C", (String)w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < ((Object)w).length) {
                this.registerChars("C", ((String)w[i1]).toLowerCase());
                ++i1;
            }
            w = sentenceData09.plemmas;
            i1 = 0;
            while (i1 < ((Object)w).length) {
                this.mf.register("WORD", (String)w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < ((Object)w).length) {
                this.registerChars("C", (String)w[i1]);
                ++i1;
            }
            w = sentenceData09.gpos;
            i1 = 0;
            while (i1 < ((Object)w).length) {
                this.mf.register("POS", (String)w[i1]);
                ++i1;
            }
            i1 = 0;
            while (i1 < ((Object)w).length) {
                HashSet<Integer> ps = (HashSet<Integer>)pps.get(this.mf.getValue("POS", (String)w[i1]));
                if (ps == null) {
                    ps = new HashSet<Integer>();
                    pps.put(this.mf.getValue("POS", (String)w[i1]), ps);
                }
                if (i1 + 1 < ((Object)w).length) {
                    ps.add(this.mf.getValue("POS", (String)w[i1 + 1]));
                }
                ++i1;
            }
        }
        for (Map.Entry entry : pps.entrySet()) {
            int[] ps = new int[((HashSet)entry.getValue()).size()];
            int j = 0;
            Integer[] integerArray = ((HashSet)entry.getValue()).toArray(new Integer[0]);
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                k = integerArray[n2];
                ps[j++] = k;
                ++n2;
            }
            this._pps.put((Integer)entry.getKey(), ps);
        }
        this.corpusWrds = this.mf.getFeatureCounter().get("WORD");
        System.out.println("words in corpus " + this.corpusWrds);
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, this.mf, 6);
        this.lx = this.options.lexicon == null ? new Lexicon(new byte[0][0]) : new Lexicon(this.options.lexicon, this.mf);
        this.initFeatures();
        this.mf.calculateBits();
        this.initValues();
        System.out.println(this.mf.toString());
        depReader.startReading(file);
        boolean bl = false;
        int instanceCount = 0;
        System.out.print("Creating Instances: ");
        is.init(ic, this.mf);
        int del = 0;
        while (true) {
            if (var8_12 % 100 == false) {
                del = ExtractorT2.outValue((int)var8_12, del);
            }
            if (var8_12 >= skipStart && var8_12 < skipEnd && skipStart >= 0) {
                SentenceData09 instance12 = depReader.getNext();
                if (instance12 == null) break;
                ++var8_12;
                continue;
            }
            SentenceData09 instance13 = depReader.getNext(is);
            if (instance13 == null) break;
            is.fillChars(instance13, instanceCount, _CEND);
            k = 0;
            while (k < instance13.length()) {
                if (instance13.ppos[k].contains("\\|")) {
                    is.pposs[var8_12][k] = (short)this.mf.getValue("FM", instance13.ppos[k].split("\\|")[1]);
                }
                ++k;
            }
            if (var8_12 > this.options.count) break;
            ++var8_12;
            ++instanceCount;
        }
        ExtractorT2.outValue((int)var8_12, del);
        System.out.println();
        this.types = MFO.reverse(this.mf.getFeatureSet().get("POS"));
        return is;
    }

    private void registerChars(String type, String word) {
        int i = 0;
        while (i < word.length()) {
            this.mf.register(type, Character.toString(word.charAt(i)));
            ++i;
        }
    }

    @Override
    public void initValues() {
        s_pos = this.mf.getFeatureBits("POS");
        s_word = this.mf.getFeatureBits("WORD");
        s_type = this.mf.getFeatureBits("TYPE");
        s_char = this.mf.getFeatureBits("C");
        this.d1.a0 = s_type;
        this.d1.a1 = s_pos;
        this.d1.a2 = s_word;
        this.d1.a3 = s_word;
        this.d2.a0 = s_type;
        this.d2.a1 = s_pos;
        this.d2.a2 = s_pos;
        this.d2.a3 = s_pos;
        this.d2.a4 = s_pos;
        this.d2.a5 = s_pos;
        this.d2.a6 = s_pos;
        this.d3.a0 = s_type;
        this.d3.a1 = s_pos;
        this.d3.a2 = s_char;
        this.d3.a3 = s_char;
        this.d3.a4 = s_char;
        this.d3.a5 = s_char;
        this.d3.a6 = s_char;
        this.d3.a7 = s_char;
        this.dw.a0 = s_type;
        this.dw.a1 = s_pos;
        this.dw.a2 = s_word;
        this.dw.a3 = s_word;
        this.dw.a4 = s_word;
        this.dw.a5 = s_word;
        this.dw.a6 = s_word;
        this.dw.a7 = s_word;
        this.dwp.a0 = s_type;
        this.dwp.a1 = s_pos;
        this.dwp.a2 = s_word;
        this.dwp.a3 = s_pos;
        this.dwp.a4 = s_word;
    }

    @Override
    public void initFeatures() {
        int t = 0;
        while (t < 67) {
            this.mf.register("TYPE", "F" + t);
            ++t;
        }
        this.mf.register("POS", "MID");
        _strp = this.mf.register("POS", "STR");
        this.mf.register("POS", "END");
        this.mf.register("WORD", "STR");
        _ewrd = this.mf.register("WORD", "END");
        _CEND = this.mf.register("C", "END");
        this.mf.register("WORD", STWRD);
        this.mf.register("POS", STPOS);
    }

    public final void addFeatures(InstancesTagger is, int ic, String fs, int i, short[] pposs, int[] forms, int[] lemmas, long[] vs) {
        int c0 = is.chars[ic][i][0];
        int c1 = is.chars[ic][i][1];
        int c2 = is.chars[ic][i][2];
        int c3 = is.chars[ic][i][3];
        int c4 = is.chars[ic][i][4];
        int c5 = is.chars[ic][i][5];
        int e0 = is.chars[ic][i][6];
        int e1 = is.chars[ic][i][7];
        int e2 = is.chars[ic][i][8];
        int e3 = is.chars[ic][i][9];
        int e4 = is.chars[ic][i][10];
        int f = 1;
        int n = 0;
        int upper = 0;
        int number = 1;
        int k1 = 0;
        while (k1 < fs.length()) {
            char c = fs.charAt(k1);
            if (Character.isUpperCase(c)) {
                if (k1 == 0) {
                    upper = 1;
                } else if (upper == 1) {
                    upper = 3;
                } else if (upper == 0) {
                    upper = 2;
                }
            }
            if (Character.isDigit(c) && k1 == 0) {
                number = 2;
            } else if (Character.isDigit(c) && number == 1) {
                number = 3;
            }
            ++k1;
        }
        int form = forms[i];
        int form2 = forms[i] < this.corpusWrds ? forms[i] : -1;
        int len = forms.length;
        this.d1.v0 = f++;
        this.d1.v2 = form2;
        long l = this.mf.calc3(this.d1);
        vs[n++] = this.mf.calc3(this.d1);
        this.d1.v0 = f++;
        this.d1.v2 = is.formlc[ic][i];
        vs[n++] = this.mf.calc3(this.d1);
        this.d3.v2 = c0;
        this.d3.v3 = c1;
        this.d3.v4 = c2;
        this.d3.v5 = c3;
        this.d3.v6 = c4;
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc3(this.d3);
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc4(this.d3);
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc5(this.d3);
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc6(this.d3);
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc7(this.d3);
        if (form != -1) {
            this.d3.v2 = c2;
            this.d3.v3 = c3;
            this.d3.v4 = c4;
            this.d3.v5 = c5;
            this.d3.v6 = this.cl.getLP(form);
            this.d3.v0 = f;
            vs[n++] = this.mf.calc6(this.d3);
            this.d3.v0 = f + 1;
            vs[n++] = this.mf.calc7(this.d3);
        }
        f += 2;
        if (form > 0) {
            this.d3.v0 = f;
            this.d3.v5 = this.cl.getLP(form);
            vs[n++] = this.mf.calc6(this.d3);
            this.d3.v0 = f + 1;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.mf.calc5(this.d3);
            this.d3.v0 = f + 2;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.mf.calc4(this.d3);
        }
        f += 5;
        this.d3.v2 = e0;
        this.d3.v3 = e1;
        this.d3.v4 = e2;
        this.d3.v5 = e3;
        this.d3.v6 = e4;
        this.d3.v0 = f++;
        vs[n++] = this.mf.calc3(this.d3);
        this.d3.v0 = f++;
        vs[n++] = l = this.mf.calc4(this.d3);
        vs[n++] = this.d3.calcs(3, upper, l);
        this.d3.v0 = f++;
        vs[n++] = l = this.mf.calc5(this.d3);
        vs[n++] = this.d3.calcs(3, upper, l);
        this.d3.v0 = f++;
        vs[n++] = l = this.mf.calc6(this.d3);
        vs[n++] = this.d3.calcs(3, upper, l);
        this.d3.v0 = f++;
        vs[n++] = l = this.mf.calc7(this.d3);
        vs[n++] = this.d3.calcs(3, upper, l);
        if (form > 0) {
            this.d3.v0 = f;
            this.d3.v5 = this.cl.getLP(form);
            vs[n++] = this.mf.calc6(this.d3);
            this.d3.v0 = f + 1;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.mf.calc5(this.d3);
            this.d3.v0 = f + 2;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.mf.calc4(this.d3);
            this.d3.v2 = e0;
            this.d3.v3 = e1;
            this.d3.v4 = e2;
            this.d3.v0 = f + 3;
            this.d3.v2 = this.lx.getTag(form);
            vs[n++] = this.mf.calc3(this.d3);
            this.d3.v0 = f + 4;
            this.d3.v4 = this.cl.getLP(form);
            vs[n++] = this.mf.calc5(this.d3);
            this.d3.v0 = f + 5;
            this.d3.v3 = this.cl.getLP(form);
            vs[n++] = this.mf.calc4(this.d3);
        }
        f += 6;
        this.d3.v0 = f++;
        this.d3.v2 = c1;
        this.d3.v3 = c2;
        this.d3.v4 = c3;
        vs[n++] = this.mf.calc5(this.d3);
        this.d3.v0 = f++;
        this.d3.v2 = c2;
        this.d3.v3 = c3;
        this.d3.v4 = c4;
        vs[n++] = this.mf.calc5(this.d3);
        this.d3.v0 = f++;
        this.d3.v2 = c3;
        this.d3.v3 = c4;
        this.d3.v4 = c5;
        vs[n++] = this.mf.calc5(this.d3);
        this.d3.v0 = f++;
        this.d3.v2 = c1;
        this.d3.v3 = c2;
        this.d3.v4 = c3;
        this.d3.v5 = c4;
        vs[n++] = this.mf.calc6(this.d3);
        this.d3.v0 = f++;
        this.d3.v2 = c2;
        this.d3.v3 = c3;
        this.d3.v4 = c4;
        this.d3.v5 = c5;
        vs[n++] = this.mf.calc6(this.d3);
        if (i + 1 < len && forms[i + 1] < this.corpusWrds) {
            this.dw.v0 = f;
            this.dw.v2 = forms[i + 1];
            this.dw.v3 = form2;
            vs[n++] = this.mf.calc4(this.dw);
        }
        ++f;
        if (len > i + 1) {
            if (forms[i + 1] < this.corpusWrds) {
                this.dw.v0 = f;
                this.dw.v2 = forms[i + 1];
                vs[n++] = this.mf.calc3(this.dw);
            }
            this.d3.v0 = f + 1;
            this.d3.v2 = is.chars[ic][i + 1][0];
            vs[n++] = this.mf.calc3(this.d3);
            this.d3.v0 = f + 2;
            this.d3.v2 = is.chars[ic][i + 1][6];
            vs[n++] = this.mf.calc3(this.d3);
            this.d3.v2 = e0;
            this.d3.v3 = e1;
            this.d3.v0 = f + 3;
            this.d3.v4 = is.chars[ic][i + 1][0];
            vs[n++] = this.mf.calc5(this.d3);
            this.d3.v0 = f + 4;
            this.d3.v4 = is.chars[ic][i + 1][6];
            vs[n++] = this.mf.calc5(this.d3);
            if (is.chars[ic][i + 1][11] > 1) {
                this.d3.v0 = f + 5;
                this.d3.v2 = is.chars[ic][i + 1][0];
                this.d3.v3 = is.chars[ic][i + 1][1];
                vs[n++] = this.mf.calc4(this.d3);
                this.d3.v0 = f + 6;
                this.d3.v2 = is.chars[ic][i + 1][6];
                this.d3.v3 = is.chars[ic][i + 1][7];
                vs[n++] = this.mf.calc4(this.d3);
                this.d3.v2 = e0;
                this.d3.v3 = e1;
                this.d3.v0 = f + 7;
                this.d3.v4 = is.chars[ic][i + 1][0];
                this.d3.v5 = is.chars[ic][i + 1][1];
                vs[n++] = this.mf.calc6(this.d3);
                this.d3.v0 = f + 8;
                this.d3.v4 = is.chars[ic][i + 1][6];
                this.d3.v5 = is.chars[ic][i + 1][7];
                vs[n++] = this.mf.calc6(this.d3);
                if (forms[i + 1] > 0) {
                    this.d3.v0 = f + 9;
                    this.d3.v2 = is.chars[ic][i + 1][0];
                    this.d3.v3 = is.chars[ic][i + 1][1];
                    this.d3.v4 = this.cl.getLP(forms[i + 1]);
                    vs[n++] = this.mf.calc5(this.d3);
                    this.d3.v0 = f + 10;
                    this.d3.v2 = is.chars[ic][i + 1][6];
                    this.d3.v3 = is.chars[ic][i + 1][7];
                    this.d3.v4 = this.cl.getLP(forms[i + 1]);
                    vs[n++] = this.mf.calc5(this.d3);
                }
            }
            if (forms[i + 1] > 0) {
                this.dw.v0 = f + 11;
                this.dw.v2 = this.cl.getLP(forms[i + 1]);
                this.dw.v3 = form2;
                vs[n++] = this.mf.calc4(this.dw);
            }
            if (len > i + 2) {
                if (forms[i + 2] < this.corpusWrds && forms[i + 1] < this.corpusWrds) {
                    this.dw.v0 = f + 12;
                    this.dw.v2 = forms[i + 2];
                    this.dw.v3 = forms[i + 1];
                    vs[n++] = this.mf.calc4(this.dw);
                    vs[n++] = this.mf.calc3(this.dw);
                }
                this.d2.v0 = f + 13;
                this.d2.v2 = pposs[i + 1];
                this.d2.v3 = pposs[i + 2];
                vs[n++] = this.mf.calc4(this.d2);
            }
            if (len > i + 3 && forms[i + 3] < this.corpusWrds && forms[i + 2] < this.corpusWrds) {
                this.dw.v0 = f + 14;
                this.dw.v2 = forms[i + 3];
                this.dw.v3 = forms[i + 2];
                vs[n++] = this.mf.calc4(this.dw);
                vs[n++] = this.mf.calc3(this.dw);
            }
        }
        f += 15;
        this.d2.v0 = f++;
        this.d2.v2 = is.chars[ic][i][11];
        vs[n++] = this.mf.calc3(this.d2);
        this.d2.v0 = f++;
        this.d2.v2 = number;
        vs[n++] = this.mf.calc3(this.d2);
        if (lemmas[i] < this.corpusWrds) {
            this.d1.v0 = f;
            this.d1.v2 = lemmas[i];
            vs[n++] = this.mf.calc3(this.d1);
        }
        ++f;
        if (i != 0 && len > i + 1) {
            if (lemmas[i - 1] < this.corpusWrds && lemmas[i + 1] < this.corpusWrds) {
                this.dw.v0 = f;
                this.dw.v2 = lemmas[i - 1];
                this.dw.v3 = lemmas[i + 1];
                vs[n++] = this.mf.calc4(this.dw);
            }
            this.d2.v0 = f + 1;
            this.d2.v2 = pposs[i - 1];
            this.d2.v3 = pposs[i + 1];
            vs[n++] = this.mf.calc4(this.d2);
        }
        f += 2;
        this.d2.v0 = f++;
        this.d2.v2 = i >= 1 ? pposs[i - 1] : _strp;
        vs[n++] = this.mf.calc3(this.d2);
        if (i > 0) {
            this.dw.v0 = f;
            this.dw.v2 = i >= 1 ? (forms[i - 1] < this.corpusWrds ? forms[i - 1] : -1) : _strp;
            vs[n++] = this.mf.calc3(this.dw);
            ++f;
            if (lemmas[i - 1] < this.corpusWrds) {
                this.dw.v0 = f;
                this.dw.v2 = i >= 1 ? lemmas[i - 1] : _strp;
                vs[n++] = this.mf.calc3(this.dw);
            }
            ++f;
            if (i > 1) {
                this.d2.v0 = f++;
                this.d2.v2 = i < 2 ? _strp : pposs[i - 2];
                vs[n++] = this.mf.calc3(this.d2);
                this.d2.v0 = f++;
                this.d2.v2 = pposs[i - 1];
                this.d2.v3 = pposs[i - 2];
                vs[n++] = this.mf.calc4(this.d2);
                if (forms[i - 2] < this.corpusWrds) {
                    this.dw.v0 = f;
                    this.dw.v2 = forms[i - 2];
                    vs[n++] = this.mf.calc3(this.dw);
                }
                ++f;
                if (forms[i - 1] < this.corpusWrds) {
                    this.dwp.v0 = f;
                    this.dwp.v2 = forms[i - 1];
                    this.dwp.v3 = pposs[i - 2];
                    vs[n++] = this.mf.calc4(this.dwp);
                }
                ++f;
                if (forms[i - 2] < this.corpusWrds) {
                    this.dwp.v0 = f;
                    this.dwp.v2 = forms[i - 2];
                    this.dwp.v3 = pposs[i - 1];
                    vs[n++] = this.mf.calc4(this.dwp);
                }
                ++f;
                if (i > 2) {
                    this.d2.v0 = f++;
                    this.d2.v2 = pposs[i - 3];
                    vs[n++] = this.mf.calc3(this.d2);
                    this.d2.v0 = f++;
                    this.d2.v2 = pposs[i - 2];
                    this.d2.v3 = pposs[i - 3];
                    vs[n++] = this.mf.calc4(this.d2);
                    if (forms[i - 3] < this.corpusWrds && forms[i - 2] < this.corpusWrds) {
                        this.dw.v0 = f;
                        this.dw.v2 = forms[i - 3];
                        this.dw.v3 = forms[i - 2];
                        vs[n++] = this.mf.calc4(this.dw);
                    }
                    ++f;
                }
            }
        }
        vs[n] = Integer.MIN_VALUE;
    }

    public int fillFeatureVectorsOne(String fs, ParametersFloat params, int w1, InstancesTagger is, int n, short[] pos, Long2IntInterface li, float[] score) {
        float best = -1000.0f;
        int bestType = -1;
        F2SF f = new F2SF(params.parameters);
        long[] vs = new long[71];
        int[] lemmas = this.options.noLemmas ? new int[is.length(n)] : is.plemmas[n];
        this.addFeatures(is, n, fs, w1, pos, is.forms[n], lemmas, vs);
        int t = 0;
        while (t < this.types.length) {
            int p = t << s_type;
            f.clear();
            int k = 0;
            while (vs[k] != Integer.MIN_VALUE) {
                if (vs[k] > 0L) {
                    f.add(li.l2i(vs[k] + (long)p));
                }
                ++k;
            }
            if (f.score > best) {
                bestType = t;
                score[w1] = best = f.score;
            }
            ++t;
        }
        return bestType;
    }

    public ArrayList<POS> classify(String fs, ParametersFloat params, int w1, InstancesTagger is, int n, short[] pos, Long2IntInterface li) {
        F2SF f = new F2SF(params.parameters);
        long[] vs = new long[71];
        int[] lemmas = this.options.noLemmas ? new int[is.length(n)] : is.plemmas[n];
        this.addFeatures(is, n, fs, w1, pos, is.forms[n], lemmas, vs);
        ArrayList<POS> best = new ArrayList<POS>(this.types.length);
        int t = 0;
        while (t < this.types.length) {
            int p = t << s_type;
            f.clear();
            f.add(vs, li, p);
            POS px = new POS(t, f.score);
            best.add(px);
            ++t;
        }
        Collections.sort(best);
        return best;
    }

    @Override
    public void write(DataOutputStream dos) {
        try {
            this.cl.write(dos);
            this.lx.write(dos);
            dos.writeInt(this.corpusWrds);
            dos.writeInt(this._pps.size());
            for (Map.Entry<Integer, int[]> e : this._pps.entrySet()) {
                dos.writeInt(e.getValue().length);
                int[] nArray = e.getValue();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int k = nArray[n2];
                    dos.writeInt(k);
                    ++n2;
                }
                dos.writeInt(e.getKey());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(DataInputStream dis) {
        try {
            this.cl = new Cluster(dis);
            this.lx = new Lexicon(dis);
            this.corpusWrds = dis.readInt();
            int pc = dis.readInt();
            int j = 0;
            while (j < pc) {
                int[] ps = new int[dis.readInt()];
                int k = 0;
                while (k < ps.length) {
                    ps[k] = dis.readInt();
                    ++k;
                }
                this._pps.put(dis.readInt(), ps);
                ++j;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

