/*
 * Decompiled with CFR 0.152.
 */
package is2.parserR2;

import extractors.Extractor;
import extractors.ExtractorClusterStacked;
import extractors.ExtractorReranker;
import is2.data.Cluster;
import is2.data.DataF;
import is2.data.Edges;
import is2.data.F2SF;
import is2.data.FVR;
import is2.data.Instances;
import is2.data.Long2Int;
import is2.data.Long2IntInterface;
import is2.data.MFB;
import is2.data.Parse;
import is2.data.ParseNBest;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.io.CONLLWriter09;
import is2.parserR2.Decoder;
import is2.parserR2.Options;
import is2.parserR2.Parameters;
import is2.parserR2.ParametersFloat;
import is2.parserR2.Pipe;
import is2.parserR2.PipeReranker;
import is2.tools.Tool;
import is2.util.DB;
import is2.util.OptionsSuper;
import is2.util.ParserEvaluator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Reranker
implements Tool {
    public static int THREADS = 4;
    Long2IntInterface l2i;
    ParametersFloat[] paramsParsers;
    ParametersFloat parametersReranker;
    PipeReranker pipeReranker;
    Pipe pipe;
    Options options;
    HashMap<Integer, Integer> rank = new HashMap();
    int amongxbest = 0;
    int amongxbest_ula = 0;
    int nbest = 0;
    int bestProj = 0;
    int smallestErrorSum = 0;
    int countAllNodes = 0;
    static int NBest = 1000;

    public Reranker(Options options) {
        this.options = options;
    }

    public Reranker(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    public Reranker() {
    }

    public static void main(String[] args) throws Exception {
        Reranker p;
        long start = System.currentTimeMillis();
        Options options = new Options(args);
        NBest = options.best;
        DB.println("n-best " + NBest);
        Runtime runtime = Runtime.getRuntime();
        THREADS = runtime.availableProcessors();
        if (options.cores < THREADS && options.cores > 0) {
            THREADS = options.cores;
        }
        DB.println("Found " + runtime.availableProcessors() + " cores use " + THREADS);
        if (options.train) {
            p = new Reranker();
            p.options = options;
            p.l2i = new Long2Int(options.hsize);
            p.pipeReranker = new PipeReranker(options);
            p.pipeReranker.extractor = new ExtractorReranker(p.l2i);
            p.pipe = new Pipe(options);
            p.paramsParsers = new ParametersFloat[options.end + 1];
            int m = 0;
            while (m <= options.end) {
                String name = String.valueOf(options.prefix_model) + m;
                p.paramsParsers[m] = new ParametersFloat(0);
                p.readModel(name, p.pipe, (Parameters)p.paramsParsers[m]);
                ++m;
            }
            p.parametersReranker = new ParametersFloat(p.l2i.size());
            Instances[] iss = new Instances[options.end + 1];
            int m2 = 0;
            while (m2 <= options.end) {
                String name = String.valueOf(options.prefix_test) + m2;
                iss[m2] = new Instances();
                DB.println("create instances of part " + name);
                p.pipe.getInstances(name, iss[m2]);
                ++m2;
            }
            ExtractorReranker.initFeatures();
            p.pipeReranker.extractor.init();
            PipeReranker pipeReranker = p.pipeReranker;
            pipeReranker.extractor.initStat();
            p.train(options, iss);
            p.writeModell(options, p.parametersReranker, null, p.pipe.cl);
        }
        if (options.test) {
            int read;
            p = new Reranker();
            p.options = options;
            p.l2i = new Long2Int(options.hsize);
            p.pipeReranker = new PipeReranker(options);
            p.pipeReranker.extractor = new ExtractorReranker(p.l2i);
            p.parametersReranker = new ParametersFloat(p.l2i.size());
            p.pipe = new Pipe(options);
            p.paramsParsers = new ParametersFloat[options.end + 1];
            String nbestName = "n-best+" + options.testfile.substring(options.testfile.length() - 12, options.testfile.length() - 1);
            File fnbest = new File(nbestName);
            int n = read = fnbest.exists() ? 2 : 1;
            if (read != 2) {
                int m = 0;
                while (m <= options.end) {
                    String name = String.valueOf(options.prefix_model) + m;
                    p.paramsParsers[m] = new ParametersFloat(0);
                    p.readModel(name, p.pipe, (Parameters)p.paramsParsers[m]);
                    ++m;
                }
            }
            p.readModel(options.modelName, p.pipeReranker, (Parameters)p.parametersReranker);
            ExtractorReranker.initFeatures();
            PipeReranker pipeReranker = p.pipeReranker;
            pipeReranker.extractor.initStat();
            p.pipeReranker.extractor.init();
            p.rerankedParses(options, p.pipe, p.parametersReranker, false, nbestName);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            ParserEvaluator.evaluate(options.goldfile, options.outfile);
        }
        long end = System.currentTimeMillis();
        System.out.println("used time " + (float)((end - start) / 100L) / 10.0f);
        Decoder.executerService.shutdown();
        Pipe.executerService.shutdown();
        System.out.println("end.");
    }

    public void readModel(String modelName, Pipe pipe, Parameters prm) throws IOException {
        DataInputStream dis;
        block5: {
            DB.println("Reading data started: " + modelName);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(modelName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
            pipe.mf.read(dis);
            pipe.cl = new Cluster(dis);
            prm.read(dis);
            Long2Int l2i = new Long2Int(prm.size());
            DB.println("li size " + l2i.size());
            pipe.extractor = new ExtractorClusterStacked[THREADS];
            int t = 0;
            while (t < THREADS) {
                pipe.extractor[t] = new ExtractorClusterStacked(l2i);
                ++t;
            }
            ExtractorClusterStacked.initFeatures();
            t = 0;
            while (t < THREADS) {
                pipe.extractor[t].initStat();
                pipe.extractor[t].init();
                ++t;
            }
            Edges.read(dis);
            this.options.decodeProjective = dis.readBoolean();
            ExtractorClusterStacked.maxForm = dis.readInt();
            boolean foundInfo = false;
            try {
                String info = null;
                int icnt = dis.readInt();
                int i = 0;
                while (i < icnt) {
                    info = dis.readUTF();
                    System.out.println(info);
                    ++i;
                }
            }
            catch (Exception e) {
                if (foundInfo) break block5;
                System.out.println("no info about training");
            }
        }
        dis.close();
        DB.println("Reading data finnished");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)this.options.decodeTH;
    }

    public void readModel(String modelName, PipeReranker pipe, Parameters params) throws IOException {
        DataInputStream dis;
        block3: {
            DB.println("Reading data started: " + modelName);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(modelName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
            pipe.mf.read(dis);
            pipe.cl = new Cluster(dis);
            params.read(dis);
            this.l2i = new Long2Int(params.size());
            DB.println("li size " + this.l2i.size());
            pipe.extractor = new ExtractorReranker(this.l2i);
            ExtractorReranker.initFeatures();
            ExtractorReranker.initStat();
            pipe.extractor.init();
            Edges.read(dis);
            this.options.decodeProjective = dis.readBoolean();
            ExtractorClusterStacked.maxForm = dis.readInt();
            boolean foundInfo = false;
            try {
                String info = null;
                int icnt = dis.readInt();
                int i = 0;
                while (i < icnt) {
                    info = dis.readUTF();
                    System.out.println(info);
                    ++i;
                }
            }
            catch (Exception e) {
                if (foundInfo) break block3;
                System.out.println("no info about training");
            }
        }
        dis.close();
        DB.println("Reading data finnished");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)this.options.decodeTH;
    }

    public void train(OptionsSuper options, Instances[] iss) throws IOException, InterruptedException, ClassNotFoundException {
        int read = 0;
        DB.println("Training Information ");
        DB.println("-------------------- ");
        ExtractorReranker.initStat();
        this.pipeReranker.extractor.init();
        Extractor[] extractorArray = this.pipe.extractor;
        int n = this.pipe.extractor.length;
        int n2 = 0;
        while (n2 < n) {
            Extractor e = extractorArray[n2];
            e.init();
            ++n2;
        }
        int numInstances = 0;
        int maxLenInstances = 0;
        Instances[] instancesArray = iss;
        int n3 = iss.length;
        int n4 = 0;
        while (n4 < n3) {
            Instances is = instancesArray[n4];
            numInstances += is.size();
            int i = 0;
            while (i < is.size()) {
                if (maxLenInstances < is.length(i)) {
                    maxLenInstances = is.length(i);
                }
                ++i;
            }
            ++n4;
        }
        DataF data = new DataF(maxLenInstances, this.pipe.mf.getFeatureCounter().get("REL").shortValue());
        int iter = 0;
        int del = 0;
        float error = 0.0f;
        float f1 = 0.0f;
        double upd = (double)(options.count * options.numIters) + (double)(options.numIters * 10);
        FVR act = new FVR();
        FVR pred = new FVR();
        FVR f = new FVR();
        long[] vs = new long[60 * maxLenInstances];
        while (iter < options.numIters) {
            System.out.print("Iteration " + iter + ": ");
            error = 0.0f;
            f1 = 0.0f;
            float las = 0.0f;
            float cnt = 0.0f;
            float averageScore = 0.0f;
            float firstBestTotalError = 0.0f;
            float totalError = 0.0f;
            long start = System.currentTimeMillis();
            long last = System.currentTimeMillis();
            long rerankTime = 0L;
            String nbest = "n-best";
            File fnbest = new File(nbest);
            read = fnbest.exists() ? 2 : 1;
            DataInputStream dis = null;
            DataOutputStream dos = null;
            if (read == 1) {
                DB.println("computing and writting nbest list to file: " + nbest);
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(nbest)));
                zos.putNextEntry(new ZipEntry("data"));
                dos = new DataOutputStream(new BufferedOutputStream(zos));
            }
            if (read == 2) {
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(nbest)));
                zis.getNextEntry();
                dis = new DataInputStream(new BufferedInputStream(zis));
            }
            HashMap<Integer, Integer> remapped = new HashMap<Integer, Integer>();
            int i = 0;
            int round = 0;
            int instance = 0;
            int length = 0;
            int count = 0;
            int changes = 0;
            Instances[] instancesArray2 = iss;
            int n5 = iss.length;
            int n6 = 0;
            while (n6 < n5) {
                Instances is = instancesArray2[n6];
                F2SF fparser = this.paramsParsers[instance].getFV();
                ++round;
                int n7 = 0;
                while (n7 < is.size()) {
                    ++count;
                    length += is.length(n7);
                    upd -= 1.0;
                    if (is.labels[n7].length <= options.maxLen) {
                        List<Object> parses = null;
                        short[] pos = is.pposs[n7];
                        if (read == 0 || read == 1 && iter == 0) {
                            parses = Decoder.decode(pos, data = this.pipe.fillVector(fparser, is, n7, data, this.pipe.cl, THREADS, this.l2i), options.decodeProjective, this.pipe.extractor[0]);
                            if (parses.size() > NBest) {
                                parses = parses.subList(0, NBest);
                            }
                            if (read == 1) {
                                dos.writeInt(parses.size());
                                int k = 0;
                                while (k < parses.size()) {
                                    dos.writeUTF(((ParseNBest)parses.get(k)).signature());
                                    dos.writeFloat((float)((ParseNBest)parses.get((int)k)).f1);
                                    ++k;
                                }
                            }
                        } else if (read == 2) {
                            parses = new ArrayList();
                            int parseCount = dis.readInt();
                            int k = 0;
                            while (k < parseCount) {
                                ParseNBest p = new ParseNBest(dis.readUTF(), dis.readFloat());
                                if (parses.size() < NBest) {
                                    parses.add(p);
                                }
                                ++k;
                            }
                        }
                        int best = 0;
                        float bestScore = -100.0f;
                        int goldBest = 0;
                        double goldError = 3.4028234663852886E38;
                        long startReranking = System.currentTimeMillis();
                        int k = 0;
                        while (k < parses.size()) {
                            ParseNBest p = (ParseNBest)parses.get(k);
                            this.pipeReranker.extractor.extractFeatures(is, n7, p, parses.indexOf(p), vs, this.pipe.cl);
                            int rank = 1 * ExtractorReranker.s_type;
                            f.clear();
                            int j = 0;
                            while (j < vs.length) {
                                if (vs[j] == Integer.MIN_VALUE) break;
                                if (vs[j] > 0L) {
                                    f.add(this.pipeReranker.extractor.li.l2i(vs[j] + (long)rank));
                                }
                                ++j;
                            }
                            f.add(this.pipeReranker.extractor.li.l2i(1 + rank), (float)p.f1);
                            float score = this.parametersReranker.getScore(f);
                            if (score > bestScore) {
                                bestScore = score;
                                best = k;
                            }
                            ++k;
                        }
                        k = 0;
                        while (k < parses.size()) {
                            if (((ParseNBest)parses.get((int)k)).heads.length != is.length(n7)) {
                                DB.println("error " + n7 + " " + ((ParseNBest)parses.get((int)k)).heads.length + " " + is.length(n7));
                            } else {
                                double errg = this.pipe.errors(is, n7, (Parse)parses.get(k));
                                if (goldError > errg) {
                                    goldError = errg;
                                    goldBest = k;
                                }
                            }
                            ++k;
                        }
                        ParseNBest firstBest = (ParseNBest)parses.get(0);
                        ParseNBest predParse = (ParseNBest)parses.get(best);
                        ParseNBest goldBestParse = (ParseNBest)parses.get(goldBest);
                        double e = this.pipe.errors(is, n7, predParse);
                        Integer ctb = (Integer)remapped.get(best);
                        if (ctb == null) {
                            remapped.put(best, 1);
                        } else {
                            remapped.put(best, ctb + 1);
                        }
                        String info = " 1best-error " + ((float)length - firstBestTotalError) / (float)length + " reranked " + ((float)length - totalError) / (float)length + " chd  " + changes + "  " + " ps las " + las / cnt + " avs " + averageScore / (float)count + "   ";
                        if ((n7 + 1) % 500 == 0) {
                            del = PipeGen.outValueErr(count, Math.round(error * 1000.0f) / 1000, f1 / (float)count, del, last, upd, info);
                        }
                        firstBestTotalError += (float)Decoder.getError(firstBest, is, n7, true);
                        totalError += (float)Decoder.getError(predParse, is, n7, true);
                        rerankTime += System.currentTimeMillis() - startReranking;
                        if (best != 0) {
                            ++changes;
                        }
                        las += (float)(is.length(n7) - Decoder.getError(goldBestParse, is, n7, true));
                        cnt += (float)is.length(n7);
                        averageScore = (float)((double)averageScore + predParse.f1);
                        if (options.count < count) break;
                        if (Decoder.getError(goldBestParse, is, n7, true) < Decoder.getError(predParse, is, n7, true)) {
                            this.pipeReranker.extractor.extractFeatures(is, n7, predParse, parses.indexOf(predParse), vs, this.pipe.cl);
                            pred.clear();
                            int rank = 1 * ExtractorReranker.s_type;
                            int j = 0;
                            while (j < vs.length) {
                                if (vs[j] == Integer.MIN_VALUE) break;
                                if (vs[j] > 0L) {
                                    pred.add(this.pipeReranker.extractor.li.l2i(vs[j] + (long)rank));
                                }
                                ++j;
                            }
                            pred.add(this.pipeReranker.extractor.li.l2i(1 + rank), (float)predParse.f1);
                            error += 1.0f;
                            this.pipeReranker.extractor.extractFeatures(is, n7, goldBestParse, parses.indexOf(goldBestParse), vs, this.pipe.cl);
                            act.clear();
                            rank = 1 * ExtractorReranker.s_type;
                            j = 0;
                            while (j < vs.length) {
                                if (vs[j] == Integer.MIN_VALUE) break;
                                if (vs[j] > 0L) {
                                    act.add(this.pipeReranker.extractor.li.l2i(vs[j] + (long)rank));
                                }
                                ++j;
                            }
                            act.add(this.pipeReranker.extractor.li.l2i(1 + rank), (float)goldBestParse.f1);
                            float lam_dist = this.parametersReranker.getScore(act) - this.parametersReranker.getScore(pred);
                            this.parametersReranker.update(act, pred, is, n7, null, upd, e, lam_dist);
                        }
                    }
                    ++n7;
                }
                ++instance;
                ++n6;
            }
            String info = " td " + (float)Decoder.timeDecotder / 1000000.0f + " tr " + (float)Decoder.timeRearrange / 1000000.0f + " te " + (float)Pipe.timeExtract / 1000000.0f + " nz " + this.parametersReranker.countNZ() + " 1best-error " + ((float)length - firstBestTotalError) / (float)length + " reranked-best " + ((float)length - totalError) / (float)length + " rds " + round + "   " + " rerank-t " + rerankTime / (long)count + " chd " + changes + "   " + " ps las " + las / cnt + " avs " + averageScore / (float)count + "   ";
            PipeGen.outValueErr(count, Math.round(error * 1000.0f) / 1000, f1 / (float)count, del, last, upd, info);
            del = 0;
            long end = System.currentTimeMillis();
            System.out.println(" time:" + (end - start));
            ++i;
            Decoder.timeDecotder = 0L;
            Decoder.timeRearrange = 0L;
            Pipe.timeExtract = 0L;
            if (dos != null) {
                dos.close();
            }
            if (dis != null) {
                dis.close();
            }
            ++iter;
        }
        DB.println("sb " + this.parametersReranker.parameters[this.pipeReranker.extractor.li.l2i(4090378920L + (long)(1 * ExtractorReranker.s_type))]);
        this.parametersReranker.average(iter * numInstances);
    }

    private void rerankedParses(OptionsSuper options, Pipe pipe, ParametersFloat params, boolean maxInfo, String nbestName) throws Exception {
        int read;
        long start = System.currentTimeMillis();
        ExtractorClusterStacked.initFeatures();
        FilterInputStream dis = null;
        DataOutputStream dos = null;
        float olas = 0.0f;
        float olcnt = 0.0f;
        File fnbest = new File(nbestName);
        int n = read = fnbest.exists() ? 2 : 1;
        if (read == 1) {
            DB.println("computing and writting nbest list to file: " + nbestName);
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(nbestName)));
            zos.putNextEntry(new ZipEntry("data"));
            dos = new DataOutputStream(new BufferedOutputStream(zos));
        }
        if (read == 2) {
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(nbestName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
        }
        int m = 0;
        while (m < this.paramsParsers.length) {
            CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
            CONLLWriter09 depWriter = new CONLLWriter09(options.outfile, options.formatTask);
            float las = 0.0f;
            float lcnt = 0.0f;
            float averageScore = 0.0f;
            int cnt = 0;
            int del = 0;
            long last = System.currentTimeMillis();
            String[] types = new String[pipe.mf.getFeatureCounter().get("REL").intValue()];
            Pipe pipe2 = pipe;
            for (Map.Entry<String, Integer> e : pipe2.mf.getFeatureSet().get("REL").entrySet()) {
                types[e.getValue().intValue()] = e.getKey();
            }
            System.out.print("Processing Sentence: ");
            FVR f = new FVR();
            while (true) {
                Instances is = new Instances();
                is.init(1, new MFB(), options.formatTask);
                SentenceData09 instance = pipe.nextInstance(is, depReader);
                if (instance == null) break;
                ++cnt;
                String[] forms = instance.forms;
                List<ParseNBest> parses = null;
                if (read == 0 || read == 1) {
                    parses = this.parseNBest(instance, this.paramsParsers[m]);
                    if (parses.size() > NBest) {
                        parses = parses.subList(0, NBest);
                    }
                    if (read == 1) {
                        dos.writeInt(parses.size());
                        int k = 0;
                        while (k < parses.size()) {
                            dos.writeUTF(parses.get(k).signature());
                            dos.writeFloat((float)parses.get((int)k).f1);
                            ++k;
                        }
                    }
                } else if (read == 2) {
                    parses = new ArrayList<ParseNBest>();
                    int parseCount = ((DataInputStream)dis).readInt();
                    int k = 0;
                    while (k < parseCount) {
                        ParseNBest p = new ParseNBest(((DataInputStream)dis).readUTF(), ((DataInputStream)dis).readFloat());
                        if (parses.size() < NBest) {
                            parses.add(p);
                        }
                        ++k;
                    }
                }
                this.nbest += parses.size();
                long[] vs = new long[60 * is.length(0)];
                float bestScore = 0.0f;
                int best = 0;
                int k = 0;
                while (k < parses.size()) {
                    ParseNBest p = parses.get(k);
                    this.pipeReranker.extractor.extractFeatures(is, 0, p, k, vs, this.pipeReranker.cl);
                    int rank = 1 * ExtractorReranker.s_type;
                    f.clear();
                    int j = 0;
                    while (j < vs.length) {
                        if (vs[j] == Integer.MIN_VALUE) break;
                        if (vs[j] > 0L) {
                            f.add(this.pipeReranker.extractor.li.l2i(vs[j] + (long)rank));
                        }
                        ++j;
                    }
                    f.add(this.pipeReranker.extractor.li.l2i(1 + rank), (float)p.f1);
                    float score = this.parametersReranker.getScore(f);
                    if (score > bestScore) {
                        bestScore = score;
                        best = k;
                    }
                    ++k;
                }
                ParseNBest d = parses.get(best);
                las += (float)(is.length(0) - 1 - Decoder.getError(d, is, 0, true));
                lcnt += (float)(is.length(0) - 1);
                averageScore = (float)((double)averageScore + d.f1);
                SentenceData09 i09 = new SentenceData09(instance);
                i09.createSemantic(instance);
                int j = 0;
                while (j < forms.length - 1) {
                    i09.plabels[j] = types[d.labels[j + 1]];
                    i09.pheads[j] = d.heads[j + 1];
                    ++j;
                }
                depWriter.write(i09);
                String info = averageScore / (float)cnt + "   ";
                if (cnt % 10 != 0) continue;
                del = PipeGen.outValueErr(cnt, lcnt - las, las / lcnt, del, last, 0.0, info);
            }
            depWriter.finishWriting();
            long end = System.currentTimeMillis();
            DB.println("rank\n" + this.rank + "\n");
            DB.println("x-best-las " + this.amongxbest + " x-best-ula " + this.amongxbest_ula + " cnt " + cnt + " x-best-las " + (float)this.amongxbest / (float)cnt + " x-best-ula " + (float)this.amongxbest_ula / (float)cnt + " nbest " + (float)this.nbest / (float)cnt + " 1best " + (float)(this.rank.get(0) == null ? 0 : this.rank.get(0)) / (float)cnt + " best-proj " + (float)this.bestProj / (float)cnt + " Sum LAS " + (float)this.smallestErrorSum / (float)this.countAllNodes + " " + las / lcnt);
            olas += las;
            olcnt += lcnt;
            this.rank.clear();
            this.amongxbest = 0;
            this.amongxbest_ula = 0;
            cnt = 0;
            this.nbest = 0;
            this.bestProj = 0;
            if (maxInfo) {
                System.out.println("Used time " + (end - start));
            }
            if (maxInfo) {
                System.out.println("forms count " + Instances.m_count + " unkown " + Instances.m_unkown);
            }
            ++m;
        }
        if (dos != null) {
            dos.flush();
            dos.close();
        }
        if (dis != null) {
            dis.close();
        }
        DB.println("\n overall las " + olas / olcnt);
    }

    private void getNBest(OptionsSuper options, Pipe pipe, ParametersFloat params, boolean maxInfo) throws Exception {
        CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
        ExtractorClusterStacked.initFeatures();
        int cnt = 0;
        String[] types = new String[pipe.mf.getFeatureCounter().get("REL").intValue()];
        Pipe pipe2 = pipe;
        for (Map.Entry<String, Integer> e : pipe2.mf.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        while (true) {
            Instances is = new Instances();
            is.init(1, new MFB(), options.formatTask);
            SentenceData09 instance = pipe.nextInstance(is, depReader);
            if (instance == null) break;
            ++cnt;
            this.parseNBest(instance, this.paramsParsers[0]);
        }
    }

    public SentenceData09 parse(SentenceData09 instance, ParametersFloat params) {
        DataF d2;
        String[] types = new String[this.pipe.mf.getFeatureCounter().get("REL").intValue()];
        for (Map.Entry<String, Integer> e : MFB.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        Instances is = new Instances();
        is.init(1, new MFB(), this.options.formatTask);
        new CONLLReader09().insert(is, instance);
        String[] forms = instance.forms;
        try {
            d2 = this.pipe.fillVector(params.getFV(), is, 0, null, this.pipe.cl, THREADS, this.l2i);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        short[] pos = is.pposs[0];
        List<ParseNBest> parses = null;
        Parse d = null;
        try {
            parses = Decoder.decode(pos, d2, this.options.decodeProjective, this.pipe.extractor[0]);
            d = parses.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (parses.size() > NBest) {
            parses = parses.subList(0, NBest);
        }
        int g_las = Decoder.getGoldRank(parses, is, 0, true);
        int g_ula = Decoder.getGoldRank(parses, is, 0, false);
        int smallest = Decoder.getSmallestError(parses, is, 0, false);
        this.smallestErrorSum += is.length(0) - smallest;
        this.countAllNodes += is.length(0);
        if (g_las >= 0) {
            ++this.amongxbest;
        }
        if (g_ula >= 0) {
            ++this.amongxbest_ula;
        }
        this.nbest += parses.size();
        Integer r = this.rank.get(g_las);
        if (r == null) {
            this.rank.put(g_las, 1);
        } else {
            this.rank.put(g_las, r + 1);
        }
        float err = (float)this.pipe.errors(is, 0, d);
        float errBestProj = (float)this.pipe.errors(is, 0, Decoder.bestProj);
        if (errBestProj == 0.0f) {
            ++this.bestProj;
        }
        SentenceData09 i09 = new SentenceData09(instance);
        i09.createSemantic(instance);
        int j = 0;
        while (j < forms.length - 1) {
            i09.plabels[j] = types[d.labels[j + 1]];
            i09.pheads[j] = d.heads[j + 1];
            ++j;
        }
        return i09;
    }

    public List<ParseNBest> parseNBest(SentenceData09 instance, ParametersFloat params) {
        DataF d2;
        Instances is = new Instances();
        is.init(1, new MFB(), this.options.formatTask);
        new CONLLReader09().insert(is, instance);
        try {
            d2 = this.pipe.fillVector(params.getFV(), is, 0, null, this.pipe.cl, THREADS, this.l2i);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        short[] pos = is.pposs[0];
        List<ParseNBest> parses = null;
        try {
            parses = Decoder.decode(pos, d2, this.options.decodeProjective, this.pipe.extractor[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (parses.size() > NBest) {
            parses = parses.subList(0, NBest);
        }
        return parses;
    }

    @Override
    public SentenceData09 apply(SentenceData09 snt09) {
        try {
            this.parse(snt09, this.parametersReranker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Decoder.executerService.shutdown();
        Pipe.executerService.shutdown();
        return snt09;
    }

    private void writeModell(OptionsSuper options, ParametersFloat params, String extension, Cluster cs) throws FileNotFoundException, IOException {
        String name = extension == null ? options.modelName : String.valueOf(options.modelName) + extension;
        DB.println("Writting model: " + name);
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
        zos.putNextEntry(new ZipEntry("data"));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
        MFB.writeData(dos);
        cs.write(dos);
        params.write(dos);
        Edges.write(dos);
        dos.writeBoolean(options.decodeProjective);
        dos.writeInt(ExtractorClusterStacked.maxForm);
        dos.writeInt(5);
        dos.writeUTF("Used parser   " + Reranker.class.toString());
        dos.writeUTF("Creation date " + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()));
        dos.writeUTF("Training data " + options.trainfile);
        dos.writeUTF("Iterations    " + options.numIters + " Used sentences " + options.count);
        dos.writeUTF("Cluster       " + options.clusterFile);
        dos.flush();
        dos.close();
    }
}

