/*
 * Decompiled with CFR 0.152.
 */
package is2.parserR2;

import extractors.Extractor;
import extractors.ExtractorFactory;
import is2.data.Cluster;
import is2.data.DataF;
import is2.data.Edges;
import is2.data.FV;
import is2.data.Instances;
import is2.data.Long2Int;
import is2.data.Long2IntInterface;
import is2.data.MFB;
import is2.data.Parse;
import is2.data.ParseNBest;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.io.CONLLWriter09;
import is2.parserR2.Decoder;
import is2.parserR2.Options;
import is2.parserR2.Parameters;
import is2.parserR2.ParametersFloat;
import is2.parserR2.Pipe;
import is2.tools.Tool;
import is2.util.DB;
import is2.util.OptionsSuper;
import is2.util.ParserEvaluator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Parser
implements Tool {
    private static final boolean MAX_INFO = true;
    public static int THREADS = 4;
    Long2IntInterface l2i;
    ParametersFloat params;
    Pipe pipe;
    OptionsSuper options;
    HashMap<Integer, Integer> rank = new HashMap();
    int amongxbest = 0;
    int amongxbest_ula = 0;
    int nbest = 0;
    int bestProj = 0;
    int smallestErrorSum = 0;
    int countAllNodes = 0;
    static int NBest = 1000;
    ExtractorFactory extractorFactory = new ExtractorFactory(5);

    public Parser(OptionsSuper options) {
        this.options = options;
        this.pipe = new Pipe(options);
        this.params = new ParametersFloat(0);
        try {
            this.readModel(options, this.pipe, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Parser(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    public Parser() {
    }

    public static void main(String[] args) throws Exception {
        Parser p;
        long start = System.currentTimeMillis();
        Options options = new Options(args);
        NBest = options.best;
        DB.println("n-best" + NBest);
        Runtime runtime = Runtime.getRuntime();
        THREADS = runtime.availableProcessors();
        if (options.cores < THREADS && options.cores > 0) {
            THREADS = options.cores;
        }
        DB.println("Found " + runtime.availableProcessors() + " cores use " + THREADS);
        if (options.train) {
            p = new Parser();
            p.options = options;
            p.l2i = new Long2Int(options.hsize);
            p.pipe = new Pipe(options);
            Instances is = new Instances();
            p.pipe.extractor = new Extractor[THREADS];
            int t = 0;
            while (t < THREADS) {
                p.pipe.extractor[t] = p.extractorFactory.getExtractor(p.l2i);
                ++t;
            }
            p.params = new ParametersFloat(p.l2i.size());
            if (options.useMapping != null) {
                String model = options.modelName;
                options.modelName = options.useMapping;
                DB.println("Using mapping of model " + options.modelName);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
                zis.getNextEntry();
                DataInputStream dis = new DataInputStream(new BufferedInputStream(zis));
                p.pipe.mf.read(dis);
                DB.println("read\n" + p.pipe.mf.toString());
                ParametersFloat params = new ParametersFloat(0);
                params.read(dis);
                Edges.read(dis);
                dis.close();
                DB.println("end read model");
                options.modelName = model;
            }
            p.pipe.createInstances(options.trainfile, is);
            p.train(options, p.pipe, p.params, is, p.pipe.cl);
            p.writeModell(options, p.params, null, p.pipe.cl);
        }
        if (options.test) {
            p = new Parser();
            p.options = options;
            p.pipe = new Pipe(options);
            p.params = new ParametersFloat(0);
            p.readModel(options, p.pipe, p.params);
            DB.println("test on " + options.testfile);
            System.out.println(p.pipe.mf.toString());
            p.outputParses(options, p.pipe, p.params, false);
        }
        System.out.println();
        if (options.eval) {
            System.out.println("\nEVALUATION PERFORMANCE:");
            ParserEvaluator.evaluate(options.goldfile, options.outfile);
        }
        long end = System.currentTimeMillis();
        System.out.println("used time " + (float)((end - start) / 100L) / 10.0f);
        Decoder.executerService.shutdown();
        Pipe.executerService.shutdown();
        System.out.println("end.");
    }

    public void readModel(OptionsSuper options, Pipe pipe, Parameters params) throws IOException {
        DataInputStream dis;
        block6: {
            DB.println("Reading data started");
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
            zis.getNextEntry();
            dis = new DataInputStream(new BufferedInputStream(zis));
            pipe.mf.read(dis);
            pipe.cl = new Cluster(dis);
            params.read(dis);
            this.l2i = new Long2Int(params.size());
            DB.println("parsing -- li size " + this.l2i.size());
            pipe.extractor = new Extractor[THREADS];
            int t = 0;
            while (t < THREADS) {
                pipe.extractor[t] = this.extractorFactory.getExtractor(this.l2i);
                ++t;
            }
            Edges.read(dis);
            options.decodeProjective = dis.readBoolean();
            int maxForm = dis.readInt();
            int t2 = 0;
            while (t2 < THREADS) {
                pipe.extractor[t2].setMaxForm(maxForm);
                pipe.extractor[t2].initStat();
                pipe.extractor[t2].init();
                ++t2;
            }
            boolean foundInfo = false;
            try {
                String info = null;
                int icnt = dis.readInt();
                int i = 0;
                while (i < icnt) {
                    info = dis.readUTF();
                    System.out.println(info);
                    ++i;
                }
            }
            catch (Exception e) {
                if (foundInfo) break block6;
                System.out.println("no info about training");
            }
        }
        dis.close();
        DB.println("Reading data finnished");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)options.decodeTH;
        int t = 0;
        while (t < THREADS) {
            pipe.extractor[t].initStat();
            pipe.extractor[t].init();
            ++t;
        }
    }

    public void train(OptionsSuper options, Pipe pipe, ParametersFloat params, Instances is, Cluster cluster) throws IOException, InterruptedException, ClassNotFoundException {
        DB.println("\nTraining Information ");
        DB.println("-------------------- ");
        Decoder.NON_PROJECTIVITY_THRESHOLD = (float)options.decodeTH;
        if (options.decodeProjective) {
            System.out.println("Decoding: " + (options.decodeProjective ? "projective" : "non-projective"));
        } else {
            System.out.println(Decoder.getInfo());
        }
        int numInstances = is.size();
        int maxLenInstances = 0;
        int i = 0;
        while (i < numInstances) {
            if (maxLenInstances < is.length(i)) {
                maxLenInstances = is.length(i);
            }
            ++i;
        }
        DataF data = new DataF(maxLenInstances, pipe.mf.getFeatureCounter().get("REL").shortValue());
        int iter = 0;
        int del = 0;
        float error = 0.0f;
        float f1 = 0.0f;
        FV pred = new FV();
        FV act = new FV();
        double upd = (double)(numInstances * options.numIters) + 1.0;
        while (iter < options.numIters) {
            System.out.print("Iteration " + iter + ": ");
            long start = System.currentTimeMillis();
            long last = System.currentTimeMillis();
            error = 0.0f;
            f1 = 0.0f;
            int n = 0;
            while (n < numInstances) {
                upd -= 1.0;
                if (is.labels[n].length <= options.maxLen) {
                    String info = " td " + (float)Decoder.timeDecotder / 1000000.0f + " tr " + (float)Decoder.timeRearrange / 1000000.0f + " te " + (float)Pipe.timeExtract / 1000000.0f;
                    if ((n + 1) % 500 == 0) {
                        del = PipeGen.outValueErr(n + 1, Math.round(error * 1000.0f) / 1000, f1 / (float)n, del, last, upd, info);
                    }
                    short[] pos = is.pposs[n];
                    data = pipe.fillVector(params.getFV(), is, n, data, cluster, THREADS, this.l2i);
                    List<ParseNBest> parses = Decoder.decode(pos, data, options.decodeProjective, pipe.extractor[0]);
                    Parse d = parses.get(0);
                    double e = pipe.errors(is, n, d);
                    if (d.f1 > 0.0) {
                        f1 = (float)((double)f1 + ((double)(d.labels.length - 1) - e) / (double)(d.labels.length - 1));
                    }
                    if (!(e <= 0.0)) {
                        pred.clear();
                        pipe.extractor[0].encodeCat(is, n, pos, is.forms[n], is.plemmas[n], d.heads, d.labels, is.feats[n], pipe.cl, pred);
                        error = (float)((double)error + e);
                        act.clear();
                        pipe.extractor[0].encodeCat(is, n, pos, is.forms[n], is.plemmas[n], is.heads[n], is.labels[n], is.feats[n], pipe.cl, act);
                        params.update(act, pred, is, n, d, upd, e);
                    }
                }
                ++n;
            }
            String info = " td " + (float)Decoder.timeDecotder / 1000000.0f + " tr " + (float)Decoder.timeRearrange / 1000000.0f + " te " + (float)Pipe.timeExtract / 1000000.0f + " nz " + params.countNZ();
            PipeGen.outValueErr(numInstances, Math.round(error * 1000.0f) / 1000, f1 / (float)numInstances, del, last, upd, info);
            del = 0;
            long end = System.currentTimeMillis();
            System.out.println(" time:" + (end - start));
            ParametersFloat pf = params.average2((iter + 1) * is.size());
            try {
                if (options.testfile != null) {
                    this.outputParses(options, pipe, pf, false);
                    ParserEvaluator.evaluate(options.goldfile, options.outfile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Decoder.timeDecotder = 0L;
            Decoder.timeRearrange = 0L;
            Pipe.timeExtract = 0L;
            ++iter;
        }
        params.average(iter * is.size());
    }

    private void outputParses(OptionsSuper options, Pipe pipe, ParametersFloat params, boolean maxInfo) throws Exception {
        long start = System.currentTimeMillis();
        CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
        CONLLWriter09 depWriter = new CONLLWriter09(options.outfile, options.formatTask);
        int cnt = 0;
        int del = 0;
        long last = System.currentTimeMillis();
        if (maxInfo) {
            System.out.println("\nParsing Information ");
        }
        if (maxInfo) {
            System.out.println("------------------- ");
        }
        if (maxInfo && !options.decodeProjective) {
            System.out.println(Decoder.getInfo());
        }
        String[] types = new String[pipe.mf.getFeatureCounter().get("REL").intValue()];
        Pipe pipe2 = pipe;
        for (Map.Entry<String, Integer> e : pipe2.mf.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        System.out.print("Processing Sentence: ");
        while (true) {
            Instances is = new Instances();
            is.init(1, new MFB(), options.formatTask);
            SentenceData09 instance = pipe.nextInstance(is, depReader);
            if (instance == null) break;
            SentenceData09 i09 = this.parse(instance, params);
            depWriter.write(i09);
            del = PipeGen.outValue(++cnt, del, last);
        }
        depWriter.finishWriting();
        long end = System.currentTimeMillis();
        DB.println("rank\n" + this.rank + "\n");
        DB.println("x-best-las " + this.amongxbest + " x-best-ula " + this.amongxbest_ula + " cnt " + cnt + " x-best-las " + (float)this.amongxbest / (float)cnt + " x-best-ula " + (float)this.amongxbest_ula / (float)cnt + " nbest " + (float)this.nbest / (float)cnt + " 1best " + (float)(this.rank.get(0) == null ? 0 : this.rank.get(0)) / (float)cnt + " best-proj " + (float)this.bestProj / (float)cnt + " Sum LAS " + (float)this.smallestErrorSum / (float)this.countAllNodes);
        this.rank.clear();
        this.amongxbest = 0;
        this.amongxbest_ula = 0;
        cnt = 0;
        this.nbest = 0;
        this.bestProj = 0;
        if (maxInfo) {
            System.out.println("Used time " + (end - start));
        }
        if (maxInfo) {
            System.out.println("forms count " + Instances.m_count + " unkown " + Instances.m_unkown);
        }
    }

    private void getNBest(OptionsSuper options, Pipe pipe, ParametersFloat params, boolean maxInfo) throws Exception {
        CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
        int cnt = 0;
        String[] types = new String[pipe.mf.getFeatureCounter().get("REL").intValue()];
        Pipe pipe2 = pipe;
        for (Map.Entry<String, Integer> e : pipe2.mf.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        while (true) {
            Instances is = new Instances();
            is.init(1, new MFB(), options.formatTask);
            SentenceData09 instance = pipe.nextInstance(is, depReader);
            if (instance == null) break;
            ++cnt;
            this.parseNBest(instance);
        }
    }

    public SentenceData09 parse(SentenceData09 instance, ParametersFloat params) {
        DataF d2;
        String[] types = new String[this.pipe.mf.getFeatureCounter().get("REL").intValue()];
        for (Map.Entry<String, Integer> e : MFB.getFeatureSet().get("REL").entrySet()) {
            types[e.getValue().intValue()] = e.getKey();
        }
        Instances is = new Instances();
        is.init(1, new MFB(), this.options.formatTask);
        new CONLLReader09().insert(is, instance);
        String[] forms = instance.forms;
        try {
            d2 = this.pipe.fillVector(params.getFV(), is, 0, null, this.pipe.cl, THREADS, this.l2i);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        short[] pos = is.pposs[0];
        List<ParseNBest> parses = null;
        Parse d = null;
        try {
            parses = Decoder.decode(pos, d2, this.options.decodeProjective, this.pipe.extractor[0]);
            d = parses.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (parses.size() > NBest) {
            parses = parses.subList(0, NBest);
        }
        int g_las = Decoder.getGoldRank(parses, is, 0, true);
        int g_ula = Decoder.getGoldRank(parses, is, 0, false);
        int smallest = Decoder.getSmallestError(parses, is, 0, false);
        this.smallestErrorSum += is.length(0) - smallest;
        this.countAllNodes += is.length(0);
        if (g_las >= 0) {
            ++this.amongxbest;
        }
        if (g_ula >= 0) {
            ++this.amongxbest_ula;
        }
        this.nbest += parses.size();
        Integer r = this.rank.get(g_las);
        if (r == null) {
            this.rank.put(g_las, 1);
        } else {
            this.rank.put(g_las, r + 1);
        }
        float err = (float)this.pipe.errors(is, 0, d);
        float errBestProj = (float)this.pipe.errors(is, 0, Decoder.bestProj);
        if (errBestProj == 0.0f) {
            ++this.bestProj;
        }
        SentenceData09 i09 = new SentenceData09(instance);
        i09.createSemantic(instance);
        int j = 0;
        while (j < forms.length - 1) {
            i09.plabels[j] = types[d.labels[j + 1]];
            i09.pheads[j] = d.heads[j + 1];
            ++j;
        }
        return i09;
    }

    public List<ParseNBest> parseNBest(SentenceData09 instance) {
        DataF d2;
        Instances is = new Instances();
        is.init(1, new MFB(), this.options.formatTask);
        new CONLLReader09().insert(is, instance);
        try {
            d2 = this.pipe.fillVector(this.params.getFV(), is, 0, null, this.pipe.cl, THREADS, this.l2i);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        short[] pos = is.pposs[0];
        List<ParseNBest> parses = null;
        try {
            parses = Decoder.decode(pos, d2, this.options.decodeProjective, this.pipe.extractor[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (parses.size() > NBest) {
            parses = parses.subList(0, NBest);
        }
        return parses;
    }

    @Override
    public SentenceData09 apply(SentenceData09 snt09) {
        try {
            this.parse(snt09, this.params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Decoder.executerService.shutdown();
        Pipe.executerService.shutdown();
        return snt09;
    }

    private void writeModell(OptionsSuper options, ParametersFloat params, String extension, Cluster cs) throws FileNotFoundException, IOException {
        String name = extension == null ? options.modelName : String.valueOf(options.modelName) + extension;
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(name)));
        zos.putNextEntry(new ZipEntry("data"));
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
        MFB.writeData(dos);
        cs.write(dos);
        params.write(dos);
        Edges.write(dos);
        dos.writeBoolean(options.decodeProjective);
        dos.writeInt(this.pipe.extractor[0].getMaxForm());
        dos.writeInt(5);
        dos.writeUTF("Used parser   " + Parser.class.toString());
        dos.writeUTF("Creation date " + new SimpleDateFormat("yyyy.MM.dd HH:mm:ss").format(new Date()));
        dos.writeUTF("Training data " + options.trainfile);
        dos.writeUTF("Iterations    " + options.numIters + " Used sentences " + options.count);
        dos.writeUTF("Cluster       " + options.clusterFile);
        dos.flush();
        dos.close();
    }
}

