/*
 * Decompiled with CFR 0.152.
 */
package is2.parser;

import is2.data.Cluster;
import is2.data.DataFES;
import is2.data.F2SF;
import is2.data.Instances;
import is2.data.Parse;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.parser.Edges;
import is2.parser.Extractor;
import is2.parser.MFO;
import is2.parser.ParallelExtract;
import is2.parser.Parser;
import is2.util.OptionsSuper;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Pipe
extends PipeGen {
    public Extractor[] extractor;
    public final MFO mf = new MFO();
    public Cluster cl;
    private OptionsSuper options;
    public static long timeExtract;
    public static ExecutorService executerService;

    static {
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
    }

    public Pipe(OptionsSuper o) {
        this.options = o;
    }

    public void createInstances(String file, Instances is) throws Exception {
        SentenceData09 instance;
        CONLLReader09 depReader = new CONLLReader09(file);
        this.mf.register("REL", "<root-type>");
        long sl = 0L;
        System.out.print("Registering feature parts of sentence: ");
        int ic = 0;
        int del = 0;
        while ((instance = depReader.getNext()) != null) {
            sl += (long)instance.labels.length;
            if (++ic % 1000 == 0) {
                del = Pipe.outValue(ic, del);
            }
            String[] labs1 = instance.labels;
            int i1 = 0;
            while (i1 < labs1.length) {
                this.mf.register("REL", labs1[i1]);
                ++i1;
            }
            String[] w = instance.forms;
            int i12 = 0;
            while (i12 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i12]));
                ++i12;
            }
            w = instance.plemmas;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("WORD", depReader.normalize(w[i12]));
                ++i12;
            }
            w = instance.ppos;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("POS", w[i12]);
                ++i12;
            }
            w = instance.gpos;
            i12 = 0;
            while (i12 < w.length) {
                this.mf.register("POS", w[i12]);
                ++i12;
            }
            if (instance.feats != null) {
                String[][] fs = instance.feats;
                int i13 = 0;
                while (i13 < fs.length) {
                    w = fs[i13];
                    if (w != null) {
                        int i2 = 0;
                        while (i2 < w.length) {
                            this.mf.register("F", w[i2]);
                            ++i2;
                        }
                    }
                    ++i13;
                }
            }
            if (ic - 1 <= this.options.count) continue;
        }
        del = Pipe.outValue(ic, del);
        System.out.println();
        Extractor.initFeatures();
        Extractor.maxForm = this.mf.getFeatureCounter().get("WORD");
        this.cl = this.options.clusterFile == null ? new Cluster() : new Cluster(this.options.clusterFile, this.mf, 6);
        this.mf.calculateBits();
        Extractor.initStat(this.options.featureCreation);
        System.out.println(this.mf.toString());
        Extractor[] fs = this.extractor;
        int w = this.extractor.length;
        int labs1 = 0;
        while (labs1 < w) {
            Extractor e = fs[labs1];
            e.init();
            ++labs1;
        }
        depReader.startReading(file);
        int num1 = 0;
        is.init(ic, new MFO());
        Edges.init(this.mf.getFeatureCounter().get("POS"));
        System.out.print("Creating edge filters and read corpus: ");
        del = 0;
        while (true) {
            SentenceData09 instance1;
            if (num1 % 100 == 0) {
                del = Pipe.outValue(num1, del);
            }
            if ((instance1 = depReader.getNext(is)) == null) break;
            int last = is.size() - 1;
            short[] pos = is.pposs[last];
            int k = 0;
            while (k < is.length(last)) {
                if (is.heads[last][k] >= 0) {
                    Edges.put(pos[is.heads[last][k]], pos[k], is.labels[last][k]);
                }
                ++k;
            }
            if (!this.options.allFeatures && num1 > this.options.count) break;
            ++num1;
        }
        del = Pipe.outValue(num1, del);
        System.out.println();
        Edges.findDefault();
    }

    protected final SentenceData09 nextInstance(Instances is, CONLLReader09 depReader) throws Exception {
        SentenceData09 instance = depReader.getNext(is);
        if (instance == null || instance.forms == null) {
            return null;
        }
        return instance;
    }

    public DataFES fillVector(F2SF params, Instances is, int inst, DataFES d, Cluster cluster) throws InterruptedException {
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int length = is.length(inst);
        if (d == null || d.len < length) {
            d = new DataFES(length, this.mf.getFeatureCounter().get("REL").shortValue());
        }
        ArrayList<ParallelExtract> pe = new ArrayList<ParallelExtract>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new ParallelExtract(this.extractor[i], is, inst, d, (F2SF)params.clone(), cluster));
            ++i;
        }
        int w1 = 0;
        while (w1 < length) {
            int w2 = w1 + 1;
            while (w2 < length) {
                if (w1 != w2) {
                    ParallelExtract.add(w1, w2);
                }
                ++w2;
            }
            ++w1;
        }
        executerService.invokeAll(pe);
        timeExtract += System.nanoTime() - ts;
        return d;
    }

    public double errors(Instances is, int ic, Parse p) {
        short[] act = is.heads[ic];
        double correct = 0.0;
        int i = 1;
        while (i < act.length) {
            if (p.heads[i] == act[i]) {
                correct += 0.5;
                if (p.labels[i] == is.labels[ic][i]) {
                    correct += 0.5;
                }
            }
            ++i;
        }
        double x = (double)act.length - 1.0 - correct;
        p.f1 = correct / (double)(act.length - 1);
        return x;
    }
}

