/*
 * Decompiled with CFR 0.152.
 */
package is2.parser;

import is2.util.DB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public final class Edges {
    private static short[][][] edges;
    private static HashMap<Short, Integer> labelCount;
    private static HashMap<String, Integer> slabelCount;
    static short[] def;

    static {
        labelCount = new HashMap();
        slabelCount = new HashMap();
        def = new short[1];
    }

    private Edges() {
    }

    public static void init(int length) {
        edges = new short[length][length][];
    }

    public static void findDefault() {
        int best = 0;
        for (Map.Entry<Short, Integer> e : labelCount.entrySet()) {
            if (best >= e.getValue()) continue;
            best = e.getValue();
            Edges.def[0] = e.getKey();
        }
        DB.println("set default label to " + def[0] + " ");
    }

    public static final void put(int pos1, int pos2, short label) {
        Edges.putD(pos1, pos2, label);
    }

    public static final void putD(int pos1, int pos2, short label) {
        Integer lc = labelCount.get(label);
        if (lc == null) {
            labelCount.put(label, 1);
        } else {
            labelCount.put(label, lc + 1);
        }
        String key = String.valueOf(pos1) + "-" + pos2 + label;
        Integer lcs = slabelCount.get(key);
        if (lcs == null) {
            slabelCount.put(key, 1);
        } else {
            slabelCount.put(key, lcs + 1);
        }
        if (edges[pos1][pos2] == null) {
            Edges.edges[pos1][pos2] = new short[1];
            Edges.edges[pos1][pos2][0] = label;
        } else {
            short[] labels;
            short[] sArray = labels = edges[pos1][pos2];
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                short l = sArray[n2];
                if (l == label) {
                    return;
                }
                ++n2;
            }
            short[] nlabels = new short[labels.length + 1];
            System.arraycopy(labels, 0, nlabels, 0, labels.length);
            nlabels[labels.length] = label;
            Edges.edges[pos1][pos2] = nlabels;
        }
    }

    public static final short[] get(int pos1, int pos2) {
        if (pos1 < 0 || pos2 < 0 || edges[pos1][pos2] == null) {
            return def;
        }
        return edges[pos1][pos2];
    }

    public static void write(DataOutputStream d) throws IOException {
        int len = edges.length;
        d.writeShort(len);
        int p1 = 0;
        while (p1 < len) {
            int p2 = 0;
            while (p2 < len) {
                if (edges[p1][p2] == null) {
                    d.writeShort(0);
                } else {
                    d.writeShort(edges[p1][p2].length);
                    int l = 0;
                    while (l < edges[p1][p2].length) {
                        d.writeShort(edges[p1][p2][l]);
                        ++l;
                    }
                }
                ++p2;
            }
            ++p1;
        }
        d.writeShort(def[0]);
    }

    public static void read(DataInputStream d) throws IOException {
        int len = d.readShort();
        edges = new short[len][len][];
        int p1 = 0;
        while (p1 < len) {
            int p2 = 0;
            while (p2 < len) {
                int ll = d.readShort();
                if (ll == 0) {
                    Edges.edges[p1][p2] = null;
                } else {
                    Edges.edges[p1][p2] = new short[ll];
                    int l = 0;
                    while (l < ll) {
                        Edges.edges[p1][p2][l] = d.readShort();
                        ++l;
                    }
                }
                ++p2;
            }
            ++p1;
        }
        Edges.def[0] = d.readShort();
    }

    public static class C
    implements Comparator<Short> {
        String _key;

        public C() {
        }

        public C(String key) {
            this._key = key;
        }

        @Override
        public int compare(Short l1, Short l2) {
            int x2;
            int x1 = (Integer)slabelCount.get(String.valueOf(this._key) + l1);
            return x1 == (x2 = ((Integer)slabelCount.get(String.valueOf(this._key) + l2)).intValue()) ? 0 : (x1 > x2 ? -1 : 1);
        }
    }
}

