/*
 * Decompiled with CFR 0.152.
 */
package is2.parser;

import is2.data.DataFES;
import is2.data.Parse;
import is2.parser.Closed;
import is2.parser.Extractor;
import is2.parser.Open;
import is2.parser.ParallelDecoder;
import is2.parser.ParallelRearrange;
import is2.parser.Parser;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Decoder {
    public static final boolean TRAINING = true;
    public static long timeDecotder;
    public static long timeRearrange;
    public static float NON_PROJECTIVITY_THRESHOLD;
    static ExecutorService executerService;

    static {
        NON_PROJECTIVITY_THRESHOLD = 0.3f;
        executerService = Executors.newFixedThreadPool(Parser.THREADS);
    }

    private Decoder() {
    }

    public static Parse decode(short[] pos, DataFES x, boolean projective, boolean training) throws InterruptedException {
        long ts = System.nanoTime();
        if (executerService.isShutdown()) {
            executerService = Executors.newCachedThreadPool();
        }
        int n = pos.length;
        Open[][][][] O2 = new Open[n][n][2][];
        Closed[][][][] C2 = new Closed[n][n][2][];
        ArrayList<ParallelDecoder> pe = new ArrayList<ParallelDecoder>();
        int i = 0;
        while (i < Parser.THREADS) {
            pe.add(new ParallelDecoder(pos, x, O2, C2, n));
            ++i;
        }
        int k = 1;
        while (k < n) {
            int s = 0;
            while (s < n) {
                short t = (short)(s + k);
                if (t >= n) break;
                ParallelDecoder.add((short)s, t);
                s = (short)(s + 1);
            }
            executerService.invokeAll(pe);
            k = (short)(k + 1);
        }
        float bestSpanScore = Float.NEGATIVE_INFINITY;
        Closed bestSpan = null;
        int m = 1;
        while (m < n) {
            if (C2[0][n - 1][1][m].p > bestSpanScore) {
                bestSpanScore = C2[0][n - 1][1][m].p;
                bestSpan = C2[0][n - 1][1][m];
            }
            ++m;
        }
        Parse out = new Parse(pos.length);
        bestSpan.create(out);
        out.heads[0] = -1;
        out.labels[0] = 0;
        timeDecotder += System.nanoTime() - ts;
        ts = System.nanoTime();
        if (!projective) {
            Decoder.rearrange(pos, out.heads, out.labels, x, training);
        }
        timeRearrange += System.nanoTime() - ts;
        return out;
    }

    /*
     * Unable to fully structure code
     */
    public static void rearrange(short[] pos, short[] heads, short[] labs, DataFES x, boolean training) throws InterruptedException {
        threads = pos.length > Parser.THREADS ? Parser.THREADS : pos.length;
        wh = -1;
        nPar = -1;
        nType = -1;
        pe = new ArrayList<ParallelRearrange>();
        while (true) {
            isChild = new boolean[heads.length][heads.length];
            i = 1;
            l1 = 1;
            ** GOTO lbl15
            {
                isChild[l1][i] = true;
                do {
                    if ((l1 = heads[l1]) != -1) continue block1;
                    l1 = ++i;
lbl15:
                    // 2 sources

                } while (i < heads.length);
            }
            max = -Infinityf;
            p = Extractor.encode3(pos, heads, labs, x);
            pe.clear();
            i = 0;
            while (i < threads) {
                pe.add(new ParallelRearrange(isChild, pos, x, heads, labs));
                ++i;
            }
            ch = 1;
            while (ch < heads.length) {
                pa = 0;
                while (pa < heads.length) {
                    if (ch != pa && pa != heads[ch] && !isChild[ch][pa]) {
                        ParallelRearrange.add(p, (short)ch, pa);
                    }
                    pa = (short)(pa + 1);
                }
                ++ch;
            }
            Decoder.executerService.invokeAll(pe);
            for (ParallelRearrange.PA rp : ParallelRearrange.order) {
                if (!(max < rp.max)) continue;
                max = rp.max;
                wh = rp.wh;
                nPar = rp.nPar;
                nType = rp.nType;
            }
            ParallelRearrange.order.clear();
            if (max <= Decoder.NON_PROJECTIVITY_THRESHOLD) break;
            heads[wh] = nPar;
            labs[wh] = nType;
        }
    }

    public static String getInfo() {
        return "Decoder non-projectivity threshold: " + NON_PROJECTIVITY_THRESHOLD;
    }
}

