/*
 * Decompiled with CFR 0.152.
 */
package is2.mtag;

import is2.data.Cluster;
import is2.data.FV;
import is2.data.Instances;
import is2.data.InstancesTagger;
import is2.data.Long2Int;
import is2.data.ParametersFloat;
import is2.data.PipeGen;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.io.CONLLWriter09;
import is2.mtag.Evaluator;
import is2.mtag.ExtractorM;
import is2.mtag.MFO;
import is2.mtag.Options;
import is2.tools.IPipe;
import is2.tools.Tool;
import is2.tools.Train;
import is2.util.DB;
import is2.util.OptionsSuper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Tagger
implements Tool,
Train {
    ExtractorM pipe;
    ParametersFloat params;

    public Tagger(Options options) {
        try {
            this.readModel(options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Tagger(String modelFileName) {
        this(new Options(new String[]{"-model", modelFileName}));
    }

    public Tagger() {
    }

    public static void main(String[] args) throws FileNotFoundException, Exception {
        Options options = new Options(args);
        Tagger tagger = new Tagger();
        if (options.train) {
            Long2Int li = new Long2Int(options.hsize);
            tagger.pipe = new ExtractorM(options, li);
            InstancesTagger is = (InstancesTagger)tagger.pipe.createInstances(options.trainfile);
            ParametersFloat params = new ParametersFloat(li.size());
            tagger.train(options, tagger.pipe, params, is);
            tagger.writeModel(options, tagger.pipe, params);
        }
        if (options.test) {
            tagger.readModel(options);
            tagger.out(options, tagger.pipe, tagger.params);
        }
        if (options.eval) {
            System.out.println("\nEvaluate:");
            Evaluator.evaluate(options.goldfile, options.outfile, options.format);
        }
    }

    @Override
    public void writeModel(OptionsSuper options, IPipe pipe, ParametersFloat params) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(options.modelName)));
            zos.putNextEntry(new ZipEntry("data"));
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(zos));
            MFO.writeData(dos);
            MFO.clearData();
            DB.println("number of parameters " + params.parameters.length);
            dos.flush();
            params.write(dos);
            pipe.write(dos);
            dos.flush();
            dos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readModel(OptionsSuper options) {
        try {
            this.pipe = new ExtractorM(options);
            this.params = new ParametersFloat(0);
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(options.modelName)));
            zis.getNextEntry();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(zis));
            this.pipe.mf.read(dis);
            this.pipe.initValues();
            this.pipe.initFeatures();
            this.params.read(dis);
            this.pipe.li = new Long2Int(this.params.parameters.length);
            this.pipe.cl = new Cluster(dis);
            this.pipe.readMap(dis);
            dis.close();
            this.pipe.types = new String[this.pipe.mf.getFeatureCounter().get("F").intValue()];
            ExtractorM extractorM = this.pipe;
            for (Map.Entry<String, Integer> e : extractorM.mf.getFeatureSet().get("F").entrySet()) {
                this.pipe.types[e.getValue().intValue()] = e.getKey();
            }
            DB.println("Loading data finished. ");
            DB.println("number of parameter " + this.params.parameters.length);
            DB.println("number of classes   " + this.pipe.types.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void train(OptionsSuper options, IPipe pipe, ParametersFloat params, Instances is) {
        int i = 0;
        int del = 0;
        MFO cfr_ignored_0 = this.pipe.mf;
        ExtractorM extractorM = this.pipe;
        String[] wds = MFO.reverse(extractorM.mf.getFeatureSet().get("WORD"));
        int numInstances = is.size();
        float upd = options.numIters * numInstances + 1;
        i = 0;
        while (i < options.numIters) {
            long start = System.currentTimeMillis();
            long last = System.currentTimeMillis();
            FV pred = new FV();
            FV gold = new FV();
            int correct = 0;
            int count = 0;
            int n = 0;
            while (n < numInstances) {
                upd -= 1.0f;
                if ((n + 1) % 500 == 0) {
                    del = PipeGen.outValueErr(n + 1, count - correct, (float)correct / (float)count, del, last, upd);
                }
                int length = is.length(n);
                int[] feats = new int[length];
                long[] vs = new long[ExtractorM._FC];
                int w1 = 0;
                while (w1 < length) {
                    ++count;
                    if (this.pipe.form2morph.get(is.forms[n][w1]) != null) {
                        ++correct;
                    } else {
                        int bestType;
                        feats[w1] = bestType = this.pipe.fillFeatureVectorsOne(params, w1, wds[is.forms[n][w1]], is, n, is.gfeats[n], vs);
                        if (bestType == is.gfeats[n][w1]) {
                            ++correct;
                        } else {
                            pred.clear();
                            int p = bestType << ExtractorM.s_type;
                            int k = 0;
                            while (k < vs.length) {
                                if (vs[k] == Integer.MIN_VALUE) break;
                                if (vs[k] >= 0L) {
                                    pred.add(this.pipe.li.l2i(vs[k] + (long)p));
                                }
                                ++k;
                            }
                            gold.clear();
                            p = is.gfeats[n][w1] << ExtractorM.s_type;
                            k = 0;
                            while (k < vs.length) {
                                if (vs[k] == Integer.MIN_VALUE) break;
                                if (vs[k] >= 0L) {
                                    gold.add(this.pipe.li.l2i(vs[k] + (long)p));
                                }
                                ++k;
                            }
                            params.update(pred, gold, upd, 1.0f);
                        }
                    }
                    ++w1;
                }
                ++n;
            }
            long end = System.currentTimeMillis();
            String info = "time " + (end - start);
            del = PipeGen.outValueErr(numInstances, count - correct, (float)correct / (float)count, del, last, 0.0, info);
            System.out.println();
            ++i;
        }
        params.average(i * is.size());
    }

    @Override
    public void out(OptionsSuper options, IPipe pipe, ParametersFloat params) {
        try {
            long start = System.currentTimeMillis();
            CONLLReader09 depReader = new CONLLReader09(options.testfile, options.formatTask);
            CONLLWriter09 depWriter = new CONLLWriter09(options.outfile, options.formatTask);
            depReader.normalizeOn = false;
            System.out.print("Processing Sentence: ");
            pipe.initValues();
            int cnt = 0;
            int del = 0;
            while (true) {
                InstancesTagger is = new InstancesTagger();
                is.init(1, this.pipe.mf);
                ++cnt;
                SentenceData09 instance = depReader.getNext(is);
                if (instance == null || instance.forms == null) break;
                is.fillChars(instance, 0, ExtractorM._CEND);
                instance = this.exec(instance, this.pipe, params, is);
                SentenceData09 i09 = new SentenceData09(instance);
                i09.createSemantic(instance);
                if (options.overwritegold) {
                    i09.ofeats = i09.pfeats;
                }
                depWriter.write(i09);
                if (cnt % 100 != 0) continue;
                del = PipeGen.outValue(cnt, del);
            }
            depWriter.finishWriting();
            del = PipeGen.outValue(cnt, del);
            long end = System.currentTimeMillis();
            System.out.println(PipeGen.getSecondsPerInstnace(cnt, end - start));
            System.out.println(PipeGen.getUsedTime(end - start));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SentenceData09 exec(SentenceData09 instance, ExtractorM pipe, ParametersFloat params, InstancesTagger is) {
        int bestType;
        int length = instance.ppos.length;
        short[] feats = new short[instance.gpos.length];
        long[] vs = new long[ExtractorM._FC];
        String[] forms = instance.forms;
        instance.pfeats = new String[instance.gpos.length];
        int j = 0;
        while (j < length) {
            if (pipe.form2morph.get(is.forms[0][j]) != null) {
                feats[j] = (short)pipe.form2morph.get(is.forms[0][j]).intValue();
                instance.pfeats[j] = this.pipe.types[feats[j]];
            } else {
                bestType = pipe.fillFeatureVectorsOne(params, j, forms[j], is, 0, feats, vs);
                feats[j] = (short)bestType;
                instance.pfeats[j] = this.pipe.types[bestType];
            }
            ++j;
        }
        j = 0;
        while (j < length) {
            if (pipe.form2morph.get(is.forms[0][j]) != null) {
                feats[j] = (short)pipe.form2morph.get(is.forms[0][j]).intValue();
                instance.pfeats[j] = this.pipe.types[feats[j]];
            } else {
                bestType = pipe.fillFeatureVectorsOne(params, j, forms[j], is, 0, feats, vs);
                feats[j] = (short)bestType;
                instance.pfeats[j] = this.pipe.types[bestType];
            }
            ++j;
        }
        return instance;
    }

    @Override
    public SentenceData09 apply(SentenceData09 instance) {
        try {
            InstancesTagger is = new InstancesTagger();
            is.init(1, this.pipe.mf);
            is.createInstance09(instance.forms.length);
            String[] forms = instance.forms;
            int length = forms.length;
            int i = 0;
            while (i < length) {
                is.setForm(0, i, forms[i]);
                ++i;
            }
            is.setLemma(0, 0, "<root-LEMMA>");
            i = 1;
            while (i < length) {
                is.setLemma(0, i, instance.plemmas[i]);
                ++i;
            }
            is.setPPoss(0, 0, "<root-POS>");
            i = 1;
            while (i < length) {
                is.setPPoss(0, i, instance.ppos[i]);
                ++i;
            }
            is.fillChars(instance, 0, ExtractorM._CEND);
            this.exec(instance, this.pipe, this.params, is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }
}

