/*
 * Decompiled with CFR 0.152.
 */
package is2.mtag;

import is2.mtag.Options;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class Convert {
    public static void main(String[] args) throws IOException {
        Options options = new Options(args);
        Convert.split(options.trainfile);
    }

    private static void split(String trainfile) throws IOException {
        String dir = "split";
        boolean success = new File("split").mkdir();
        if (success) {
            System.out.println("Directory: " + dir + " created");
        }
        ArrayList<String> corpus = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(trainfile), "UTF-8"), 32768);
        String l = null;
        int sentences = 0;
        try {
            while ((l = reader.readLine()) != null) {
                corpus.add(l);
                if (l.length() >= 8) continue;
                ++sentences;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Corpus has " + sentences + " sentences.");
        int partSize = sentences / 20;
        System.out.println("Prepare corpus for cross annotations with 20 parts with part size " + partSize + " number of lines " + corpus.size());
        int k = 0;
        while (k < 20) {
            BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("split/p-" + k), "UTF-8"));
            BufferedWriter rest = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("split/r-" + k), "UTF-8"));
            int skip = k * partSize;
            int countSentences = 0;
            int countSentencesWrote = 0;
            System.out.println("skip from " + skip + " to " + (skip + partSize - 1));
            for (String x : corpus) {
                if (countSentences >= skip && (countSentences < skip + partSize || k == 19)) {
                    rest.write(x);
                    rest.newLine();
                    if (x.length() < 8) {
                        ++countSentencesWrote;
                    }
                } else {
                    br.write(x);
                    br.newLine();
                }
                if (x.length() >= 8) continue;
                ++countSentences;
            }
            System.out.println("wrote for this part " + countSentencesWrote);
            br.flush();
            br.close();
            rest.flush();
            rest.close();
            ++k;
        }
    }
}

