/*
 * Decompiled with CFR 0.152.
 */
package is2.lemmatizer;

import is2.util.OptionsSuper;
import java.io.File;
import java.io.IOException;

public final class Options
extends OptionsSuper {
    public Options(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--help")) {
                this.explain();
            }
            if (args[i].equals("-normalize")) {
                this.normalize = Boolean.parseBoolean(args[++i]);
            } else if (args[i].equals("-features")) {
                this.features = args[i + 1];
                ++i;
            } else if (args[i].equals("-hsize")) {
                this.hsize = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-len")) {
                this.maxLen = Integer.parseInt(args[i + 1]);
                ++i;
            } else if (args[i].equals("-tmp")) {
                this.tmp = args[i + 1];
                ++i;
            } else if (args[i].equals("-uc")) {
                this.upper = true;
                System.out.println("set uppercase " + this.upper);
            } else {
                super.addOption(args, i);
            }
            ++i;
        }
        if (this.trainfile != null) {
            this.trainforest = this.tmp != null ? File.createTempFile("train", ".tmp", new File(this.tmp)) : File.createTempFile("train", ".tmp");
            this.trainforest.deleteOnExit();
        }
    }

    private void explain() {
        System.out.println("Usage: ");
        System.out.println("java -class mate.jar is2.lemmatizer.Lemmatizer [Options]");
        System.out.println();
        System.out.println("Options:");
        System.out.println("");
        System.out.println(" -train  <file>    the corpus a model is trained on; default " + this.trainfile);
        System.out.println(" -test   <file>    the input corpus for testing; default " + this.testfile);
        System.out.println(" -out    <file>    the output corpus (result) of a test run; default " + this.outfile);
        System.out.println(" -model  <file>    the parsing model for traing the model is stored in the files");
        System.out.println("                   and for parsing the model is load from this file; default " + this.modelName);
        System.out.println(" -i      <number>  the number of training iterations; good numbers are 10 for smaller corpora and 6 for bigger; default " + this.numIters);
        System.out.println(" -count  <number>  the n first sentences of the corpus are take for the training default " + this.count);
        System.exit(0);
    }
}

