/*
 * Decompiled with CFR 0.152.
 */
package is2.lemmatizer;

import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;

public class Evaluator {
    public static void evaluate(String act_file, String pred_file, String format) throws Exception {
        CONLLReader09 goldReader = new CONLLReader09(act_file, false);
        CONLLReader09 predictedReader = new CONLLReader09(pred_file, false);
        Hashtable<String, Integer> errors = new Hashtable<String, Integer>();
        int total = 0;
        boolean corr = false;
        int corrL = 0;
        int corrT = 0;
        int numsent = 0;
        int corrsent = 0;
        int corrsentL = 0;
        SentenceData09 goldInstance = goldReader.getNext();
        SentenceData09 predInstance = predictedReader.getNext();
        while (goldInstance != null) {
            int instanceLength = goldInstance.length();
            if (instanceLength != predInstance.length()) {
                System.out.println("Lengths do not match on sentence " + numsent);
            }
            String[] gold = goldInstance.lemmas;
            String[] pred = predInstance.plemmas;
            boolean whole = true;
            boolean wholeL = true;
            int i = 1;
            while (i < instanceLength) {
                if (gold[i].toLowerCase().equals(pred[i].toLowerCase())) {
                    ++corrT;
                }
                if (gold[i].equals(pred[i])) {
                    ++corrL;
                } else {
                    String key = "gold: '" + gold[i] + "' pred: '" + pred[i] + "'";
                    Integer cnt = (Integer)errors.get(key);
                    if (cnt == null) {
                        errors.put(key, 1);
                    } else {
                        errors.put(key, cnt + 1);
                    }
                }
                ++i;
            }
            total += instanceLength - 1;
            if (whole) {
                ++corrsent;
            }
            if (wholeL) {
                ++corrsentL;
            }
            ++numsent;
            goldInstance = goldReader.getNext();
            predInstance = predictedReader.getNext();
        }
        ArrayList opsl = new ArrayList();
        for (Map.Entry e : errors.entrySet()) {
            opsl.add(e);
        }
        Collections.sort(opsl, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() == o2.getValue() ? 0 : (o1.getValue() > o2.getValue() ? 1 : -1);
            }
        });
        for (Map.Entry entry : opsl) {
        }
        System.out.println("Tokens: " + total + " Correct: " + corrT + " " + (float)corrT / (float)total + " correct uppercase " + (float)corrL / (float)total);
    }

    public static void main(String[] args) throws Exception {
        String format = "CONLL";
        if (args.length > 2) {
            format = args[2];
        }
        Evaluator.evaluate(args[0], args[1], format);
    }
}

