/*
 * Decompiled with CFR 0.152.
 */
package is2.io;

import is2.data.PSTree;
import is2.io.PSReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;

public class TigerReader
implements PSReader {
    BufferedReader inputReader;
    ArrayList<File> psFiles = new ArrayList();
    ArrayList<PSTree> psCache = new ArrayList();
    String[] filter = null;
    int startFilter = -1;
    int endFilter = -1;
    static int stop = 0;

    public TigerReader() {
    }

    public TigerReader(String file) {
        try {
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"), 32768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startReading(String file, String[] filter) {
        try {
            this.filter = filter;
            this.startFilter = filter == null ? -1 : 1;
            this.endFilter = filter == null ? -1 : 1;
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"), 32768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public PSTree getNext() {
        PSTree ps = null;
        String l = null;
        ArrayList<Line> lines = new ArrayList<Line>();
        try {
            int state = 1;
            int terminals = 0;
            int nonterminals = 0;
            while ((l = this.inputReader.readLine()) != null) {
                Line line2;
                if (this.startFilter == 1 && l.startsWith("#BOS " + this.filter[0])) {
                    System.out.println("found start " + l);
                    this.startFilter = 2;
                }
                if (this.endFilter == 1 && l.startsWith("#EOS " + this.filter[1])) {
                    System.out.println("found end " + l);
                    this.endFilter = 2;
                }
                if (this.startFilter == 1 || this.endFilter == 2) continue;
                if (l.startsWith("#BOS")) {
                    state = 2;
                    continue;
                }
                if (l.startsWith("#500")) {
                    state = 3;
                }
                if (l.startsWith("#EOS")) {
                    state = 4;
                }
                if (state < 2) continue;
                if (state == 4) {
                    ps = new PSTree();
                    ps.create(terminals, nonterminals);
                    int cnt = 0;
                    int root = -1;
                    for (Line line2 : lines) {
                        ps.entries[cnt] = line2.form;
                        if (cnt < terminals) {
                            ps.pos[cnt] = line2.pos;
                        } else {
                            ps.entries[cnt] = line2.pos;
                        }
                        ps.lemmas[cnt] = line2.lemma;
                        ps.head[cnt] = line2.parent == 0 ? lines.size() - 1 : (line2.parent >= 500 ? line2.parent - 500 + terminals : line2.parent);
                        ps.morph[cnt] = line2.morph;
                        ++cnt;
                    }
                    if (root == -1) {
                        root = terminals;
                    }
                    ps.head[cnt - 1] = 0;
                    ps.terminalCount = terminals;
                    lines.clear();
                    state = 1;
                    return ps;
                }
                StringTokenizer t = new StringTokenizer(l, "\t");
                int tc = 0;
                line2 = new Line();
                lines.add(line2);
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    if (token.equals("\t")) continue;
                    if (tc == 0) {
                        if (token.startsWith("#5") || token.startsWith("#6")) {
                            ++nonterminals;
                        } else {
                            ++terminals;
                            line2.form = token;
                        }
                    } else if (tc == 1) {
                        line2.lemma = token;
                    } else if (tc == 2) {
                        line2.pos = token;
                    } else if (tc == 3) {
                        line2.morph = token;
                    } else if (tc == 4) {
                        line2.edge = token;
                    } else if (tc == 5) {
                        line2.parent = Integer.parseInt(token);
                    }
                    if (token.length() <= 0) continue;
                    ++tc;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ps;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeTraces(ArrayList<Object> tree) {
        Stack<ArrayList> s = new Stack<ArrayList>();
        s.push(tree);
        ArrayList list = null;
        while (!s.isEmpty()) {
            ArrayList last = list;
            list = (ArrayList)s.pop();
            int k = 0;
            while (k < list.size()) {
                block9: {
                    Object o;
                    block8: {
                        ArrayList<Object> rest;
                        o = list.get(k);
                        if (!(o instanceof String)) break block8;
                        String t = (String)o;
                        if ((t.endsWith("-1") || t.endsWith("-2") || t.endsWith("-3") || t.endsWith("-4")) && list.size() > k + 1) {
                            t = t.substring(0, t.length() - 2);
                            list.set(k, t);
                        }
                        if (!t.startsWith("-NONE-")) break block8;
                        if (last.size() == 2 && last.get(0) instanceof String && last.contains(list)) {
                            rest = this.remove(tree, last);
                            if (rest != null && rest.size() == 1) {
                                rest = this.remove(tree, rest);
                            }
                            break block9;
                        } else {
                            rest = this.remove(tree, list);
                            this.removeTraces(rest);
                            if (rest.size() == 1 && (rest = this.remove(tree, rest)) != null && rest.size() == 1) {
                                System.out.println("rest " + rest);
                                System.exit(0);
                            }
                        }
                        break block9;
                    }
                    if (o instanceof ArrayList) {
                        s.push((ArrayList)o);
                    }
                }
                ++k;
            }
        }
    }

    private ArrayList<Object> remove(ArrayList<Object> tree, Object p) {
        Stack<ArrayList> s = new Stack<ArrayList>();
        s.push(tree);
        while (!s.isEmpty()) {
            ArrayList list = (ArrayList)s.pop();
            int k = 0;
            while (k < list.size()) {
                Object o = list.get(k);
                if (o == p) {
                    list.remove(p);
                    return list;
                }
                if (o instanceof ArrayList) {
                    s.push((ArrayList)o);
                }
                ++k;
            }
        }
        return null;
    }

    private int countTerminals(ArrayList<Object> current) {
        int count = 0;
        boolean found = false;
        boolean all = true;
        for (Object o : current) {
            if (o instanceof String) {
                found = true;
                continue;
            }
            all = false;
            if (!(o instanceof ArrayList)) continue;
            count += this.countTerminals((ArrayList)o);
        }
        if (found && all) {
            ++count;
        }
        return count;
    }

    private int insert(PSTree ps, ArrayList<Object> current, Integer terminal, Integer xxx, int head) {
        boolean found = false;
        boolean all = true;
        String term = null;
        String pos = null;
        for (Object o : current) {
            if (o instanceof String) {
                if (found) {
                    term = (String)o;
                }
                if (!found) {
                    pos = (String)o;
                }
                found = true;
                continue;
            }
            all = false;
        }
        if (found && all) {
            if (term.equals("-LRB-")) {
                term = "(";
            }
            if (term.equals("-RRB-")) {
                term = ")";
            }
            if (term.equals("-LCB-")) {
                term = "{";
            }
            if (term.equals("-RCB-")) {
                term = "}";
            }
            if (term.contains("1\\/2-year")) {
                term = term.replace("\\/", "/");
            }
            if (term.contains("1\\/2-foot-tall")) {
                term = term.replace("\\/", "/");
            }
            ps.entries[ps.terminalCount] = term;
            ps.pos[ps.terminalCount] = pos;
            ps.head[ps.terminalCount] = head;
            ++ps.terminalCount;
        } else if (found && !all) {
            if (pos.startsWith("NP-SBJ")) {
                pos = "NP-SBJ";
            }
            if (pos.startsWith("WHNP")) {
                pos = "WHNP";
            }
            ps.entries[ps.non] = pos;
            ps.head[ps.non] = head;
            int non = ps.non++;
            for (Object o : current) {
                if (!(o instanceof ArrayList)) continue;
                this.insert(ps, (ArrayList)o, terminal, ps.non, non);
            }
        }
        if (!all && !found) {
            for (Object o : current) {
                if (!(o instanceof ArrayList)) continue;
                this.insert(ps, (ArrayList)o, terminal, 0, ps.non - 1);
            }
        }
        return terminal;
    }

    private int countNonTerminals(ArrayList<Object> current) {
        int count = 0;
        boolean found = false;
        boolean all = true;
        for (Object o : current) {
            if (o instanceof String) {
                found = true;
                continue;
            }
            all = false;
            if (!(o instanceof ArrayList)) continue;
            count += this.countNonTerminals((ArrayList)o);
        }
        if (found && !all) {
            ++count;
        }
        return count;
    }

    public static class Line {
        String form;
        String lemma;
        String morph;
        String pos;
        int parent;
        String edge;
    }
}

