/*
 * Decompiled with CFR 0.152.
 */
package is2.io;

import is2.data.Instances;
import is2.data.SentenceData09;
import is2.io.IOGenerals;
import is2.util.DB;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class CONLLReader08
extends IOGenerals {
    private BufferedReader inputReader;
    public static final boolean NORMALIZE = true;
    public static final boolean NO_NORMALIZE = false;
    public boolean normalizeOn = true;
    private int format = 0;
    private int lineNumber = 0;

    public CONLLReader08(boolean normalize) {
        this.normalizeOn = normalize;
    }

    public CONLLReader08(String file) {
        this.lineNumber = 0;
        try {
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), 32768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CONLLReader08(String file, boolean normalize) {
        this(file);
        this.normalizeOn = normalize;
    }

    public void setInputFormat(int format) {
        this.format = format;
    }

    public CONLLReader08() {
    }

    public CONLLReader08(String testfile, int formatTask) {
        this(testfile);
    }

    public void startReading(String file) {
        this.lineNumber = 0;
        try {
            this.inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"), 32768);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SentenceData09 getNext() {
        if (1 == this.format) {
            return this.getNextOneLine();
        }
        return this.getNextCoNLL09();
    }

    private SentenceData09 getNextOneLine() {
        int i;
        String line;
        block5: {
            line = null;
            i = 0;
            line = this.inputReader.readLine();
            ++this.lineNumber;
            if (line != null) break block5;
            this.inputReader.close();
            return null;
        }
        try {
            String[] tokens = line.split(" ");
            int length = tokens.length;
            if (line.isEmpty()) {
                length = 0;
            }
            SentenceData09 it = new SentenceData09();
            it.forms = new String[length + 1];
            it.plemmas = new String[length + 1];
            it.gpos = new String[length + 1];
            it.labels = new String[length + 1];
            it.heads = new int[length + 1];
            it.pheads = new int[length + 1];
            it.plabels = new String[length + 1];
            it.ppos = new String[length + 1];
            it.lemmas = new String[length + 1];
            it.fillp = new String[length + 1];
            it.feats = new String[length + 1][];
            it.ofeats = new String[length + 1];
            it.pfeats = new String[length + 1];
            it.id = new String[length + 1];
            it.forms[0] = "<root>";
            it.plemmas[0] = "<root-LEMMA>";
            it.fillp[0] = "N";
            it.lemmas[0] = "<root-LEMMA>";
            it.gpos[0] = "<root-POS>";
            it.ppos[0] = "<root-POS>";
            it.labels[0] = "<no-type>";
            it.heads[0] = -1;
            it.plabels[0] = "<no-type>";
            it.pheads[0] = -1;
            it.ofeats[0] = "<no-type>";
            it.id[0] = "0";
            i = 1;
            while (i <= length) {
                it.id[i] = "" + i;
                it.forms[i] = this.normalizeOn ? this.normalize(tokens[i - 1]) : tokens[i - 1];
                ++i;
            }
            return it;
        }
        catch (Exception e) {
            System.out.println("\n!!! Error in input file sentence before line: " + this.lineNumber + " (in sentence line " + i + " ) " + e.toString());
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public SentenceData09 getNextCoNLL09() {
        int length;
        ArrayList<String[]> lineList;
        int i;
        block11: {
            String line = null;
            i = 0;
            lineList = new ArrayList<String[]>();
            line = this.inputReader.readLine();
            ++this.lineNumber;
            while (line != null && line.length() == 0) {
                line = this.inputReader.readLine();
                ++this.lineNumber;
                System.out.println("skip empty line at line " + this.lineNumber);
            }
            while (line != null && line.length() != 0 && !line.startsWith("*") && !line.startsWith("\t")) {
                lineList.add(line.split("\t"));
                line = this.inputReader.readLine();
                ++this.lineNumber;
            }
            length = lineList.size();
            if (length != 0) break block11;
            this.inputReader.close();
            return null;
        }
        try {
            SentenceData09 it = new SentenceData09();
            it.forms = new String[length + 1];
            it.plemmas = new String[length + 1];
            it.gpos = new String[length + 1];
            it.labels = new String[length + 1];
            it.heads = new int[length + 1];
            it.pheads = new int[length + 1];
            it.plabels = new String[length + 1];
            it.ppos = new String[length + 1];
            it.lemmas = new String[length + 1];
            it.fillp = new String[length + 1];
            it.feats = new String[length + 1][];
            it.ofeats = new String[length + 1];
            it.pfeats = new String[length + 1];
            it.id = new String[length + 1];
            it.forms[0] = "<root>";
            it.plemmas[0] = "<root-LEMMA>";
            it.fillp[0] = "N";
            it.lemmas[0] = "<root-LEMMA>";
            it.gpos[0] = "<root-POS>";
            it.ppos[0] = "<root-POS>";
            it.labels[0] = "<no-type>";
            it.heads[0] = -1;
            it.plabels[0] = "<no-type>";
            it.pheads[0] = -1;
            it.ofeats[0] = "<no-type>";
            it.id[0] = "0";
            i = 1;
            while (i <= length) {
                String[] info = (String[])lineList.get(i - 1);
                it.id[i] = info[0];
                it.forms[i] = info[5];
                if (info.length >= 3) {
                    it.plemmas[i] = info[6];
                    it.gpos[i] = info[3];
                    if (info.length >= 5) {
                        it.ppos[i] = info[7];
                        it.ofeats[i] = "_";
                        it.pfeats[i] = "_";
                        it.heads[i] = info[8].equals("_") ? -1 : Integer.parseInt(info[8]);
                        it.pheads[i] = -1;
                        it.labels[i] = info[9];
                        it.plabels[i] = "_";
                        it.fillp[i] = info[10];
                        if (info.length > 11) {
                            if (!info[10].equals("_")) {
                                it.addPredicate(i, info[10]);
                            }
                            int k = 11;
                            while (k < info.length) {
                                it.addArgument(i, k - 11, info[k]);
                                ++k;
                            }
                        }
                    }
                }
                ++i;
            }
            return it;
        }
        catch (Exception e) {
            System.out.println("\n!!! Error in input file sentence before line: " + this.lineNumber + " (in sentence line " + i + " ) " + e.toString());
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public final SentenceData09 getNext(Instances is) {
        SentenceData09 it = this.getNext();
        if (is != null) {
            this.insert(is, it);
        }
        return it;
    }

    public final boolean insert(Instances is, SentenceData09 it) {
        block18: {
            if (it != null) break block18;
            this.inputReader.close();
            return false;
        }
        try {
            int i = is.createInstance09(it.length());
            int p = 0;
            while (p < it.length()) {
                is.setForm(i, p, this.normalize(it.forms[p]));
                is.setGPos(i, p, it.gpos[p]);
                if (it.ppos[p] == null || it.ppos[p].equals("_")) {
                    is.setPPoss(i, p, it.gpos[p]);
                } else {
                    is.setPPoss(i, p, it.ppos[p]);
                }
                if (it.plemmas[p] == null || it.plemmas[p].equals("_")) {
                    is.setLemma(i, p, this.normalize(it.forms[p]));
                } else {
                    is.setLemma(i, p, this.normalize(it.plemmas[p]));
                }
                if (it.lemmas != null) {
                    if (it.lemmas[p] == null) {
                        is.setGLemma(i, p, it.plemmas[p]);
                    } else {
                        is.setGLemma(i, p, it.lemmas[p]);
                    }
                }
                if (it.feats != null && it.feats[p] != null) {
                    is.setFeats(i, p, it.feats[p]);
                }
                if (it.ofeats != null) {
                    is.setFeature(i, p, it.ofeats[p]);
                }
                is.setRel(i, p, it.labels[p]);
                if (it.plabels != null) {
                    is.setPRel(i, p, it.plabels[p]);
                }
                is.setHead(i, p, it.heads[p]);
                if (it.pheads != null) {
                    is.setPHead(i, p, it.pheads[p]);
                }
                if (it.fillp != null && it.fillp[p] != null && it.fillp[p].startsWith("Y")) {
                    is.pfill[i].set(p);
                } else {
                    is.pfill[i].clear(p);
                }
                ++p;
            }
            if (is.createSem(i, it)) {
                DB.println("count " + i + " len " + it.length());
                DB.println(it.printSem());
            }
        }
        catch (Exception e) {
            DB.println("head " + it);
            e.printStackTrace();
        }
        return true;
    }

    public String normalize(String s) {
        if (!this.normalizeOn) {
            return s;
        }
        if (s.matches("[0-9]+|[0-9]+\\.[0-9]+|[0-9]+[0-9,]+")) {
            return "<num>";
        }
        return s;
    }
}

