/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import is2.data.IEncoderPlus;
import is2.util.DB;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class Thesaurus {
    public static final String LPATH = "LP";
    public static final String SPATH = "SP";
    private final int[][] word2path;

    public Thesaurus() {
        this.word2path = new int[0][];
    }

    public Thesaurus(String clusterFile, IEncoderPlus mf, int ls) {
        String REGEX = "\t";
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            int cnt = 0;
            while ((line = inputReader.readLine()) != null) {
                ++cnt;
                try {
                    String[] split = line.split("\t");
                    mf.register("WORD", split[0]);
                    mf.register("WORD", split[1]);
                }
                catch (Exception e) {
                    System.out.println("Error in cluster line " + cnt + " error: " + e.getMessage());
                }
            }
            System.out.println("read number of thesaury entries " + cnt);
            inputReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.word2path = new int[mf.getFeatureCounter().get("WORD").intValue()][];
        try {
            String line;
            BufferedReader inputReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(clusterFile), "UTF-8"), 32768);
            int startWd = -1;
            ArrayList<Integer> wrds = new ArrayList<Integer>();
            while ((line = inputReader.readLine()) != null) {
                String[] split = line.split("\t");
                int wd = mf.getValue("WORD", split[0]);
                if (startWd == wd) {
                    int thesaurusWrd = mf.getValue("WORD", split[1]);
                    if (thesaurusWrd != wd) {
                        wrds.add(thesaurusWrd);
                    }
                } else if (startWd != -1) {
                    int[] ths = new int[wrds.size()];
                    int k = 0;
                    while (k < ths.length) {
                        ths[k] = (Integer)wrds.get(k);
                        ++k;
                    }
                    this.word2path[startWd] = ths;
                    wrds.clear();
                    int thesaurusWrd = mf.getValue("WORD", split[1]);
                    if (thesaurusWrd != wd) {
                        wrds.add(thesaurusWrd);
                    }
                }
                startWd = wd;
            }
            if (wrds.size() != 0) {
                int[] ths = new int[wrds.size()];
                int k = 0;
                while (k < ths.length) {
                    ths[k] = (Integer)wrds.get(k);
                    ++k;
                }
                this.word2path[startWd] = ths;
                wrds.clear();
            }
            inputReader.close();
            int fill = 0;
            int l = 0;
            while (l < this.word2path.length) {
                if (this.word2path[l] != null) {
                    ++fill;
                }
                ++l;
            }
            System.out.println("filled " + fill + " of " + this.word2path.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Thesaurus(DataInputStream dis) throws IOException {
        this.word2path = new int[dis.readInt()][];
        int i = 0;
        while (i < this.word2path.length) {
            int len = dis.readInt();
            if (len > 0) {
                this.word2path[i] = new int[len];
                int j = 0;
                while (j < len) {
                    this.word2path[i][j] = dis.readInt();
                    ++j;
                }
            }
            this.word2path[i][0] = dis.readShort();
            ++i;
        }
        DB.println("Read cluster with " + this.word2path.length + " words ");
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.word2path.length);
        int[][] nArray = this.word2path;
        int n = this.word2path.length;
        int n2 = 0;
        while (n2 < n) {
            int[] i = nArray[n2];
            dos.writeInt(i == null ? 0 : i.length);
            if (i != null) {
                int j = 0;
                while (j < i.length) {
                    dos.writeInt(i[j]);
                    ++j;
                }
            }
            ++n2;
        }
    }

    public final int get(int form, int k) {
        if (this.word2path.length < form || this.word2path[form] == null) {
            return -1;
        }
        return this.word2path[form][k];
    }
}

