/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import is2.io.CONLLWriter09;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.util.ArrayList;

public class SentenceData09 {
    public String[] id;
    public String[] forms;
    public String[] lemmas;
    public String[] plemmas;
    public int[] heads;
    public int[] pheads;
    public String[] labels;
    public String[] plabels;
    public String[] gpos;
    public String[] ppos;
    public String[][] feats;
    public String[] sem;
    public int[] semposition;
    public String[][] arg;
    public int[][] argposition;
    public String[] fillp;
    public String[] ofeats;
    public String[] pfeats;

    public SentenceData09() {
    }

    public SentenceData09(String[] forms, String[] postags, String[] labs, int[] heads) {
        this.forms = forms;
        this.gpos = postags;
        this.labels = labs;
        this.heads = heads;
    }

    public SentenceData09(String[] forms, String[] lemmas, String[] postags, String[] labs, int[] heads) {
        this.forms = forms;
        this.gpos = postags;
        this.labels = labs;
        this.heads = heads;
        this.plemmas = lemmas;
    }

    public SentenceData09(String[] forms, String[] lemmas, String[] gpos, String[] ppos, String[] labs, int[] heads) {
        this.forms = forms;
        this.gpos = gpos;
        this.ppos = ppos;
        this.labels = labs;
        this.heads = heads;
        this.plemmas = lemmas;
    }

    public SentenceData09(String[] forms, String[] lemmas, String[] gpos, String[] ppos, String[] labs, int[] heads, String[] fillpred) {
        this.forms = forms;
        this.gpos = gpos;
        this.ppos = ppos;
        this.labels = labs;
        this.heads = heads;
        this.plemmas = lemmas;
        this.fillp = fillpred;
    }

    public SentenceData09(String[] forms, String[] lemmas, String[] olemmas, String[] gpos, String[] ppos, String[] labs, int[] heads, String[] fillpred) {
        this.forms = forms;
        this.gpos = gpos;
        this.ppos = ppos;
        this.labels = labs;
        this.heads = heads;
        this.plemmas = lemmas;
        this.lemmas = olemmas;
        this.fillp = fillpred;
    }

    public SentenceData09(String[] forms, String[] olemmas, String[] lemmas, String[] gpos, String[] ppos, String[] labs, int[] heads, String[] fillpred, String[] of, String[] pf) {
        this.forms = forms;
        this.gpos = gpos;
        this.ppos = ppos;
        this.labels = labs;
        this.heads = heads;
        this.pheads = heads;
        this.plabels = labs;
        this.plemmas = lemmas;
        this.lemmas = olemmas;
        this.ofeats = of;
        this.pfeats = pf;
        this.fillp = fillpred;
    }

    public SentenceData09(SentenceData09 i) {
        int length = i.length() - 1;
        this.forms = new String[length];
        this.gpos = new String[length];
        this.ppos = new String[length];
        this.plemmas = new String[length];
        this.plabels = new String[length];
        this.lemmas = new String[length];
        this.heads = new int[length];
        this.pheads = new int[length];
        this.ofeats = new String[length];
        this.pfeats = new String[length];
        this.labels = new String[length];
        this.fillp = new String[length];
        this.id = new String[length];
        int j = 0;
        while (j < length) {
            this.forms[j] = i.forms[j + 1];
            this.ppos[j] = i.ppos[j + 1];
            this.gpos[j] = i.gpos[j + 1];
            this.labels[j] = i.labels[j + 1];
            this.heads[j] = i.heads[j + 1];
            if (i.pheads != null) {
                this.pheads[j] = i.pheads[j + 1];
            }
            if (i.plabels != null) {
                this.plabels[j] = i.plabels[j + 1];
            }
            if (i.lemmas != null) {
                this.lemmas[j] = i.lemmas[j + 1];
            }
            this.plemmas[j] = i.plemmas[j + 1];
            if (i.ofeats != null) {
                this.ofeats[j] = i.ofeats[j + 1];
            }
            if (i.pfeats != null) {
                this.pfeats[j] = i.pfeats[j + 1];
            }
            if (i.fillp != null) {
                this.fillp[j] = i.fillp[j + 1];
            }
            if (i.id != null) {
                this.id[j] = i.id[j + 1];
            }
            ++j;
        }
    }

    public void setPPos(String[] pos) {
        this.ppos = pos;
    }

    public void setLemmas(String[] lemmas) {
        this.plemmas = lemmas;
    }

    public void setFeats(String[] fts) {
        this.feats = new String[fts.length][];
        int i = 0;
        while (i < fts.length) {
            this.feats[i] = fts[i].split("\\|");
            ++i;
        }
        this.pfeats = fts;
    }

    public int length() {
        return this.forms.length;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        sw = new StringWriter();
        snt2str = new CONLLWriter09(sw);
        try {
            snt2str.write(this, true);
            snt2str.finishWriting();
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            sb = new StringBuffer();
            k = 0;
            ** while (k < this.forms.length)
        }
lbl-1000:
        // 1 sources

        {
            sb.append(k + 1).append('\t').append(this.forms[k]).append('\t').append(this.heads[k]).append('\t').append(this.labels[k]).append('\n');
            ++k;
            continue;
        }
lbl16:
        // 1 sources

        return sw.toString();
    }

    public final void write(DataOutputStream out) throws IOException {
        out.writeInt(this.forms.length);
        int k = 0;
        while (k < this.forms.length) {
            out.writeUTF(this.forms[k]);
            out.writeUTF(this.ppos[k]);
            out.writeUTF(this.gpos[k]);
            out.writeInt(this.heads[k]);
            out.writeUTF(this.labels[k]);
            out.writeUTF(this.lemmas[k]);
            out.writeUTF(this.plemmas[k]);
            out.writeUTF(this.ofeats[k]);
            out.writeUTF(this.fillp[k]);
            ++k;
        }
    }

    public final void read(DataInputStream dis) throws IOException {
        int l = dis.readInt();
        this.forms = new String[l];
        this.lemmas = new String[l];
        this.plemmas = new String[l];
        this.ppos = new String[l];
        this.gpos = new String[l];
        this.labels = new String[l];
        this.heads = new int[l];
        this.fillp = new String[l];
        this.ofeats = new String[l];
        int k = 0;
        while (k < l) {
            this.forms[k] = dis.readUTF();
            this.ppos[k] = dis.readUTF();
            this.gpos[k] = dis.readUTF();
            this.heads[k] = dis.readInt();
            this.labels[k] = dis.readUTF();
            this.lemmas[k] = dis.readUTF();
            this.plemmas[k] = dis.readUTF();
            this.ofeats[k] = dis.readUTF();
            this.fillp[k] = dis.readUTF();
            ++k;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.forms = (String[])in.readObject();
        this.plemmas = (String[])in.readObject();
        this.ppos = (String[])in.readObject();
        this.heads = (int[])in.readObject();
        this.labels = (String[])in.readObject();
    }

    public void addPredicate(int i, String s) {
        int predId;
        if (this.sem == null) {
            predId = 0;
            this.sem = new String[1];
            this.semposition = new int[1];
        } else {
            predId = this.sem.length;
            String[] p = new String[this.sem.length + 1];
            System.arraycopy(this.sem, 0, p, 0, this.sem.length);
            int[] id = new int[this.sem.length + 1];
            System.arraycopy(this.semposition, 0, id, 0, this.semposition.length);
            this.sem = p;
            this.semposition = id;
        }
        this.sem[predId] = s;
        this.semposition[predId] = i;
    }

    public void addArgument(int i, int predId, String a) {
        int aId;
        if (a == null || a.equals("_")) {
            return;
        }
        if (this.arg == null) {
            this.arg = new String[predId + 1][];
            this.argposition = new int[predId + 1][];
        } else if (this.arg.length <= predId) {
            String[][] p = new String[predId + 1][];
            System.arraycopy(this.arg, 0, p, 0, this.arg.length);
            this.arg = p;
            int[][] id = new int[predId + 1][];
            System.arraycopy(this.argposition, 0, id, 0, this.argposition.length);
            this.argposition = id;
        }
        if (this.arg[predId] == null) {
            aId = 0;
            this.arg[predId] = new String[1];
            this.argposition[predId] = new int[1];
        } else {
            aId = this.arg[predId].length;
            String[] args = new String[this.arg[predId].length + 1];
            System.arraycopy(this.arg[predId], 0, args, 0, this.arg[predId].length);
            this.arg[predId] = args;
            int[] argsId = new int[this.argposition[predId].length + 1];
            System.arraycopy(this.argposition[predId], 0, argsId, 0, this.argposition[predId].length);
            this.argposition[predId] = argsId;
        }
        this.arg[predId][aId] = a;
        this.argposition[predId][aId] = i;
    }

    public int[] getParents() {
        return this.heads;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public String printSem() {
        if (this.sem == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int k = 0;
        while (k < this.sem.length) {
            s.append(this.sem[k]).append("\n");
            if (this.arg == null) {
                s.append("arg == null");
            } else if (this.arg.length <= k) {
                s.append("args.length <=k arg.length:" + this.arg.length + " k:" + k);
            } else if (this.arg[k] != null) {
                int a = 0;
                while (a < this.arg[k].length) {
                    s.append("  ").append(this.arg[k][a]);
                    ++a;
                }
            } else {
                s.append("args == null ");
            }
            s.append('\n');
            ++k;
        }
        return s.toString();
    }

    public void init(String[] forms) {
        this.forms = forms;
        this.heads = new int[forms.length];
        this.gpos = new String[forms.length];
        this.ppos = new String[forms.length];
        this.plemmas = new String[forms.length];
        this.feats = new String[forms.length][0];
        this.labels = new String[forms.length];
    }

    public void createSemantic(SentenceData09 instance) {
        this.sem = instance.sem;
        this.semposition = instance.semposition;
        if (instance.semposition != null) {
            int k = 0;
            while (k < instance.semposition.length) {
                this.semposition[k] = instance.semposition[k] - 1;
                ++k;
            }
        }
        this.arg = instance.arg;
        this.argposition = instance.argposition;
        if (this.argposition != null) {
            int p = 0;
            while (p < instance.argposition.length) {
                if (this.argposition[p] != null) {
                    int a = 0;
                    while (a < instance.argposition[p].length) {
                        this.argposition[p][a] = instance.argposition[p][a] - 1;
                        ++a;
                    }
                }
                ++p;
            }
        }
    }

    public String oneLine() {
        StringBuffer o = new StringBuffer();
        int i = 1;
        while (i < this.length()) {
            if (i != 1) {
                o.append(" ");
            }
            o.append(this.forms[i]);
            ++i;
        }
        return o.toString();
    }

    public ArrayList<Integer> getChildren(int head) {
        ArrayList<Integer> children = new ArrayList<Integer>();
        int i = 0;
        while (i < this.length()) {
            if (this.heads[i] == head) {
                children.add(i);
            }
            ++i;
        }
        return children;
    }
}

