/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import is2.data.IEncoderPlus;
import is2.util.DB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class MFC
implements IEncoderPlus {
    private final HashMap<String, HashMap<String, Integer>> m_featureSets = new HashMap();
    private final HashMap<String, Integer> m_featureCounters = new HashMap();
    final HashMap<String, Integer> m_featureBits = new HashMap();
    private int count = 0;
    public static int misses = 0;
    public static int good = 0;

    public int size() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int register(String a, String v) {
        HashMap<String, Integer> hashMap = this.m_featureCounters;
        synchronized (hashMap) {
            Integer i;
            HashMap<String, Integer> fs = this.getFeatureSet().get(a);
            if (fs == null) {
                fs = new HashMap();
                this.getFeatureSet().put(a, fs);
                fs.put("<None>", 0);
                this.getFeatureCounter().put(a, 1);
            }
            if ((i = fs.get(v)) == null) {
                Integer c = this.getFeatureCounter().get(a);
                fs.put(v, c);
                c = c + 1;
                this.getFeatureCounter().put(a, c);
                return c - 1;
            }
            return i;
        }
    }

    public void calculateBits() {
        int total = 0;
        for (Map.Entry<String, Integer> e : this.getFeatureCounter().entrySet()) {
            int bits = (int)Math.ceil(Math.log(e.getValue() + 1) / Math.log(2.0));
            this.m_featureBits.put(e.getKey(), bits);
            total += bits;
        }
    }

    public String toString() {
        StringBuffer content = new StringBuffer();
        for (Map.Entry<String, Integer> e : this.getFeatureCounter().entrySet()) {
            content.append(String.valueOf(e.getKey()) + " " + e.getValue());
            content.append(':');
            content.append(this.getFeatureBits(e.getKey()));
            content.append('\n');
        }
        return content.toString();
    }

    public final short getFeatureBits(String a) {
        if (this.m_featureBits.get(a) == null) {
            return 0;
        }
        return (short)this.m_featureBits.get(a).intValue();
    }

    @Override
    public final int getValue(String t, String v) {
        if (this.m_featureSets.get(t) == null) {
            return -1;
        }
        Integer vi = this.m_featureSets.get(t).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public final int getValueS(String a, String v) {
        if (this.m_featureSets.get(a) == null) {
            return -1;
        }
        Integer vi = this.m_featureSets.get(a).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public int hasValue(String a, String v) {
        Integer vi = this.m_featureSets.get(a).get(v);
        if (vi == null) {
            return -1;
        }
        return vi;
    }

    public static String printBits(int k) {
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < 31) {
            s.append((k & 1) == 1 ? (char)'1' : '0');
            k >>= 1;
            ++i;
        }
        s.reverse();
        return s.toString();
    }

    public void writeData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.getFeatureSet().size());
        for (Map.Entry<String, HashMap<String, Integer>> e : this.getFeatureSet().entrySet()) {
            dos.writeUTF(e.getKey());
            dos.writeInt(e.getValue().size());
            for (Map.Entry<String, Integer> e2 : e.getValue().entrySet()) {
                if (e2.getKey() == null) {
                    DB.println("key " + e2.getKey() + " value " + e2.getValue() + " e -key " + e.getKey());
                }
                dos.writeUTF(e2.getKey());
                dos.writeInt(e2.getValue());
            }
        }
    }

    public void read(DataInputStream din) throws IOException {
        int size = din.readInt();
        int i = 0;
        while (i < size) {
            String k = din.readUTF();
            int size2 = din.readInt();
            HashMap<String, Integer> h = new HashMap<String, Integer>();
            this.getFeatureSet().put(k, h);
            int j = 0;
            while (j < size2) {
                h.put(din.readUTF(), din.readInt());
                ++j;
            }
            this.getFeatureCounter().put(k, size2);
            ++i;
        }
        this.count = size;
        this.calculateBits();
    }

    public void clearData() {
        this.getFeatureSet().clear();
        this.m_featureBits.clear();
        this.getFeatureSet().clear();
    }

    @Override
    public HashMap<String, Integer> getFeatureCounter() {
        return this.m_featureCounters;
    }

    public HashMap<String, HashMap<String, Integer>> getFeatureSet() {
        return this.m_featureSets;
    }

    public String[] reverse(HashMap<String, Integer> v) {
        String[] set = new String[v.size()];
        for (Map.Entry<String, Integer> e : v.entrySet()) {
            set[e.getValue().intValue()] = e.getKey();
        }
        return set;
    }
}

