/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import is2.data.PrimeFinder;
import java.util.Arrays;

public final class IntIntHash {
    protected int _size;
    protected int _free;
    protected float _loadFactor;
    public int _maxSize;
    protected int _autoCompactRemovesRemaining;
    protected float _autoCompactionFactor;
    public int[] _set;
    private int[] _values;
    int index = 0;

    public IntIntHash() {
        this(102877, 0.5f);
    }

    public IntIntHash(int initialCapacity, float loadFactor) {
        this._loadFactor = loadFactor;
        this._autoCompactionFactor = loadFactor;
        this.setUp((int)Math.ceil((float)initialCapacity / loadFactor));
    }

    public int size() {
        return this._size;
    }

    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)(desiredCapacity + this.size()) / this._loadFactor) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this._loadFactor) + 1));
        this.computeMaxSize(this.capacity());
        if (this._autoCompactionFactor != 0.0f) {
            this.computeNextAutoCompactionAmount(this.size());
        }
    }

    public void setAutoCompactionFactor(float factor) {
        if (factor < 0.0f) {
            throw new IllegalArgumentException("Factor must be >= 0: " + factor);
        }
        this._autoCompactionFactor = factor;
    }

    public float getAutoCompactionFactor() {
        return this._autoCompactionFactor;
    }

    private void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)Math.floor((float)capacity * this._loadFactor));
        this._free = capacity - this._size;
    }

    private void computeNextAutoCompactionAmount(int size) {
        if (this._autoCompactionFactor != 0.0f) {
            this._autoCompactRemovesRemaining = Math.round((float)size * this._autoCompactionFactor);
        }
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int newCapacity = this._size <= this._maxSize ? this.capacity() : PrimeFinder.nextPrime(this.capacity() << 1);
            this.rehash(newCapacity);
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }

    protected int capacity() {
        return this._values.length;
    }

    public boolean contains(int val) {
        return this.index(val) >= 0;
    }

    private int index(int v) {
        int length = this._set.length;
        int index = Math.abs(this.computeHashCode(v) % length);
        long l;
        while ((l = (long)this._set[index]) != 0L) {
            if (l == (long)v) {
                return index;
            }
            if (--index >= 0) continue;
            index += length;
        }
        return -1;
    }

    protected int insertionIndex(long val) {
        int length = this._set.length;
        int index = Math.abs(this.computeHashCode(val) % length);
        while (this._set[index] != 0) {
            if ((long)this._set[index] == val) {
                return -index - 1;
            }
            if (--index >= 0) continue;
            index += length;
        }
        return index;
    }

    public int computeHashCode(long value) {
        return (int)((value ^ (value & 0xFFFFFFFF00000000L) >>> 32) * 31L);
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        this.computeNextAutoCompactionAmount(initialCapacity);
        this._set = new int[capacity];
        this._values = new int[capacity];
        return capacity;
    }

    public void put(int key, int value) {
        int index = this.insertionIndex(key);
        this.doPut(key, value, index);
    }

    private void doPut(int key, int value, int index) {
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            isNewMapping = false;
        }
        this._set[index] = key;
        this._values[index] = value;
        if (isNewMapping) {
            this.postInsertHook(true);
        }
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        int[] oldVals = this._values;
        this._set = new int[newCapacity];
        this._values = new int[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldVals[i] == 0) continue;
            int o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public int get(int key) {
        int index = this.index(key);
        return index >= 0 ? this._values[index] : 0;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
        Arrays.fill(this._set, 0, this._set.length, 0);
    }

    public int remove(int key) {
        int prev = 0;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this._values[index] = 0;
            this._set[index] = 0;
            --this._size;
            if (this._autoCompactionFactor != 0.0f) {
                --this._autoCompactRemovesRemaining;
                if (this._autoCompactRemovesRemaining <= 0) {
                    this.compact();
                }
            }
        }
        return prev;
    }

    public int[] getValues() {
        int[] vals = new int[this.size()];
        int[] v = this._values;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (v[i] == 0) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (k[i] == 0) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean adjustValue(int key, int i) {
        int index = this.index(key);
        if (index >= 0) {
            int n = index;
            this._values[n] = this._values[n] + i;
            return true;
        }
        return false;
    }
}

