/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import is2.data.IEncoder;
import is2.data.SentenceData09;
import java.util.BitSet;

public class Instances {
    public IEncoder m_encoder;
    protected int size = 0;
    protected int capacity;
    public int[][] forms;
    public int[][] plemmas;
    public int[][] glemmas;
    public short[][] heads;
    public short[][] pheads;
    public short[][] labels;
    public short[][] plabels;
    public short[][] gpos;
    public short[][] pposs;
    public short[][][] feats;
    public int[][] predicat;
    public short[][] predicateId;
    public short[][] semposition;
    public short[][][] arg;
    public short[][][] argposition;
    public BitSet[] pfill;
    public short[][] gfeats;
    public short[][] pfeats;
    public static int m_unkown = 0;
    public static int m_count = 0;
    public static boolean m_report;
    public static boolean m_found;

    static {
        m_found = false;
    }

    public final void setForm(int i, int p, String x) {
        this.forms[i][p] = this.m_encoder.getValue("WORD", x);
        if (this.forms[i][p] == -1) {
            if (m_report) {
                System.out.println("unkwrd " + x);
            }
            ++m_unkown;
            m_found = true;
        }
        ++m_count;
    }

    public final void setRel(int i, int p, String x) {
        this.labels[i][p] = (short)this.m_encoder.getValue("REL", x);
    }

    public final void setHead(int i, int c, int p) {
        this.heads[i][c] = (short)p;
    }

    public final int size() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    public void init(int ic, IEncoder mf) {
        this.init(ic, mf, -1);
    }

    public void init(int ic, IEncoder mf, int version) {
        this.capacity = ic;
        this.m_encoder = mf;
        this.forms = new int[this.capacity][];
        this.plemmas = new int[this.capacity][];
        this.glemmas = new int[this.capacity][];
        this.pposs = new short[this.capacity][];
        this.gpos = new short[this.capacity][];
        this.labels = new short[this.capacity][];
        this.heads = new short[this.capacity][];
        this.plabels = new short[this.capacity][];
        this.pheads = new short[this.capacity][];
        this.feats = new short[this.capacity][][];
        this.gfeats = new short[this.capacity][];
        this.pfeats = new short[this.capacity][];
        this.predicat = new int[ic][];
        this.predicateId = new short[ic][];
        this.semposition = new short[ic][];
        this.arg = new short[ic][][];
        this.argposition = new short[ic][][];
        this.pfill = new BitSet[ic];
    }

    public int length(int i) {
        return this.forms[i].length;
    }

    public int createInstance09(int length) {
        this.forms[this.size] = new int[length];
        this.plemmas[this.size] = new int[length];
        this.glemmas[this.size] = new int[length];
        this.pposs[this.size] = new short[length];
        this.gpos[this.size] = new short[length];
        this.labels[this.size] = new short[length];
        this.heads[this.size] = new short[length];
        this.pfill[this.size] = new BitSet(length);
        this.feats[this.size] = new short[length][];
        this.gfeats[this.size] = new short[length];
        this.pfeats[this.size] = new short[length];
        this.plabels[this.size] = new short[length];
        this.pheads[this.size] = new short[length];
        ++this.size;
        return this.size - 1;
    }

    public final void setPPoss(int i, int p, String x) {
        this.pposs[i][p] = (short)this.m_encoder.getValue("POS", x);
    }

    public final void setGPos(int i, int p, String x) {
        this.gpos[i][p] = (short)this.m_encoder.getValue("POS", x);
    }

    public void setLemma(int i, int p, String x) {
        this.plemmas[i][p] = this.m_encoder.getValue("WORD", x);
    }

    public void setGLemma(int i, int p, String x) {
        this.glemmas[i][p] = this.m_encoder.getValue("WORD", x);
    }

    public void setFeats(int i, int p, String[] fts) {
        if (fts == null) {
            this.feats[i][p] = null;
            return;
        }
        this.feats[i][p] = new short[fts.length];
        int k = 0;
        while (k < fts.length) {
            this.feats[i][p][k] = (short)this.m_encoder.getValue("F", fts[k]);
            ++k;
        }
    }

    public void setFeature(int i, int p, String feature) {
        if (feature == null) {
            return;
        }
        this.gfeats[i][p] = (short)this.m_encoder.getValue("F", feature);
    }

    public void setPFeature(int i, int p, String feature) {
        if (feature == null) {
            return;
        }
        this.pfeats[i][p] = (short)this.m_encoder.getValue("F", feature);
    }

    public int getWValue(String v) {
        return this.m_encoder.getValue("WORD", v);
    }

    public final void setPRel(int i, int p, String x) {
        this.plabels[i][p] = (short)this.m_encoder.getValue("REL", x);
    }

    public final void setPHead(int i, int c, int p) {
        this.pheads[i][c] = (short)p;
    }

    public boolean createSem(int inst, SentenceData09 it) {
        boolean error = false;
        if (it.sem == null) {
            return error;
        }
        this.predicat[inst] = new int[it.sem.length];
        this.semposition[inst] = new short[it.sem.length];
        this.predicateId[inst] = new short[it.sem.length];
        if (it.sem != null) {
            this.arg[inst] = new short[it.sem.length][];
            this.argposition[inst] = new short[it.sem.length][];
        }
        if (it.sem == null) {
            return error;
        }
        int i = 0;
        while (i < it.sem.length) {
            String pred;
            short predSense = 0;
            if (it.sem[i].indexOf(46) > 0) {
                pred = it.sem[i].substring(0, it.sem[i].indexOf(46));
                predSense = (short)this.m_encoder.getValue("SENSE", it.sem[i].substring(it.sem[i].indexOf(46) + 1, it.sem[i].length()));
            } else {
                pred = it.sem[i];
                predSense = (short)this.m_encoder.getValue("SENSE", "");
            }
            this.predicat[inst][i] = this.m_encoder.getValue("PRED", pred);
            this.predicateId[inst][i] = predSense;
            this.semposition[inst][i] = (short)it.semposition[i];
            if (it.arg != null && it.arg.length > i && it.arg[i] != null) {
                int argCount = it.arg[i].length;
                this.arg[inst][i] = new short[it.arg[i].length];
                this.argposition[inst][i] = new short[it.arg[i].length];
                int a = 0;
                while (a < argCount) {
                    this.arg[inst][i][a] = (short)this.m_encoder.getValue("ARG", it.arg[i][a]);
                    this.argposition[inst][i][a] = (short)it.argposition[i][a];
                    ++a;
                }
            }
            ++i;
        }
        return error;
    }

    public int predCount(int n) {
        return this.pfill[n].cardinality();
    }

    public String print(int pscnt) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.length(pscnt)) {
            s.append(String.valueOf(i) + "\t" + this.forms[pscnt][i] + "\t" + this.glemmas[pscnt][i] + "\t" + this.plemmas[pscnt][i] + "\t" + this.gpos[pscnt][i] + "\t" + this.pposs[pscnt][i] + "\t" + this.gfeats[pscnt][i] + "\t" + (this.feats[pscnt][i] != null && this.feats[pscnt][i].length > 0 ? Short.valueOf(this.feats[pscnt][i][0]) : null) + "\t l " + (this.labels[pscnt] != null && this.labels[pscnt].length > i ? Short.valueOf(this.labels[pscnt][i]) : null) + "\t" + "\t" + this.heads[pscnt][i] + "\t" + (this.plabels[pscnt] != null && this.plabels[pscnt].length > i ? Short.valueOf(this.plabels[pscnt][i]) : null) + "\t" + this.predicat[pscnt][i] + "\n");
            ++i;
        }
        return s.toString();
    }

    public String print1(int pscnt) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < this.length(pscnt)) {
            s.append(String.valueOf(i) + "\t" + this.forms[pscnt][i] + "\t" + "\t" + this.plemmas[pscnt][i] + "\t" + this.pposs[pscnt][i] + "\t l " + (this.labels[pscnt] != null && this.labels[pscnt].length > i ? Short.valueOf(this.labels[pscnt][i]) : null) + "\t" + "\t" + this.heads[pscnt][i] + "\t" + (this.plabels[pscnt] != null && this.plabels[pscnt].length > i ? Short.valueOf(this.plabels[pscnt][i]) : null) + "\n");
            ++i;
        }
        return s.toString();
    }
}

