/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

import gnu.trove.TIntDoubleHashMap;
import is2.data.IFV;
import is2.data.IntIntHash;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FVR
extends IFV {
    private FVR subfv1;
    private FVR subfv2;
    private boolean negateSecondSubFV = false;
    private int size;
    private int[] m_index;
    private float[] m_value;
    private static TIntDoubleHashMap hd1;
    private static TIntDoubleHashMap hd2;

    public FVR() {
        this(10);
    }

    public FVR(int initialCapacity) {
        this.m_index = new int[initialCapacity];
        this.m_value = new float[initialCapacity];
    }

    public FVR(FVR fv1, FVR fv2, boolean negSecond) {
        this(0);
        this.subfv1 = fv1;
        this.subfv2 = fv2;
        this.negateSecondSubFV = negSecond;
    }

    public FVR(DataInputStream dos, int capacity) throws IOException {
        this(capacity);
        this.size = this.m_index.length;
        int i = 0;
        while (i < this.size) {
            this.m_index[i] = dos.readInt();
            ++i;
        }
    }

    public FVR(DataInputStream dos) throws IOException {
        this(dos.readInt());
        this.size = this.m_index.length;
        int i = 0;
        while (i < this.size) {
            this.m_index[i] = dos.readInt();
            ++i;
        }
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.m_index.length) {
            int[] oldIndex = this.m_index;
            float[] oldValue = this.m_value;
            int newCapacity = this.m_index.length * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.m_index = new int[newCapacity];
            this.m_value = new float[newCapacity];
            System.arraycopy(oldIndex, 0, this.m_index, 0, oldIndex.length);
            System.arraycopy(oldValue, 0, this.m_value, 0, oldValue.length);
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final void clear() {
        this.size = 0;
    }

    public final int createFeature(int i, float v) {
        this.ensureCapacity(this.size + 1);
        this.m_index[this.size] = i;
        this.m_value[this.size] = v;
        ++this.size;
        return this.size - 1;
    }

    public final int getIndex(int i) {
        return this.m_index[i];
    }

    public void setIndex(int p, int i) {
        this.m_index[p] = i;
    }

    public void trimToSize() {
        if (this.size < this.m_index.length) {
            int[] oldIndex = this.m_index;
            this.m_index = new int[this.size];
            System.arraycopy(oldIndex, 0, this.m_index, 0, this.size);
        }
    }

    @Override
    public final void add(int i) {
        if (i >= 0) {
            this.ensureCapacity(this.size + 1);
            this.m_index[this.size] = i;
            this.m_value[this.size] = 1.0f;
            ++this.size;
        }
    }

    public final void add(int i, float f) {
        if (i >= 0) {
            this.createFeature(i, f);
        }
    }

    public FVR getDistVector(FVR fl2) {
        return new FVR(this, fl2, true);
    }

    public double getScore(double[] parameters, boolean negate) {
        double score = 0.0;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score -= parameters[this.m_index[i]];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score += parameters[this.m_index[i]];
                ++i;
            }
        }
        return score;
    }

    public final float getScore(float[] parameters, boolean negate) {
        float score = 0.0f;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score -= parameters[this.m_index[i]] * this.m_value[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score += parameters[this.m_index[i]] * this.m_value[i];
                ++i;
            }
        }
        return score;
    }

    public final int getScore(short[] parameters, boolean negate) {
        int score = 0;
        if (this.subfv1 != null) {
            score += this.subfv1.getScore(parameters, negate);
            if (this.subfv2 != null) {
                score = negate ? (score += this.subfv2.getScore(parameters, !this.negateSecondSubFV)) : (score += this.subfv2.getScore(parameters, this.negateSecondSubFV));
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                score = (int)((float)score - (float)parameters[this.m_index[i]] * this.m_value[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                score = (int)((float)score + (float)parameters[this.m_index[i]] * this.m_value[i]);
                ++i;
            }
        }
        return score;
    }

    public final void update(float[] parameters, float[] total, double alpha_k, double upd, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.update(parameters, total, alpha_k, upd, negate);
            if (this.subfv2 != null && negate) {
                this.subfv2.update(parameters, total, alpha_k, upd, !this.negateSecondSubFV);
            } else {
                this.subfv2.update(parameters, total, alpha_k, upd, this.negateSecondSubFV);
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] - alpha_k * (double)this.m_value[i]);
                int n2 = this.getIndex(i);
                total[n2] = (float)((double)total[n2] - upd * alpha_k * (double)this.m_value[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                int n = this.getIndex(i);
                parameters[n] = (float)((double)parameters[n] + alpha_k * (double)this.m_value[i]);
                int n3 = this.getIndex(i);
                total[n3] = (float)((double)total[n3] + upd * alpha_k * (double)this.m_value[i]);
                ++i;
            }
        }
    }

    public int dotProduct(FVR fl2) {
        if (hd1 == null) {
            hd1 = new TIntDoubleHashMap(this.size(), 0.4f);
        } else {
            hd1.clear();
        }
        this.addFeaturesToMap(hd1);
        if (hd2 == null) {
            hd2 = new TIntDoubleHashMap(fl2.size, 0.4f);
        } else {
            hd2.clear();
        }
        fl2.addFeaturesToMap(hd2);
        int[] keys = hd1.keys();
        int result = 0;
        int i = 0;
        while (i < keys.length) {
            result = (int)((double)result + hd1.get(keys[i]) * hd2.get(keys[i]));
            ++i;
        }
        return result;
    }

    private void addFeaturesToMap(TIntDoubleHashMap map) {
        if (this.subfv1 != null) {
            this.subfv1.addFeaturesToMap(map);
            if (this.subfv2 != null) {
                this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
            }
        }
        int i = 0;
        while (i < this.size) {
            if (!map.adjustValue(this.getIndex(i), (double)this.m_value[i])) {
                map.put(this.getIndex(i), (double)this.m_value[i]);
            }
            ++i;
        }
    }

    private void addFeaturesToMap(IntIntHash map, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.addFeaturesToMap(map, negate);
            if (this.subfv2 != null) {
                if (negate) {
                    this.subfv2.addFeaturesToMap(map, !this.negateSecondSubFV);
                } else {
                    this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
                }
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), -1)) {
                    map.put(this.getIndex(i), -1);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), 1)) {
                    map.put(this.getIndex(i), 1);
                }
                ++i;
            }
        }
    }

    private void addFeaturesToMap(TIntDoubleHashMap map, boolean negate) {
        if (this.subfv1 != null) {
            this.subfv1.addFeaturesToMap(map, negate);
            if (this.subfv2 != null) {
                if (negate) {
                    this.subfv2.addFeaturesToMap(map, !this.negateSecondSubFV);
                } else {
                    this.subfv2.addFeaturesToMap(map, this.negateSecondSubFV);
                }
            }
        }
        if (negate) {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), (double)(-this.m_value[i]))) {
                    map.put(this.getIndex(i), (double)(-this.m_value[i]));
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (!map.adjustValue(this.getIndex(i), (double)this.m_value[i])) {
                    map.put(this.getIndex(i), (double)this.m_value[i]);
                }
                ++i;
            }
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    private final void toString(StringBuilder sb) {
        if (this.subfv1 != null) {
            this.subfv1.toString(sb);
            if (this.subfv2 != null) {
                this.subfv2.toString(sb);
            }
        }
        int i = 0;
        while (i < this.size) {
            sb.append(this.getIndex(i)).append('=').append(this.m_value[i]).append(' ');
            ++i;
        }
    }

    public void writeKeys(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size);
        int i = 0;
        while (i < this.size) {
            dos.writeInt(this.m_index[i]);
            ++i;
        }
    }

    public static final FVR read(DataInputStream dis) throws IOException {
        int cap = dis.readInt();
        if (cap == 0) {
            return null;
        }
        return new FVR(dis, cap);
    }

    @Override
    public double getScore() {
        System.out.println("not implemented");
        new Exception().printStackTrace();
        return 0.0;
    }

    @Override
    public IFV clone() {
        FVR f = new FVR(this.size);
        int i = 0;
        while (i < this.size) {
            f.m_index[i] = this.m_index[i];
            f.m_value[i] = this.m_value[i];
            ++i;
        }
        f.size = this.size;
        return f;
    }
}

