/*
 * Decompiled with CFR 0.152.
 */
package is2.data;

public class DPSTree {
    private int size = 0;
    public int[] heads;
    public int[] labels;

    public DPSTree() {
        this(30);
    }

    public DPSTree(int initialCapacity) {
        this.heads = new int[initialCapacity];
        this.labels = new int[initialCapacity];
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.heads.length) {
            int newCapacity = minCapacity + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int[] oldIndex = this.heads;
            this.heads = new int[newCapacity];
            System.arraycopy(oldIndex, 0, this.heads, 0, oldIndex.length);
            oldIndex = this.labels;
            this.labels = new int[newCapacity];
            System.arraycopy(oldIndex, 0, this.labels, 0, oldIndex.length);
        }
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        this.size = 0;
    }

    public final void createTerminals(int terminals) {
        this.ensureCapacity(terminals + 1);
        this.size = terminals + 1;
    }

    public final int create(int phrase) {
        this.ensureCapacity(this.size + 1);
        this.labels[this.size] = phrase;
        ++this.size;
        return this.size - 1;
    }

    public int create(int phrase, int nodeId) {
        if (nodeId < 0) {
            return this.create(phrase);
        }
        this.ensureCapacity(nodeId + 1);
        this.labels[nodeId] = phrase;
        if (this.size < nodeId) {
            this.size = nodeId + 1;
        }
        return nodeId;
    }

    public void createEdge(int i, int j) {
        this.heads[i] = j;
    }

    public DPSTree clone() {
        DPSTree ps = new DPSTree(this.size + 1);
        int k = 0;
        while (k < this.size) {
            ps.heads[k] = this.heads[k];
            ps.labels[k] = this.labels[k];
            ++k;
        }
        ps.size = this.size;
        return ps;
    }
}

