/*
 * Decompiled with CFR 0.152.
 */
package extractors;

import extractors.Extractor;
import is2.data.Cluster;
import is2.data.D4;
import is2.data.DataF;
import is2.data.Edges;
import is2.data.FV;
import is2.data.IFV;
import is2.data.Instances;
import is2.data.Long2IntInterface;
import is2.data.MFB;
import java.util.Arrays;

public final class ExtractorClusterStackedR2
implements Extractor {
    public static int s_rel;
    public static int s_word;
    public static int s_type;
    public static int s_dir;
    public static int s_dist;
    public static int s_feat;
    public static int s_child;
    public static int s_spath;
    public static int s_lpath;
    public static int s_pos;
    MFB mf;
    final D4 d0;
    final D4 dl1;
    final D4 dl2;
    final D4 dwr;
    final D4 dr;
    final D4 dwwp;
    final D4 dw;
    final D4 dwp;
    final D4 dlf;
    final D4 d3lp;
    final D4 d2lp;
    final D4 d2pw;
    final D4 d2pp;
    public final Long2IntInterface li;
    public static final String REL = "REL";
    public static final String END = "END";
    public static final String STR = "STR";
    public static final String LA = "LA";
    public static final String RA = "RA";
    private static int ra;
    private static int la;
    private static int s_str;
    private static int s_end;
    private static int _cend;
    private static int _cstr;
    private static int s_stwrd;
    private static int s_relend;
    protected static final String TYPE = "TYPE";
    protected static final String DIR = "D";
    protected static final String FEAT = "F";
    public static final String POS = "POS";
    protected static final String DIST = "DIST";
    protected static final String MID = "MID";
    private static final String _0 = "0";
    private static final String _4 = "4";
    private static final String _3 = "3";
    private static final String _2 = "2";
    private static final String _1 = "1";
    private static final String _5 = "5";
    private static final String _10 = "10";
    private static int di0;
    private static int d4;
    private static int d3;
    private static int d2;
    private static int d1;
    private static int d5;
    private static int d10;
    private static final String WORD = "WORD";
    private static final String STWRD = "STWRD";
    private static final String STPOS = "STPOS";
    private static int nofeat;
    private static int maxForm;

    public ExtractorClusterStackedR2(Long2IntInterface li) {
        ExtractorClusterStackedR2.initFeatures();
        this.li = li;
        this.d0 = new D4(li);
        this.dl1 = new D4(li);
        this.dl2 = new D4(li);
        this.dwr = new D4(li);
        this.dr = new D4(li);
        this.dwwp = new D4(li);
        this.dw = new D4(li);
        this.dwp = new D4(li);
        this.dlf = new D4(li);
        this.d3lp = new D4(li);
        this.d2lp = new D4(li);
        this.d2pw = new D4(li);
        this.d2pp = new D4(li);
    }

    @Override
    public void initStat() {
        this.mf = new MFB();
        s_rel = this.mf.getFeatureCounter().get(REL);
        s_pos = this.mf.getFeatureCounter().get(POS);
        s_word = this.mf.getFeatureCounter().get(WORD);
        s_type = this.mf.getFeatureCounter().get(TYPE);
        s_dir = this.mf.getFeatureCounter().get(DIR);
        la = this.mf.getValue(DIR, LA);
        ra = this.mf.getValue(DIR, RA);
        s_dist = this.mf.getFeatureCounter().get(DIST);
        s_feat = this.mf.getFeatureCounter().get(FEAT);
        s_spath = this.mf.getFeatureCounter().get("SP") == null ? 0 : this.mf.getFeatureCounter().get("SP");
        s_lpath = this.mf.getFeatureCounter().get("LP") == null ? 0 : this.mf.getFeatureCounter().get("LP");
    }

    @Override
    public void init() {
        this.d0.a0 = s_type;
        this.d0.a1 = s_pos;
        this.d0.a2 = s_pos;
        this.d0.a3 = s_pos;
        this.d0.a4 = s_pos;
        this.d0.a5 = s_pos;
        this.d0.a6 = s_pos;
        this.d0.a7 = s_pos;
        this.dl1.a0 = s_type;
        this.dl1.a1 = s_rel;
        this.dl1.a2 = s_pos;
        this.dl1.a3 = s_pos;
        this.dl1.a4 = s_pos;
        this.dl1.a5 = s_pos;
        this.dl1.a6 = s_pos;
        this.dl1.a7 = s_pos;
        this.dl2.a0 = s_type;
        this.dl2.a1 = s_rel;
        this.dl2.a2 = s_word;
        this.dl2.a3 = s_pos;
        this.dl2.a4 = s_pos;
        this.dl2.a5 = s_pos;
        this.dl2.a6 = s_pos;
        this.dl2.a7 = s_pos;
        this.dwp.a0 = s_type;
        this.dwp.a1 = s_rel;
        this.dwp.a2 = s_word;
        this.dwp.a3 = s_pos;
        this.dwp.a4 = s_pos;
        this.dwp.a5 = s_word;
        this.dwwp.a0 = s_type;
        this.dwwp.a1 = s_rel;
        this.dwwp.a2 = s_word;
        this.dwwp.a3 = s_word;
        this.dwwp.a4 = s_pos;
        this.dwwp.a5 = s_word;
        this.dlf.a0 = s_type;
        this.dlf.a1 = s_rel;
        this.dlf.a2 = s_pos;
        this.dlf.a3 = s_pos;
        this.dlf.a4 = s_feat;
        this.dlf.a5 = s_feat;
        this.dlf.a6 = s_pos;
        this.dlf.a7 = s_pos;
        this.d3lp.a0 = s_type;
        this.d3lp.a1 = s_rel;
        this.d3lp.a2 = s_lpath;
        this.d3lp.a3 = s_lpath;
        this.d3lp.a4 = s_lpath;
        this.d3lp.a5 = s_word;
        this.d3lp.a6 = s_spath;
        this.d3lp.a7 = s_spath;
        this.d2lp.a0 = s_type;
        this.d2lp.a1 = s_rel;
        this.d2lp.a2 = s_lpath;
        this.d2lp.a3 = s_lpath;
        this.d2lp.a4 = s_word;
        this.d2lp.a5 = s_word;
        this.d2pw.a0 = s_type;
        this.d2pw.a1 = s_rel;
        this.d2pw.a2 = s_lpath;
        this.d2pw.a3 = s_lpath;
        this.d2pw.a4 = s_word;
        this.d2pw.a5 = s_word;
        this.d2pp.a0 = s_type;
        this.d2pp.a1 = s_rel;
        this.d2pp.a2 = s_lpath;
        this.d2pp.a3 = s_lpath;
        this.d2pp.a4 = s_pos;
        this.d2pp.a5 = s_pos;
    }

    @Override
    public int basic(short[] pposs, int[] form, int p, int d, Cluster cluster, IFV f) {
        this.d0.clean();
        this.dl1.clean();
        this.dl2.clean();
        this.dwp.clean();
        this.dwwp.clean();
        this.dlf.clean();
        this.d3lp.clean();
        this.d3lp.clean();
        this.d2lp.clean();
        this.d2pw.clean();
        this.d2pp.clean();
        int n = 1;
        int dir = p < d ? ra : la;
        int end = p >= d ? p : d;
        int start = (p >= d ? d : p) + 1;
        StringBuilder s = new StringBuilder(end - start);
        int[] x = new int[end - start];
        int c = 0;
        int i = start;
        while (i < end) {
            x[c++] = pposs[i];
            ++i;
        }
        Arrays.sort(x);
        i = 0;
        while (i < x.length) {
            if (i == 0 || x[i] != x[i - 1]) {
                s.append(x[i]);
            }
            ++i;
        }
        int v = this.mf.register("px", s.toString());
        this.dwp.v0 = n++;
        this.dwp.v1 = 1L;
        this.dwp.v2 = v;
        this.dwp.v3 = pposs[p];
        this.dwp.v4 = pposs[d];
        this.dwp.cz5();
        this.dwp.csa(s_dir, dir, f);
        return n;
    }

    @Override
    public void firstm(Instances is, int i, int prnt, int dpnt, int label, Cluster cluster, long[] f) {
        int dir;
        int k = 0;
        while (k < f.length) {
            f[k] = 0L;
            ++k;
        }
        short[] pposs = is.pposs[i];
        int[] form = is.forms[i];
        short[][] feats = is.feats[i];
        int pF = form[prnt];
        int dF = form[dpnt];
        int pL = is.plemmas[i][prnt];
        int dL = is.plemmas[i][dpnt];
        short pP = pposs[prnt];
        short dP = pposs[dpnt];
        int prntLS = pF == -1 ? -1 : cluster.getLP(pF);
        int chldLS = dF == -1 ? -1 : cluster.getLP(dF);
        int n = dir = prnt < dpnt ? ra : la;
        if (pF > maxForm) {
            pF = -1;
        }
        if (pL > maxForm) {
            pL = -1;
        }
        if (dF > maxForm) {
            dF = -1;
        }
        if (dL > maxForm) {
            dL = -1;
        }
        int n2 = 3;
        int c = 0;
        this.dl2.v1 = label;
        this.dl2.v0 = n2++;
        this.dl2.v2 = pF;
        this.dl2.v3 = dP;
        this.dl2.cz4();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.cz3();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.v2 = dF;
        this.dl2.v3 = pP;
        this.dl2.cz4();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.cz3();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dwwp.v1 = label;
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = pF;
        this.dwwp.v3 = dF;
        this.dwwp.cz4();
        f[c++] = this.dwwp.csa(s_dir, dir);
        this.dl1.v1 = label;
        this.dl1.v0 = n2++;
        this.dl1.v2 = dP;
        this.dl1.cz3();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = pP;
        this.dl1.cz3();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = dP;
        this.dl1.cz4();
        f[c++] = this.dl1.csa(s_dir, dir);
        int pPm1 = prnt > 0 ? pposs[prnt - 1] : s_str;
        int dPm1 = dpnt > 0 ? pposs[dpnt - 1] : s_str;
        int pPp1 = prnt < pposs.length - 1 ? pposs[prnt + 1] : s_end;
        int dPp1 = dpnt < pposs.length - 1 ? pposs[dpnt + 1] : s_end;
        int pPm2 = prnt > 1 ? pposs[prnt - 2] : s_str;
        int dPm2 = dpnt > 1 ? pposs[dpnt - 2] : s_str;
        int pPp2 = prnt < pposs.length - 2 ? pposs[prnt + 2] : s_end;
        int dPp2 = dpnt < pposs.length - 2 ? pposs[dpnt + 2] : s_end;
        int pFm1 = prnt > 0 ? form[prnt - 1] : s_stwrd;
        int dFm1 = dpnt > 0 ? form[dpnt - 1] : s_stwrd;
        int pFp1 = prnt < form.length - 1 ? form[prnt + 1] : s_stwrd;
        int dFp1 = dpnt < form.length - 1 ? form[dpnt + 1] : s_stwrd;
        this.dl1.v0 = n2++;
        this.dl1.v2 = pP;
        this.dl1.v3 = pPp1;
        this.dl1.v4 = dP;
        this.dl1.v5 = dPp1;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v5 = dPm1;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPm1;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v5 = dPp1;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPm1;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = dPm1;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = dPp1;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPp1;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = pP;
        this.dl1.v3 = pPp2;
        this.dl1.v4 = dP;
        this.dl1.v5 = dPp2;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v5 = dPm2;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPm2;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v5 = dPp2;
        this.dl1.cz6();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPm2;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = dPm2;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = dPp2;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v3 = pPp2;
        this.dl1.cz5();
        f[n2++] = this.dl1.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.v3 = dFm1;
        this.dl2.v3 = pPp1;
        this.dl2.v4 = pP;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = dFp1;
        this.dl2.v3 = pPm1;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = pFm1;
        this.dl2.v3 = dPp1;
        this.dl2.v4 = dP;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = pFp1;
        this.dl2.v3 = dPm1;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = dFm1;
        this.dl2.v3 = dPm2;
        this.dl2.v4 = pP;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = dFp1;
        this.dl2.v3 = dPp2;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = pFm1;
        this.dl2.v3 = pPm2;
        this.dl2.v4 = dP;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dl2.v0 = n2++;
        this.dl2.v3 = pFp1;
        this.dl2.v3 = pPp2;
        this.dl2.cz5();
        f[n2++] = this.dl2.getVal();
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = pF;
        this.dwwp.v3 = dF;
        this.dwwp.v4 = dP;
        this.dwwp.cz5();
        f[n2++] = this.dwwp.csa(s_dir, dir);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = pF;
        this.dwwp.v3 = dF;
        this.dwwp.v4 = pP;
        this.dwwp.cz5();
        f[n2++] = this.dwwp.csa(s_dir, dir);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = dF;
        this.dwwp.v3 = pF;
        this.dwwp.v4 = pP;
        this.dwwp.v4 = dP;
        this.dwwp.cz6();
        f[n2++] = this.dwwp.csa(s_dir, dir);
        this.dl2.v1 = label;
        this.dl2.v0 = n2++;
        this.dl2.v2 = pL;
        this.dl2.v3 = dP;
        this.dl2.cz4();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.cz3();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.v2 = dL;
        this.dl2.v3 = pP;
        this.dl2.cz4();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dl2.v0 = n2++;
        this.dl2.cz3();
        f[c++] = this.dl2.csa(s_dir, dir);
        this.dwwp.v1 = label;
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = pL;
        this.dwwp.v3 = dL;
        this.dwwp.cz4();
        f[c++] = this.dwwp.csa(s_dir, dir);
        this.dwp.v1 = label;
        this.dwp.v0 = n2++;
        this.dwp.v2 = dL;
        this.dwp.v3 = pP;
        this.dwp.v4 = dP;
        this.dwp.v5 = pL;
        this.dwp.cz6();
        f[c++] = this.dwp.csa(s_dir, dir);
        this.dwp.v0 = n2++;
        this.dwp.cz5();
        f[c++] = this.dwp.csa(s_dir, dir);
        this.dwp.v0 = n2++;
        this.dwp.v2 = pL;
        this.dwp.cz5();
        f[c++] = this.dwp.csa(s_dir, dir);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = pL;
        this.dwwp.v3 = dL;
        this.dwwp.v4 = dP;
        this.dwwp.cz5();
        f[c++] = this.dwwp.csa(s_dir, dir);
        this.dwwp.v0 = n2++;
        this.dwwp.v4 = pP;
        this.dwwp.cz5();
        f[c++] = this.dwwp.csa(s_dir, dir);
        this.d2pw.v1 = label;
        this.d2pw.v0 = n2++;
        this.d2pw.v2 = prntLS;
        this.d2pw.v3 = chldLS;
        this.d2pw.cz4();
        f[c++] = this.d2pw.csa(s_dir, dir);
        this.d2pw.v0 = n2++;
        this.d2pw.v4 = pF;
        this.d2pw.cz5();
        f[c++] = this.d2pw.csa(s_dir, dir);
        this.d2pw.v0 = n2++;
        this.d2pw.v4 = dF;
        this.d2pw.cz5();
        f[c++] = this.d2pw.csa(s_dir, dir);
        this.d2pw.v0 = n2++;
        this.d2pw.v5 = pF;
        this.d2pw.cz6();
        f[c++] = this.d2pw.csa(s_dir, dir);
        this.d2pp.v1 = label;
        this.d2pp.v0 = n2++;
        this.d2pp.v2 = prntLS;
        this.d2pp.v3 = chldLS;
        this.d2pp.cz4();
        f[c++] = this.d2pp.csa(s_dir, dir);
        this.d2pp.v0 = n2++;
        this.d2pp.v4 = pP;
        this.d2pp.cz5();
        f[c++] = this.d2pp.csa(s_dir, dir);
        this.d2pp.v0 = n2++;
        this.d2pp.v4 = dP;
        this.d2pp.cz5();
        f[c++] = this.d2pp.csa(s_dir, dir);
        this.d2pp.v0 = n2++;
        this.d2pp.v5 = pP;
        this.d2pp.cz6();
        f[c++] = this.d2pp.csa(s_dir, dir);
        short[] prel = is.plabels[i];
        short[] phead = is.pheads[i];
        if (feats == null) {
            return;
        }
        short[] featsP = feats[prnt];
        short[] featsD = feats[dpnt];
        this.dlf.v0 = n2++;
        this.dlf.v1 = label;
        this.dlf.v2 = pP;
        this.dlf.v3 = dP;
        this.extractFeat(f, c, dir, featsP, featsD);
    }

    @Override
    public void gcm(Instances is, int i, int p, int d, int gc, int label, Cluster cluster, long[] f) {
        int gr;
        int g;
        int cLSm1;
        int pLSm1;
        int gcLSp1;
        int cLSp1;
        int pLSp1;
        int gcLS;
        int k = 0;
        while (k < f.length) {
            f[k] = 0L;
            ++k;
        }
        short[] pos = is.pposs[i];
        int[] forms = is.forms[i];
        int[] lemmas = is.plemmas[i];
        short[][] feats = is.feats[i];
        short pP = pos[p];
        short dP = pos[d];
        int prntF = forms[p];
        int chldF = forms[d];
        int prntL = lemmas[p];
        int chldL = lemmas[d];
        int prntLS = prntF == -1 ? -1 : cluster.getLP(prntF);
        int chldLS = chldF == -1 ? -1 : cluster.getLP(chldF);
        int gP = gc != -1 ? pos[gc] : s_str;
        int gcF = gc != -1 ? forms[gc] : s_stwrd;
        int gcL = gc != -1 ? lemmas[gc] : s_stwrd;
        int n = gcLS = gc != -1 && gcF != -1 ? cluster.getLP(gcF) : s_stwrd;
        if (prntF > maxForm) {
            prntF = -1;
        }
        if (prntL > maxForm) {
            prntL = -1;
        }
        if (chldF > maxForm) {
            chldF = -1;
        }
        if (chldL > maxForm) {
            chldL = -1;
        }
        if (gcF > maxForm) {
            gcF = -1;
        }
        if (gcL > maxForm) {
            gcL = -1;
        }
        int dir = p < d ? ra : la;
        int dir_gra = d < gc ? ra : la;
        int n2 = 84;
        int c = 0;
        this.dl1.v1 = label;
        this.dl1.v0 = n2++;
        this.dl1.v2 = pP;
        this.dl1.v3 = dP;
        this.dl1.v4 = gP;
        this.dl1.cz5();
        this.dl1.cs(s_dir, dir);
        f[c++] = this.dl1.csa(s_dir, dir_gra);
        this.dl1.v0 = n2++;
        this.dl1.v2 = pP;
        this.dl1.v3 = gP;
        this.dl1.cz4();
        this.dl1.cs(s_dir, dir);
        f[c++] = this.dl1.csa(s_dir, dir_gra);
        this.dl1.v0 = n2++;
        this.dl1.v2 = dP;
        this.dl1.cz4();
        this.dl1.cs(s_dir, dir);
        f[c++] = this.dl1.csa(s_dir, dir_gra);
        this.dwwp.v1 = label;
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = prntF;
        this.dwwp.v3 = gcF;
        this.dwwp.cz4();
        this.dwwp.cs(s_dir, dir);
        f[c++] = this.dwwp.csa(s_dir, dir_gra);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = chldF;
        this.dwwp.v3 = gcF;
        this.dwwp.cz4();
        this.dwwp.cs(s_dir, dir);
        f[c++] = this.dwwp.csa(s_dir, dir_gra);
        this.dwp.v1 = label;
        this.dwp.v0 = n2++;
        this.dwp.v2 = gcF;
        this.dwp.v3 = pP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = gcF;
        this.dwp.v3 = dP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = prntF;
        this.dwp.v3 = gP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = chldF;
        this.dwp.v3 = gP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = prntL;
        this.dwwp.v3 = gcL;
        this.dwwp.cz4();
        this.dwwp.cs(s_dir, dir);
        f[c++] = this.dwwp.csa(s_dir, dir_gra);
        this.dwwp.v0 = n2++;
        this.dwwp.v2 = chldL;
        this.dwwp.v3 = gcL;
        this.dwwp.cz4();
        this.dwwp.cs(s_dir, dir);
        f[c++] = this.dwwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = gcL;
        this.dwp.v3 = pP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = gcL;
        this.dwp.v3 = dP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = prntL;
        this.dwp.v3 = gP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.dwp.v0 = n2++;
        this.dwp.v2 = chldL;
        this.dwp.v3 = gP;
        this.dwp.cz4();
        this.dwp.cs(s_dir, dir);
        f[c++] = this.dwp.csa(s_dir, dir_gra);
        this.d2lp.v1 = label;
        this.d2lp.v0 = n2++;
        this.d2lp.v2 = prntLS;
        this.d2lp.v3 = gcLS;
        this.d2lp.cz4();
        this.d2lp.cs(s_dir, dir);
        f[c++] = this.d2lp.csa(s_dir, dir_gra);
        this.d2lp.v0 = n2++;
        this.d2lp.v2 = chldLS;
        this.d2lp.v3 = gcLS;
        this.d2lp.cz4();
        this.d2lp.cs(s_dir, dir);
        f[c++] = this.d2lp.csa(s_dir, dir_gra);
        this.d3lp.v0 = n2++;
        this.d3lp.v1 = label;
        this.d3lp.v2 = prntLS;
        this.d3lp.v3 = chldLS;
        this.d3lp.v4 = gcLS;
        this.d3lp.cz5();
        this.d3lp.cs(s_dir, dir);
        f[c++] = this.d3lp.csa(s_dir, dir_gra);
        this.d2lp.v0 = n2++;
        this.d2lp.v2 = prntLS;
        this.d2lp.v3 = chldLS;
        this.d2lp.v4 = gcF;
        this.d2lp.cz5();
        f[c++] = this.d2lp.csa(s_dir, dir);
        this.d2lp.v0 = n2++;
        this.d2lp.v2 = prntLS;
        this.d2lp.v3 = gcLS;
        this.d2lp.v4 = chldF;
        this.d2lp.cz5();
        f[c++] = this.d2lp.csa(s_dir, dir);
        this.d2lp.v0 = n2++;
        this.d2lp.v2 = chldLS;
        this.d2lp.v3 = gcLS;
        this.d2lp.v4 = prntF;
        this.d2lp.cz5();
        f[c++] = this.d2lp.csa(s_dir, dir);
        this.d2pp.v1 = label;
        this.d2pp.v0 = n2++;
        this.d2pp.v2 = prntLS;
        this.d2pp.v3 = chldLS;
        this.d2pp.v4 = gP;
        this.d2pp.cz5();
        f[c++] = this.d2pp.csa(s_dir, dir);
        this.d2pp.v0 = n2++;
        this.d2pp.v2 = prntLS;
        this.d2pp.v3 = gcLS;
        this.d2pp.v4 = dP;
        this.d2pp.cz5();
        f[c++] = this.d2pp.csa(s_dir, dir);
        this.d2pp.v0 = n2++;
        this.d2pp.v2 = chldLS;
        this.d2pp.v3 = gcLS;
        this.d2pp.v4 = pP;
        this.d2pp.cz5();
        f[c++] = this.d2pp.csa(s_dir, dir);
        int prntPm1 = p != 0 ? pos[p - 1] : s_str;
        int chldPm1 = d - 1 >= 0 ? pos[d - 1] : s_str;
        int prntPp1 = p != pos.length - 1 ? pos[p + 1] : s_end;
        int chldPp1 = d != pos.length - 1 ? pos[d + 1] : s_end;
        int gcPm1 = gc > 0 ? pos[gc - 1] : s_str;
        int gcPp1 = gc < pos.length - 1 ? pos[gc + 1] : s_end;
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = dP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPm1;
        this.dl1.v4 = dP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = dP;
        this.dl1.v4 = chldPp1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = dP;
        this.dl1.v4 = chldPm1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = chldPm1;
        this.dl1.v5 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcPm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = chldPm1;
        this.dl1.v5 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = dP;
        this.dl1.v5 = chldPp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcPm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = pP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPm1;
        this.dl1.v4 = pP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = pP;
        this.dl1.v4 = prntPp1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = pP;
        this.dl1.v4 = prntPm1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = prntPm1;
        this.dl1.v5 = pP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcPm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = prntPm1;
        this.dl1.v5 = pP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcPp1;
        this.dl1.v4 = pP;
        this.dl1.v5 = prntPp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcPm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = pP;
        this.dl1.v5 = prntPp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        int n3 = p != pos.length - 1 ? (forms[p + 1] == -1 ? -1 : cluster.getLP(forms[p + 1])) : (pLSp1 = _cend);
        int n4 = d != pos.length - 1 ? (forms[d + 1] == -1 ? -1 : cluster.getLP(forms[d + 1])) : (cLSp1 = _cend);
        int n5 = gc < pos.length - 1 ? (forms[gc + 1] == -1 ? -1 : cluster.getLP(forms[gc + 1])) : (gcLSp1 = s_end);
        int n6 = p != 0 ? (lemmas[p - 1] == -1 ? -1 : cluster.getLP(lemmas[p - 1])) : (pLSm1 = _cstr);
        int n7 = d - 1 >= 0 ? (lemmas[d - 1] == -1 ? -1 : cluster.getLP(lemmas[d - 1])) : (cLSm1 = _cstr);
        int gcLSm1 = gc > 0 ? (lemmas[gc - 1] == -1 ? -1 : cluster.getLP(lemmas[gc - 1])) : _cstr;
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = dP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSm1;
        this.dl1.v4 = dP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = dP;
        this.dl1.v4 = cLSp1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = dP;
        this.dl1.v4 = cLSm1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = cLSm1;
        this.dl1.v5 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcLSm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = cLSm1;
        this.dl1.v5 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = dP;
        this.dl1.v5 = cLSp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = cLSm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = dP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = pP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSm1;
        this.dl1.v4 = pP;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = pP;
        this.dl1.v4 = pLSp1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = pP;
        this.dl1.v4 = pLSm1;
        this.dl1.cz5();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = pLSm1;
        this.dl1.v5 = pP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcLSm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = pLSm1;
        this.dl1.v5 = pP;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gP;
        this.dl1.v3 = gcLSp1;
        this.dl1.v4 = pP;
        this.dl1.v5 = pLSp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        this.dl1.v0 = n2++;
        this.dl1.v2 = gcLSm1;
        this.dl1.v3 = gP;
        this.dl1.v4 = pP;
        this.dl1.v5 = pLSp1;
        this.dl1.cz6();
        f[c++] = this.dl1.csa(s_dir, dir);
        short[] prel = is.plabels[i];
        short[] phead = is.pheads[i];
        int n8 = g = p == phead[d] ? 1 : 2;
        if (gc >= 0) {
            g += d == phead[gc] ? 4 : 8;
        }
        int n9 = gr = gc == -1 ? s_relend : prel[gc];
        if (feats == null) {
            return;
        }
        short[] featsP = feats[d];
        short[] featsD = gc != -1 ? feats[gc] : null;
        this.dlf.v0 = n2++;
        this.dlf.v1 = label;
        this.dlf.v2 = gP;
        this.dlf.v3 = dP;
        this.extractFeat(f, c, dir, featsP, featsD);
    }

    @Override
    public void siblingm(Instances is, int i, short[] pos, int[] forms, int[] lemmas, short[][] feats, int prnt, int d, int sblng, int label, Cluster cluster, long[] f, int v) {
        block13: {
            short[] featsSbl;
            short[] featsP;
            int dir;
            block14: {
                block12: {
                    int cLSm1;
                    int pLSm1;
                    int sLSp1;
                    int cLSp1;
                    int pLSp1;
                    int k = 0;
                    while (k < f.length) {
                        f[k] = 0L;
                        ++k;
                    }
                    short pP = pos[prnt];
                    short dP = pos[d];
                    int prntF = forms[prnt];
                    int chldF = forms[d];
                    int prntL = lemmas[prnt];
                    int chldL = lemmas[d];
                    int prntLS = prntF == -1 ? -1 : cluster.getLP(prntF);
                    int chldLS = chldF == -1 ? -1 : cluster.getLP(chldF);
                    int sP = sblng != -1 ? pos[sblng] : s_str;
                    int sblF = sblng != -1 ? forms[sblng] : s_stwrd;
                    int sblL = sblng != -1 ? lemmas[sblng] : s_stwrd;
                    int sblLS = sblng != -1 && sblF != -1 ? cluster.getLP(sblF) : s_stwrd;
                    dir = prnt < d ? ra : la;
                    int abs = Math.abs(prnt - d);
                    int dist = abs > 10 ? d10 : (abs > 5 ? d5 : (abs == 5 ? d4 : (abs == 4 ? d3 : (abs == 3 ? d2 : (abs == 2 ? d1 : di0)))));
                    int n = 147;
                    if (prntF > maxForm) {
                        prntF = -1;
                    }
                    if (prntL > maxForm) {
                        prntL = -1;
                    }
                    if (chldF > maxForm) {
                        chldF = -1;
                    }
                    if (chldL > maxForm) {
                        chldL = -1;
                    }
                    if (sblF > maxForm) {
                        sblF = -1;
                    }
                    if (sblL > maxForm) {
                        sblL = -1;
                    }
                    this.dl1.v0 = n++;
                    this.dl1.v1 = label;
                    this.dl1.v2 = pP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = sP;
                    this.dl1.cz5();
                    f[0] = this.dl1.csa(s_dir, dir);
                    f[1] = this.dl1.csa(s_dist, dist);
                    this.dl1.v0 = n++;
                    this.dl1.v3 = sP;
                    this.dl1.cz4();
                    f[2] = this.dl1.csa(s_dir, dir);
                    f[3] = this.dl1.csa(s_dist, dist);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = dP;
                    this.dl1.cz4();
                    f[4] = this.dl1.csa(s_dir, dir);
                    f[5] = this.dl1.csa(s_dist, dist);
                    this.dwwp.v1 = label;
                    this.dwwp.v0 = n++;
                    this.dwwp.v2 = prntF;
                    this.dwwp.v3 = sblF;
                    this.dwwp.cz4();
                    f[6] = this.dwwp.csa(s_dir, dir);
                    f[7] = this.dwwp.csa(s_dist, dist);
                    this.dwwp.v0 = n++;
                    this.dwwp.v2 = chldF;
                    this.dwwp.cz4();
                    f[8] = this.dwwp.csa(s_dir, dir);
                    f[9] = this.dwwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v1 = label;
                    this.dwp.v2 = sblF;
                    this.dwp.v3 = pP;
                    this.dwp.cz4();
                    f[10] = this.dwp.csa(s_dir, dir);
                    f[11] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v3 = dP;
                    this.dwp.cz4();
                    f[12] = this.dwp.csa(s_dir, dir);
                    f[13] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v2 = prntF;
                    this.dwp.v3 = sP;
                    this.dwp.cz4();
                    f[14] = this.dwp.csa(s_dir, dir);
                    f[15] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v2 = chldF;
                    this.dwp.cz4();
                    f[16] = this.dwp.csa(s_dir, dir);
                    f[17] = this.dwp.csa(s_dist, dist);
                    this.dwwp.v0 = n++;
                    this.dwwp.v2 = prntL;
                    this.dwwp.v3 = sblL;
                    this.dwwp.cz4();
                    f[18] = this.dwwp.csa(s_dir, dir);
                    this.dwwp.v0 = n++;
                    this.dwwp.v2 = chldL;
                    this.dwwp.cz4();
                    f[19] = this.dwwp.csa(s_dir, dir);
                    f[20] = this.dwwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v2 = sblL;
                    this.dwp.v3 = pP;
                    this.dwp.cz4();
                    f[21] = this.dwp.csa(s_dir, dir);
                    f[22] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v3 = dP;
                    this.dwp.cz4();
                    f[23] = this.dwp.csa(s_dir, dir);
                    f[24] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v2 = prntL;
                    this.dwp.v3 = sP;
                    this.dwp.cz4();
                    f[25] = this.dwp.csa(s_dir, dir);
                    f[26] = this.dwp.csa(s_dist, dist);
                    this.dwp.v0 = n++;
                    this.dwp.v2 = chldL;
                    this.dwp.cz4();
                    f[27] = this.dwp.csa(s_dir, dir);
                    f[28] = this.dwp.csa(s_dist, dist);
                    this.d2lp.v1 = label;
                    this.d2lp.v0 = n++;
                    this.d2lp.v2 = prntLS;
                    this.d2lp.v3 = sblLS;
                    this.d2lp.cz4();
                    f[29] = this.d2lp.csa(s_dir, dir);
                    this.d2lp.v0 = n++;
                    this.d2lp.v2 = chldLS;
                    this.d2lp.v3 = sblLS;
                    this.d2lp.cz4();
                    f[30] = this.d2lp.csa(s_dir, dir);
                    f[31] = this.d2lp.csa(s_dist, dist);
                    this.d3lp.v1 = label;
                    this.d3lp.v0 = n++;
                    this.d3lp.v2 = prntLS;
                    this.d3lp.v3 = chldLS;
                    this.d3lp.v4 = sblLS;
                    this.d3lp.cz5();
                    f[32] = this.d3lp.csa(s_dir, dir);
                    this.d2lp.v0 = n++;
                    this.d2lp.v2 = prntLS;
                    this.d2lp.v3 = chldLS;
                    this.d2lp.v4 = sblF;
                    this.d2lp.cz5();
                    f[33] = this.d2lp.csa(s_dir, dir);
                    f[34] = this.d2lp.csa(s_dist, dist);
                    this.d2lp.v0 = n++;
                    this.d2lp.v2 = prntLS;
                    this.d2lp.v3 = sblLS;
                    this.d2lp.v4 = chldF;
                    this.d2lp.cz5();
                    f[35] = this.d2lp.csa(s_dir, dir);
                    f[36] = this.d2lp.csa(s_dist, dist);
                    this.d2lp.v0 = n++;
                    this.d2lp.v2 = chldLS;
                    this.d2lp.v3 = sblLS;
                    this.d2lp.v4 = prntF;
                    this.d2lp.cz5();
                    f[37] = this.d2lp.csa(s_dir, dir);
                    f[38] = this.d2lp.csa(s_dist, dist);
                    this.d2pp.v1 = label;
                    this.d2pp.v0 = n++;
                    this.d2pp.v2 = prntLS;
                    this.d2pp.v3 = chldLS;
                    this.d2pp.v4 = sP;
                    this.d2pp.cz5();
                    f[39] = this.d2pp.csa(s_dir, dir);
                    f[40] = this.d2pp.csa(s_dist, dist);
                    this.d2pp.v0 = n++;
                    this.d2pp.v2 = prntLS;
                    this.d2pp.v3 = sblLS;
                    this.d2pp.v4 = dP;
                    this.d2pp.cz5();
                    f[41] = this.d2pp.csa(s_dir, dir);
                    f[42] = this.d2pp.csa(s_dist, dist);
                    this.d2pp.v0 = n++;
                    this.d2pp.v2 = chldLS;
                    this.d2pp.v3 = sblLS;
                    this.d2pp.v4 = pP;
                    this.d2pp.cz5();
                    f[43] = this.d2pp.csa(s_dir, dir);
                    f[44] = this.d2pp.csa(s_dist, dist);
                    int prntPm1 = prnt != 0 ? pos[prnt - 1] : s_str;
                    int chldPm1 = d - 1 >= 0 ? pos[d - 1] : s_str;
                    int prntPp1 = prnt != pos.length - 1 ? pos[prnt + 1] : s_end;
                    int chldPp1 = d != pos.length - 1 ? pos[d + 1] : s_end;
                    int sblPm1 = sblng > 0 ? pos[sblng - 1] : s_str;
                    int sblPp1 = sblng < pos.length - 1 ? pos[sblng + 1] : s_end;
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[45] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPm1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[46] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = prntPp1;
                    this.dl1.cz5();
                    f[47] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = prntPm1;
                    this.dl1.cz5();
                    f[48] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = prntPm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[49] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sblPm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = prntPm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[50] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = prntPp1;
                    this.dl1.cz6();
                    f[51] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sblPm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = prntPp1;
                    this.dl1.cz6();
                    f[52] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[53] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPm1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[54] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = chldPp1;
                    this.dl1.cz5();
                    f[55] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = chldPm1;
                    this.dl1.cz5();
                    f[56] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = chldPm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[57] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sblPm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = chldPm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[58] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sblPp1;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = chldPp1;
                    this.dl1.cz6();
                    f[59] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sblPm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = chldPp1;
                    this.dl1.cz6();
                    f[60] = this.dl1.csa(s_dir, dir);
                    int c = 61;
                    int n2 = prnt != pos.length - 1 ? (forms[prnt + 1] == -1 ? -1 : cluster.getLP(forms[prnt + 1])) : (pLSp1 = _cend);
                    int n3 = d != pos.length - 1 ? (forms[d + 1] == -1 ? -1 : cluster.getLP(forms[d + 1])) : (cLSp1 = _cend);
                    int n4 = sblng < pos.length - 1 ? (forms[sblng + 1] == -1 ? -1 : cluster.getLP(forms[sblng + 1])) : (sLSp1 = _cend);
                    int n5 = prnt != 0 ? (forms[prnt - 1] == -1 ? -1 : cluster.getLP(forms[prnt - 1])) : (pLSm1 = _cstr);
                    int n6 = d - 1 >= 0 ? (forms[d - 1] == -1 ? -1 : cluster.getLP(forms[d - 1])) : (cLSm1 = _cstr);
                    int sLSm1 = sblng > 0 ? (forms[sblng - 1] == -1 ? -1 : cluster.getLP(forms[sblng - 1])) : _cstr;
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = pLSp1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = pLSm1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pLSm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = pLSm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = pLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = pLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = cLSp1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = cLSm1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = cLSm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = cLSm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = cLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = cLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = pP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = pLSp1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = pP;
                    this.dl1.v4 = pLSm1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pLSm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = pLSm1;
                    this.dl1.v5 = pP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = pLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = pP;
                    this.dl1.v5 = pLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = dP;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = cLSp1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = dP;
                    this.dl1.v4 = cLSm1;
                    this.dl1.cz5();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSm1;
                    this.dl1.v4 = cLSm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = cLSm1;
                    this.dl1.v5 = dP;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sP;
                    this.dl1.v3 = sLSp1;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = cLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    this.dl1.v0 = n++;
                    this.dl1.v2 = sLSm1;
                    this.dl1.v3 = sP;
                    this.dl1.v4 = dP;
                    this.dl1.v5 = cLSp1;
                    this.dl1.cz6();
                    f[c++] = this.dl1.csa(s_dir, dir);
                    if (feats == null) {
                        return;
                    }
                    int cnt = c;
                    featsP = feats[d];
                    featsSbl = sblng != -1 ? feats[sblng] : null;
                    this.dlf.v0 = n++;
                    this.dlf.v1 = label;
                    this.dlf.v2 = sP;
                    this.dlf.v3 = dP;
                    cnt = this.extractFeat(f, cnt, dir, featsP, featsSbl);
                    featsP = feats[prnt];
                    featsSbl = sblng != -1 ? feats[sblng] : null;
                    this.dlf.v0 = n++;
                    this.dlf.v1 = label;
                    this.dlf.v2 = pP;
                    this.dlf.v3 = sP;
                    if (featsP == null || featsSbl == null) break block12;
                    int i1 = 0;
                    while (i1 < featsP.length) {
                        int i2 = 0;
                        while (i2 < featsSbl.length) {
                            this.dlf.v4 = featsP[i1];
                            this.dlf.v5 = featsSbl[i2];
                            this.dlf.cz6();
                            f[cnt++] = this.dlf.csa(s_dir, prnt < sblng ? 1 : 2);
                            i2 = (short)(i2 + 1);
                        }
                        i1 = (short)(i1 + 1);
                    }
                    break block13;
                }
                if (featsP != null || featsSbl == null) break block14;
                int i2 = 0;
                while (i2 < featsSbl.length) {
                    this.dlf.v4 = nofeat;
                    this.dlf.v5 = featsSbl[i2];
                    this.dlf.cz6();
                    f[cnt++] = this.dlf.csa(s_dir, dir);
                    i2 = (short)(i2 + 1);
                }
                break block13;
            }
            if (featsP == null || featsSbl != null) break block13;
            int i1 = 0;
            while (i1 < featsP.length) {
                this.dlf.v4 = featsP[i1];
                this.dlf.v5 = nofeat;
                this.dlf.cz6();
                f[cnt++] = this.dlf.csa(s_dir, dir);
                i1 = (short)(i1 + 1);
            }
        }
    }

    private int extractFeat(long[] f, int cnt, int dir, short[] featsP, short[] featsD) {
        block5: {
            block6: {
                block4: {
                    if (featsP == null || featsD == null) break block4;
                    int i1 = 0;
                    while (i1 < featsP.length) {
                        int i2 = 0;
                        while (i2 < featsD.length) {
                            this.dlf.v4 = featsP[i1];
                            this.dlf.v5 = featsD[i2];
                            this.dlf.cz6();
                            f[cnt++] = this.dlf.csa(s_dir, dir);
                            i2 = (short)(i2 + 1);
                        }
                        i1 = (short)(i1 + 1);
                    }
                    break block5;
                }
                if (featsP != null || featsD == null) break block6;
                int i2 = 0;
                while (i2 < featsD.length) {
                    this.dlf.v4 = nofeat;
                    this.dlf.v5 = featsD[i2];
                    this.dlf.cz6();
                    f[cnt++] = this.dlf.csa(s_dir, dir);
                    i2 = (short)(i2 + 1);
                }
                break block5;
            }
            if (featsP == null || featsD != null) break block5;
            int i1 = 0;
            while (i1 < featsP.length) {
                this.dlf.v4 = featsP[i1];
                this.dlf.v5 = nofeat;
                this.dlf.cz6();
                f[cnt++] = this.dlf.csa(s_dir, dir);
                i1 = (short)(i1 + 1);
            }
        }
        return cnt;
    }

    @Override
    public FV encodeCat(Instances is, int ic, short[] pposs, int[] forms, int[] lemmas, short[] heads, short[] types, short[][] feats, Cluster cluster, FV f) {
        long[] svs = new long[250];
        int i = 1;
        while (i < heads.length) {
            int cmo;
            int cmi;
            int ch;
            int n = this.basic(pposs, forms, heads[i], i, cluster, f);
            this.firstm(is, ic, heads[i], i, types[i], cluster, svs);
            int k = 0;
            while (k < svs.length) {
                this.dl1.map(f, svs[k]);
                ++k;
            }
            if (heads[i] < i) {
                ch = ExtractorClusterStackedR2.rightmostRight(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.leftmostLeft(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.rightmostRight(heads, i, heads.length);
            } else {
                ch = ExtractorClusterStackedR2.leftmostLeft(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.rightmostRight(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.leftmostLeft(heads, i, 0);
            }
            this.siblingm(is, ic, pposs, forms, lemmas, feats, heads[i], i, ch, types[i], cluster, svs, n);
            int k2 = 0;
            while (k2 < svs.length) {
                this.dl1.map(f, svs[k2]);
                ++k2;
            }
            this.gcm(is, ic, heads[i], i, cmi, types[i], cluster, svs);
            k2 = 0;
            while (k2 < svs.length) {
                this.dl1.map(f, svs[k2]);
                ++k2;
            }
            this.gcm(is, ic, heads[i], i, cmo, types[i], cluster, svs);
            k2 = 0;
            while (k2 < svs.length) {
                this.dl1.map(f, svs[k2]);
                ++k2;
            }
            ++i;
        }
        return f;
    }

    @Override
    public float encode3(short[] pos, short[] heads, short[] types, DataF d2) {
        double v = 0.0;
        int i = 1;
        while (i < heads.length) {
            int cmo;
            int cmi;
            int ch;
            int dir = heads[i] < i ? 0 : 1;
            v += (double)d2.pl[heads[i]][i];
            v += (double)d2.lab[heads[i]][i][types[i]][dir];
            boolean left = i < heads[i];
            short[] labels = Edges.get(pos[heads[i]], pos[i], left);
            int lid = -1;
            int k = 0;
            while (k < labels.length) {
                if (types[i] == labels[k]) {
                    lid = k;
                    break;
                }
                ++k;
            }
            if (heads[i] < i) {
                ch = ExtractorClusterStackedR2.rightmostRight(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.leftmostLeft(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.rightmostRight(heads, i, heads.length);
                if (ch == -1) {
                    ch = heads[i];
                }
                if (cmi == -1) {
                    cmi = heads[i];
                }
                if (cmo == -1) {
                    cmo = heads[i];
                }
            } else {
                ch = ExtractorClusterStackedR2.leftmostLeft(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.rightmostRight(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.leftmostLeft(heads, i, 0);
                if (ch == -1) {
                    ch = i;
                }
                if (cmi == -1) {
                    cmi = i;
                }
                if (cmo == -1) {
                    cmo = i;
                }
            }
            v += (double)d2.sib[heads[i]][i][ch][dir][lid];
            v += (double)d2.gra[heads[i]][i][cmi][dir][lid];
            v += (double)d2.gra[heads[i]][i][cmo][dir][lid];
            ++i;
        }
        return (float)v;
    }

    public static float encode3(short[] pos, short[] heads, short[] types, float[] edgesScores, DataF d2) {
        double v = 0.0;
        int i = 1;
        while (i < heads.length) {
            int cmo;
            int cmi;
            int ch;
            int dir = heads[i] < i ? 0 : 1;
            edgesScores[i] = d2.pl[heads[i]][i];
            int n = i;
            edgesScores[n] = edgesScores[n] + d2.lab[heads[i]][i][types[i]][dir];
            boolean left = i < heads[i];
            short[] labels = Edges.get(pos[heads[i]], pos[i], left);
            int lid = -1;
            int k = 0;
            while (k < labels.length) {
                if (types[i] == labels[k]) {
                    lid = k;
                    break;
                }
                ++k;
            }
            if (heads[i] < i) {
                ch = ExtractorClusterStackedR2.rightmostRight(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.leftmostLeft(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.rightmostRight(heads, i, heads.length);
                if (ch == -1) {
                    ch = heads[i];
                }
                if (cmi == -1) {
                    cmi = heads[i];
                }
                if (cmo == -1) {
                    cmo = heads[i];
                }
            } else {
                ch = ExtractorClusterStackedR2.leftmostLeft(heads, heads[i], i);
                cmi = ExtractorClusterStackedR2.rightmostRight(heads, i, heads[i]);
                cmo = ExtractorClusterStackedR2.leftmostLeft(heads, i, 0);
                if (ch == -1) {
                    ch = i;
                }
                if (cmi == -1) {
                    cmi = i;
                }
                if (cmo == -1) {
                    cmo = i;
                }
            }
            int n2 = i;
            edgesScores[n2] = edgesScores[n2] + d2.sib[heads[i]][i][ch][dir][lid];
            int n3 = i;
            edgesScores[n3] = edgesScores[n3] + d2.gra[heads[i]][i][cmi][dir][lid];
            int n4 = i;
            edgesScores[n4] = edgesScores[n4] + d2.gra[heads[i]][i][cmo][dir][lid];
            v += (double)edgesScores[i];
            ++i;
        }
        return (float)v;
    }

    private static int rightmostRight(short[] heads, int head, int max) {
        int rightmost = -1;
        int i = head + 1;
        while (i < max) {
            if (heads[i] == head) {
                rightmost = i;
            }
            ++i;
        }
        return rightmost;
    }

    private static int leftmostLeft(short[] heads, int head, int min) {
        int leftmost = -1;
        int i = head - 1;
        while (i > min) {
            if (heads[i] == head) {
                leftmost = i;
            }
            --i;
        }
        return leftmost;
    }

    public static void initFeatures() {
        MFB mf = new MFB();
        mf.register(POS, MID);
        s_str = mf.register(POS, STR);
        s_end = mf.register(POS, END);
        s_relend = mf.register(REL, END);
        _cstr = mf.register("SP", STR);
        _cend = mf.register("SP", END);
        mf.register(TYPE, POS);
        s_stwrd = mf.register(WORD, STWRD);
        mf.register(POS, STPOS);
        la = mf.register(DIR, LA);
        ra = mf.register(DIR, RA);
        mf.register(TYPE, FEAT);
        nofeat = mf.register(FEAT, "NOFEAT");
        int k = 0;
        while (k < 215) {
            mf.register(TYPE, FEAT + k);
            ++k;
        }
        di0 = mf.register(DIST, _0);
        d1 = mf.register(DIST, _1);
        d2 = mf.register(DIST, _2);
        d3 = mf.register(DIST, _3);
        d4 = mf.register(DIST, _4);
        d5 = mf.register(DIST, _5);
        d10 = mf.register(DIST, _10);
    }

    @Override
    public int getType() {
        return s_type;
    }

    @Override
    public void setMaxForm(int max) {
        maxForm = max;
    }

    @Override
    public int getMaxForm() {
        return maxForm;
    }
}

