/*
 * Decompiled with CFR 0.152.
 */
package examples;

import is2.data.SentenceData09;
import is2.io.CONLLWriter09;
import is2.lemmatizer.Lemmatizer;
import is2.mtag.Tagger;
import is2.parser.Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FullPipeline {
    public static void main(String[] args) throws IOException {
        SentenceData09 i = new SentenceData09();
        if (args.length == 1) {
            StringTokenizer st = new StringTokenizer(args[0]);
            ArrayList<String> forms = new ArrayList<String>();
            forms.add("<root>");
            while (st.hasMoreTokens()) {
                forms.add(st.nextToken());
            }
            i.init(forms.toArray(new String[0]));
        } else {
            i.init(new String[]{"<root>", "Nach", "1600", "wurde", "M\u00c3\u00bcnstereifel", "zu", "einer", "einer", "Stadt", "der", "Gegenreformation", "umgebaut", ".", "1618", "1618", "kamen", "kamen", "die", "die", "Kapuziner", "Kapuziner", "nach", "nach", "M\u00c3\u00bcnstereifel", "M\u00c3\u00bcnstereifel", ",", ",", "die", "die", "auf", "auf", "ihrem", "ihrem", "Klosterbezirk", "Klosterbezirk", "auch", "auch", "eine", "eine", "Tuchmanufaktur", "Tuchmanufaktur", "errichteten", "errichteten", "und", "und", "damit", "damit", "neue", "neue", "Arbeitspl\u00c3\u00a4tze", "Arbeitspl\u00c3\u00a4tze", "f\u00c3\u00bcr", "f\u00c3\u00bcr", "die", "die", "in", "in", "Schwierigkeiten", "Schwierigkeiten", "geratenen", "geratenen", "Wollweber", "Wollweber", "schufen", "schufen", ".", ".", "1625", "1625", "nahmen", "nahmen", "die", "die", "Jesuiten", "Jesuiten", "den", "den", "Unterricht", "Unterricht", "des", "des", "St", "St", ".", "."});
        }
        System.out.println("\nReading the model of the lemmatizer");
        Lemmatizer lemmatizer = new Lemmatizer("models/lemmatizer.model");
        System.out.println("Applying the lemmatizer");
        lemmatizer.apply(i);
        System.out.print(i.toString());
        System.out.print("Lemmata: ");
        String[] stringArray = i.plemmas;
        int n = i.plemmas.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            System.out.print(String.valueOf(l) + " ");
            ++n2;
        }
        System.out.println();
        System.out.println("\nReading the model of the morphologic tagger");
        Tagger morphTagger = new Tagger("models/mtag-ger.model");
        System.out.println("\nApplying the morpholoigc tagger");
        morphTagger.apply(i);
        System.out.print(i.toString());
        System.out.print("Morph: ");
        String[] stringArray2 = i.pfeats;
        int n3 = i.pfeats.length;
        n = 0;
        while (n < n3) {
            String f = stringArray2[n];
            System.out.print(String.valueOf(f) + " ");
            ++n;
        }
        System.out.println();
        System.out.println("\nReading the model of the part-of-speech tagger");
        is2.tag.Tagger tagger = new is2.tag.Tagger("models/tagger-ct.model");
        System.out.println("\nApplying the part-of-speech tagger");
        tagger.apply(i);
        System.out.print(i.toString());
        System.out.print("Part-of-Speech tags: ");
        String[] stringArray3 = i.ppos;
        int n4 = i.ppos.length;
        n3 = 0;
        while (n3 < n4) {
            String p = stringArray3[n3];
            System.out.print(String.valueOf(p) + " ");
            ++n3;
        }
        System.out.println();
        System.out.println("\nReading the model of the dependency parser");
        Parser parser = new Parser("models/prs-ger-cs.model");
        System.out.println("\nApplying the parser");
        parser.apply(i);
        System.out.println(i.toString());
        CONLLWriter09 writer = new CONLLWriter09("example-out.txt");
        writer.write(i, true);
        writer.finishWriting();
    }
}

