/*
 * Decompiled with CFR 0.152.
 */
package examples;

import is2.data.InstancesTagger;
import is2.data.SentenceData09;
import is2.io.CONLLReader09;
import is2.lemmatizer.Lemmatizer;
import is2.lemmatizer.MFO;
import is2.parser.Parser;
import is2.tag.Tagger;
import java.io.File;
import java.util.Arrays;

public class DependencyParser {
    File lemmatizerFile;
    File taggerFile;
    File parserFile;

    public int execute() throws Throwable {
        Lemmatizer lemmatizer = new Lemmatizer(this.lemmatizerFile.getAbsolutePath(), true);
        Tagger tagger = new Tagger(this.taggerFile.getAbsolutePath());
        Parser parser = new Parser(this.parserFile.getAbsolutePath());
        String[] sentences = new String[]{"Airfields have been constructed on a number of the islands .", "Private investment has even made an increasingly modern ferry fleet possible .", "Politically , the 1990s have been relatively quite times for the islands ."};
        CONLLReader09 reader = new CONLLReader09(false);
        String[] stringArray = sentences;
        int n = sentences.length;
        int n2 = 0;
        while (n2 < n) {
            String sentence = stringArray[n2];
            InstancesTagger instanceTagger = new InstancesTagger();
            instanceTagger.init(1, new MFO());
            String[] split = sentence.split("\\s+");
            String[] splitRoot = new String[split.length + 1];
            System.arraycopy(split, 0, splitRoot, 1, split.length);
            splitRoot[0] = "<root>";
            SentenceData09 instance = new SentenceData09();
            instance.init(splitRoot);
            reader.insert(instanceTagger, instance);
            SentenceData09 result = lemmatizer.apply(instance);
            tagger.apply(result);
            result = parser.parse(result, parser.params, false, parser.options);
            System.out.println(Arrays.toString(result.forms));
            System.out.println(Arrays.toString(result.plemmas));
            System.out.println(Arrays.toString(result.ppos));
            System.out.println(Arrays.toString(result.pheads));
            System.out.println(Arrays.toString(result.plabels));
            System.out.println();
            ++n2;
        }
        return 0;
    }
}

