/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.util.scorer;

import java.util.HashSet;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.util.scorer.AbstractScorer;

public class PredicateIdentificationScorer
extends AbstractScorer {
    public static double score(Sentence gold, Sentence parsed) {
        if (gold.getPredicates().size() == 0 && parsed.getPredicates().size() == 0) {
            return 1.0;
        }
        int tp = 0;
        int fp = 0;
        int fn = 0;
        HashSet<Integer> tpSet = new HashSet<Integer>();
        for (Predicate pred : parsed.getPredicates()) {
            int index = parsed.indexOf(pred);
            if (gold.get(index) instanceof Predicate) {
                ++tp;
                tpSet.add(index);
                continue;
            }
            ++fp;
        }
        for (Predicate pred : gold.getPredicates()) {
            if (tpSet.contains(gold.indexOf(pred))) continue;
            ++fn;
        }
        double p = (double)tp / (double)(tp + fp);
        double r = (double)tp / (double)(tp + fn);
        if (p + r > 0.0) {
            return 2.0 * p * r / (p + r);
        }
        return 0.0;
    }

    @Override
    public double computeScore(Sentence gold, Sentence parsed) {
        return PredicateIdentificationScorer.score(gold, parsed);
    }
}

