/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.util.scorer;

import se.lth.cs.srl.corpus.Sentence;

public abstract class AbstractScorer {
    private int count = 0;
    private double accScore = 0.0;

    public double getAccumulatedScore() {
        return this.accScore;
    }

    public double getAvgScore() {
        return this.accScore / (double)this.count;
    }

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
        this.accScore = 0.0;
    }

    public double accScore(Sentence gold, Sentence parsed) {
        double score = this.computeScore(gold, parsed);
        this.accScore += score;
        ++this.count;
        return score;
    }

    public abstract double computeScore(Sentence var1, Sentence var2);
}

