/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.util;

import java.io.File;
import se.lth.cs.srl.languages.Language;
import se.lth.cs.srl.options.FullPipelineOptions;

public class FileExistenceVerifier {
    public static String verifyFiles(File ... files) {
        StringBuilder sb = new StringBuilder();
        for (File f : files) {
            if (!f.exists()) {
                sb.append("File " + f + " does not exist.\n");
            }
            if (f.canRead()) continue;
            sb.append("File " + f + " can not be read.\n");
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static String verifyCompletePipelineAlwaysNecessaryFiles(FullPipelineOptions options) {
        return FileExistenceVerifier.verifyFiles(options.tagger, options.parser, options.srl);
    }

    public static String verifyCompletePipelineAllNecessaryModelFiles(FullPipelineOptions options) {
        String error1 = FileExistenceVerifier.verifyCompletePipelineAlwaysNecessaryFiles(options);
        String error2 = Language.getLanguage().verifyLanguageSpecificModelFiles(options);
        if (error1 != null) {
            if (error2 != null) {
                return error1 + error2;
            }
            return error1;
        }
        if (error2 != null) {
            return error2;
        }
        return null;
    }
}

