/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.pipeline;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.ml.LearningProblem;
import se.lth.cs.srl.ml.Model;
import se.lth.cs.srl.pipeline.AbstractStep;

public abstract class ArgumentStep
extends AbstractStep {
    public ArgumentStep(FeatureSet fs) {
        super(fs);
    }

    protected abstract Integer getLabel(Predicate var1, Word var2);

    protected String getPOSPrefix(String pos) {
        for (String prefix : this.featureSet.POSPrefixes) {
            if (!pos.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    protected void addInstance(Predicate pred, Word arg) {
        String POSPrefix = this.getPOSPrefix(pred.getPOS());
        if (POSPrefix == null) {
            if (Learn.learnOptions.skipNonMatchingPredicates) {
                return;
            }
            POSPrefix = this.featureSet.POSPrefixes[0];
        }
        LearningProblem lp = (LearningProblem)this.learningProblems.get(POSPrefix);
        Collection<Integer> indices = this.collectIndices(pred, arg, POSPrefix, new TreeSet<Integer>());
        if (indices != null) {
            lp.addInstance(this.getLabel(pred, arg), indices);
        }
    }

    protected Collection<Integer> collectIndices(Predicate pred, Word arg, String POSPrefix, Collection<Integer> indices) {
        if (POSPrefix == null) {
            return null;
        }
        Integer offset = 0;
        for (Feature f : (List)this.featureSet.get(POSPrefix)) {
            f.addFeatures(indices, pred, arg, offset, false);
            offset = offset + f.size(false);
        }
        return indices;
    }

    public Integer classifyInstance(Predicate pred, Word arg) {
        String POSPrefix = this.getPOSPrefix(pred.getPOS());
        if (POSPrefix == null) {
            POSPrefix = this.featureSet.POSPrefixes[0];
            System.out.println("Unknown POS-tag for predicate '" + pred.getForm() + "', falling back to " + POSPrefix);
        }
        Model m = (Model)this.models.get(POSPrefix);
        Collection<Integer> indices = this.collectIndices(pred, arg, POSPrefix, new TreeSet<Integer>());
        return m.classify(indices);
    }
}

