/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.options;

import java.io.File;
import java.io.PrintStream;
import se.lth.cs.srl.languages.Language;

public abstract class Options {
    public File inputCorpus;
    public File modelFile;
    public int threads = 1;
    public int global_aiBeam = 4;
    public int global_acBeam = 4;
    public static int cores = Runtime.getRuntime().availableProcessors();

    protected void superParseCmdLine(String[] args) {
        if (args.length < 3) {
            System.err.println("Not enough arguments, aborting.");
            this.usage();
            System.exit(1);
        }
        int ai = 0;
        Language.L lang = null;
        try {
            lang = Language.L.valueOf(args[ai]);
        }
        catch (Exception e) {
            System.err.println("Unknown language " + args[ai] + ", aborting.");
            System.exit(1);
        }
        Language.setLanguage(lang);
        this.inputCorpus = new File(args[++ai]);
        this.modelFile = new File(args[++ai]);
        ++ai;
        while (ai < args.length) {
            if (args[ai].equals("-threads")) {
                this.threads = Integer.parseInt(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-aibeam")) {
                this.global_aiBeam = Integer.parseInt(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-acbeam")) {
                this.global_acBeam = Integer.parseInt(args[++ai]);
                ++ai;
                continue;
            }
            if (args[ai].equals("-cores")) {
                int n = ++ai;
                ++ai;
                cores = Integer.parseInt(args[n]);
                System.out.println("using cores: " + cores);
                continue;
            }
            if (args[ai].equals("-help") || args[ai].equals("--help")) {
                this.usage();
                System.exit(0);
                continue;
            }
            int newAi = this.parseCmdLine(args, ai);
            if (newAi == ai) {
                System.err.println("Unknown argument: " + args[ai] + ", aborting.");
                this.usage();
                System.exit(1);
                continue;
            }
            ai = newAi;
        }
        if (!this.inputCorpus.exists() || !this.inputCorpus.canRead()) {
            System.err.println("Input corpus" + this.inputCorpus + " does not exist or can not be read, aborting.");
            System.exit(1);
        }
        this.verifyArguments();
    }

    abstract int parseCmdLine(String[] var1, int var2);

    abstract boolean verifyArguments();

    abstract void usage();

    protected void printUsageOptions(PrintStream out) {
        out.println("Options:");
        out.println(" -aibeam <int>     the size of the ai-beam for the reranker");
        out.println(" -acbeam <int>     the size of the ac-beam for the reranker");
        out.println(" -help             prints this message");
    }

    protected void printUsageLanguages(PrintStream out) {
        out.println("<lang> corresponds to the language and is one of");
        out.println(" chi, eng, ger");
    }
}

