/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.options;

import java.io.File;
import se.lth.cs.srl.CompletePipeline;
import se.lth.cs.srl.options.FullPipelineOptions;

public class CompletePipelineCMDLineOptions
extends FullPipelineOptions {
    public File output = new File("out.txt");
    public File input;
    public boolean desegment = false;

    public CompletePipelineCMDLineOptions() {
        this.loadPreprocessorWithTokenizer = false;
    }

    @Override
    String getSubUsageOptions() {
        return "-test   <file>    the input corpus. assumed to be tokenized like CoNLL 09 data\n-out    <file>    the file to write output to (default out.txt)\n-nopi             skips the predicate identification\n-tokenize         implies the input is unsegmented, with one sentence per line, i.e. _not_ CoNLL09 format";
    }

    @Override
    int trySubParseArg(String[] args, int ai) {
        if (args[ai].equals("-out")) {
            this.output = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-test")) {
            this.input = new File(args[++ai]);
            ++ai;
        } else if (args[ai].equals("-nopi")) {
            ++ai;
            this.skipPI = true;
        } else if (args[ai].equals("-desegment")) {
            ++ai;
            this.desegment = true;
            this.skipPI = false;
        } else if (args[ai].equals("-tokenize")) {
            ++ai;
            this.loadPreprocessorWithTokenizer = true;
            this.skipPI = false;
            this.desegment = false;
        }
        return ai;
    }

    @Override
    Class<?> getIntendedEntryClass() {
        return CompletePipeline.class;
    }
}

