/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.ml.liblinear;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import liblinear.InvalidInputDataException;
import liblinear.Linear;
import liblinear.Train;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.ml.Model;
import se.lth.cs.srl.ml.liblinear.Label;
import se.lth.cs.srl.ml.liblinear.WeightVector;

public class LibLinearModel
implements Model {
    private static final long serialVersionUID = 1L;
    private WeightVector weightVector;
    private List<Integer> labels;
    private int features;
    private double bias;
    private String solverType;

    LibLinearModel(File modelFile, boolean sparse) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(modelFile));
        this.parseHeader(in);
        this.weightVector = WeightVector.parseWeights(in, this.features, this.labels.size(), this.bias, sparse);
    }

    @Override
    public Integer classify(Collection<Integer> indices) {
        return this.labels.get(this.weightVector.computeBestClass(indices));
    }

    @Override
    public List<Label> classifyProb(Collection<Integer> indices) {
        ArrayList<Label> ret = new ArrayList<Label>(this.labels.size());
        double[] probs = this.weightVector.computeAllProbs(indices);
        for (int i = 0; i < probs.length; ++i) {
            ret.add(new Label(this.labels.get(i), probs[i]));
        }
        Collections.sort(ret, Collections.reverseOrder());
        return ret;
    }

    public void sparsify() {
        if (this.isSparse()) {
            return;
        }
        this.weightVector = this.weightVector.classes == 2 ? new WeightVector.BinarySparseVector((WeightVector.BinaryLibLinearVector)this.weightVector) : new WeightVector.MultipleSparseVector((WeightVector.MultipleLibLinearVector)this.weightVector);
    }

    private boolean isSparse() {
        return this.weightVector instanceof WeightVector.BinarySparseVector || this.weightVector instanceof WeightVector.MultipleSparseVector;
    }

    protected void parseHeader(BufferedReader in) throws IOException {
        String[] l;
        this.labels = new ArrayList<Integer>();
        this.solverType = in.readLine().substring("solver_type ".length());
        if (Short.parseShort(in.readLine().substring("nr_class ".length())) == 0) {
            throw new IOException("Error while parsing header! Model is empty!");
        }
        for (String s : l = in.readLine().substring("label ".length()).split(" ")) {
            this.labels.add(Integer.parseInt(s));
        }
        this.features = Integer.parseInt(in.readLine().substring("nr_feature ".length()));
        this.bias = Double.parseDouble(in.readLine().substring("bias ".length()));
        in.readLine();
    }

    static void trainModel(File dataFile, File outputFile) throws IOException, InterruptedException {
        if (Learn.learnOptions.liblinearBinary != null) {
            String[] llargs = new String[]{"-q", "-s", "0", dataFile.toString(), outputFile.toString()};
            StringBuilder cmd = new StringBuilder(Learn.learnOptions.liblinearBinary.toString());
            for (String arg : llargs) {
                cmd.append(' ').append(arg);
            }
            Process p = Runtime.getRuntime().exec(cmd.toString());
            if (p.waitFor() != 0) {
                throw new Error("LibLinear binary exited with non-zero exit value: " + p.exitValue());
            }
        } else {
            try {
                String[] llargs = new String[]{"-s", "0", dataFile.toString(), outputFile.toString()};
                Linear.disableDebugOutput();
                Train.main((String[])llargs);
            }
            catch (InvalidInputDataException e) {
                e.printStackTrace();
                System.err.println("LibLinear java failed. Look into this.");
                System.exit(1);
            }
        }
    }
}

