/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.languages;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.languages.Chinese;
import se.lth.cs.srl.languages.English;
import se.lth.cs.srl.languages.German;
import se.lth.cs.srl.options.FullPipelineOptions;
import se.lth.cs.srl.preprocessor.Preprocessor;

public abstract class Language {
    private static Language language;

    public static Language getLanguage() {
        return language;
    }

    public static String getLsString() {
        return "chi, eng, ger";
    }

    public static String LtoString(L l) {
        switch (l) {
            case chi: {
                return "Chinese";
            }
            case eng: {
                return "English";
            }
            case ger: {
                return "German";
            }
        }
        throw new IllegalArgumentException("Unknown language: '" + (Object)((Object)l) + "'");
    }

    public static Language setLanguage(L l) {
        switch (l) {
            case chi: {
                language = new Chinese();
                break;
            }
            case eng: {
                language = new English();
                break;
            }
            case ger: {
                language = new German();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown language: '" + (Object)((Object)l) + "'");
            }
        }
        return language;
    }

    public abstract Pattern getFeatSplitPattern();

    public abstract String getDefaultSense(String var1);

    public abstract String getCoreArgumentLabelSequence(Predicate var1, Map<Word, String> var2);

    public abstract L getL();

    public abstract String getLexiconURL(Predicate var1);

    public abstract Preprocessor getPreprocessor(FullPipelineOptions var1) throws IOException;

    public abstract String verifyLanguageSpecificModelFiles(FullPipelineOptions var1);

    public static enum L {
        cat,
        chi,
        cze,
        eng,
        ger,
        jap,
        spa;

    }
}

