/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.io.SentenceReader;

public abstract class AbstractCoNLL09Reader
implements SentenceReader {
    protected static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");
    protected BufferedReader in;
    protected Sentence nextSen;
    private File file;

    public AbstractCoNLL09Reader(File file) {
        this.file = file;
        this.open();
    }

    private void restart() {
        try {
            this.in.close();
            this.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void open() {
        System.out.println("Opening reader for " + this.file + "...");
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), Charset.forName("UTF-8")));
            this.readNextSentence();
        }
        catch (IOException e) {
            System.out.println("Failed: " + e.toString());
            System.exit(1);
        }
    }

    protected abstract void readNextSentence() throws IOException;

    private Sentence getSentence() {
        Sentence ret = this.nextSen;
        try {
            this.readNextSentence();
        }
        catch (IOException e) {
            System.out.println("Failed to read from corpus file... exiting.");
            System.exit(1);
        }
        return ret;
    }

    @Override
    public List<Sentence> readAll() {
        ArrayList<Sentence> ret = new ArrayList<Sentence>();
        for (Sentence s : this) {
            ret.add(s);
        }
        ret.trimToSize();
        return ret;
    }

    @Override
    public Iterator<Sentence> iterator() {
        if (this.nextSen == null) {
            this.restart();
        }
        return new SentenceIterator();
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class SentenceIterator
    implements Iterator<Sentence> {
        private SentenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return AbstractCoNLL09Reader.this.nextSen != null;
        }

        @Override
        public Sentence next() {
            return AbstractCoNLL09Reader.this.getSentence();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

