/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http.whatswrongglue;

import com.googlecode.whatswrong.Edge;
import com.googlecode.whatswrong.NLPCanvasRenderer;
import com.googlecode.whatswrong.NLPInstance;
import com.googlecode.whatswrong.SingleSentenceRenderer;
import com.googlecode.whatswrong.Token;
import com.googlecode.whatswrong.TokenProperty;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.http.whatswrongglue.Export;
import se.lth.cs.srl.io.AllCoNLL09Reader;

public class WhatsWrongHelper {
    private static NLPCanvasRenderer renderer = new SingleSentenceRenderer();
    private static final TokenProperty FORM = new TokenProperty("Form", 0);
    private static final TokenProperty LEMMA = new TokenProperty("Lemma", 1);
    private static final TokenProperty POS = new TokenProperty("POS", 2);

    public static ByteArrayOutputStream renderJPG(NLPInstance instance, double scaleFactor) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Export.exportToJPG(baos, renderer, instance, scaleFactor);
        return baos;
    }

    public static ByteArrayOutputStream renderPNG(NLPInstance instance, double scaleFactor) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Export.exportToPNG(baos, renderer, instance, scaleFactor);
        return baos;
    }

    public static NLPInstance getNLPInstance(Sentence s) {
        int i;
        ArrayList<Token> tokens = new ArrayList<Token>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        int size = s.size();
        for (i = 0; i < size; ++i) {
            tokens.add(new Token(i));
        }
        ((Token)tokens.get(0)).addProperty(FORM, "<root>");
        size = s.size();
        for (i = 1; i < size; ++i) {
            Word w = (Word)s.get(i);
            Token t = (Token)tokens.get(i);
            String form = w.getForm();
            String lemma = w.getLemma();
            String pos = w.getPOS();
            if (form == null || form.equals("")) {
                form = "!";
            }
            if (lemma == null || lemma.equals("")) {
                lemma = "_";
            }
            if (pos == null || pos.equals("")) {
                pos = "_";
            }
            t.addProperty(FORM, form);
            t.addProperty(LEMMA, lemma);
            t.addProperty(POS, pos);
            int tokenHead = w.getHeadId();
            edges.add(new Edge((Token)tokens.get(tokenHead), t, w.getDeprel(), "dep"));
        }
        NLPInstance instance = new NLPInstance(tokens, edges, NLPInstance.RenderType.single, Collections.EMPTY_LIST);
        return instance;
    }

    public static void main(String[] args) throws IOException {
        AllCoNLL09Reader reader = new AllCoNLL09Reader(new File("/home/anders/corpora/conll09/eng/CoNLL2009-ST-English-trial.txt"));
        Iterator it = reader.iterator();
        Sentence s = (Sentence)it.next();
        NLPInstance instance = WhatsWrongHelper.getNLPInstance(s);
        ByteArrayOutputStream baos = WhatsWrongHelper.renderPNG(instance, 1.0);
        FileOutputStream fos = new FileOutputStream("a.png");
        fos.write(baos.toByteArray());
        fos.flush();
        fos.close();
    }
}

