/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import se.lth.cs.srl.CompletePipeline;
import se.lth.cs.srl.corpus.Predicate;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.corpus.Yield;
import se.lth.cs.srl.http.DefaultHandler;
import se.lth.cs.srl.http.Handler;
import se.lth.cs.srl.http.ImageCache;
import se.lth.cs.srl.http.whatswrongglue.WhatsWrongHelper;
import se.lth.cs.srl.languages.Language;

public class ParseRequestHandler
extends Handler {
    private CompletePipeline pipeline;
    private HttpHandler defaultHandler;
    private ImageCache imageCache;
    private static final HashSet<String> styleSheetArgs = new HashSet();

    public ParseRequestHandler(HttpHandler defaultHandler, CompletePipeline pipeline, ImageCache imageCache) throws IOException {
        this.defaultHandler = defaultHandler;
        this.pipeline = pipeline;
        this.imageCache = imageCache;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String httpResponse;
        String content_type;
        if (!exchange.getRequestMethod().equals("POST")) {
            this.defaultHandler.handle(exchange);
            return;
        }
        Map<String, String> vars = Handler.contentToVariableMap(this.getContent(exchange));
        String inputSentence = vars.get("sentence");
        if (inputSentence == null || inputSentence.length() == 0) {
            this.sendContent(exchange, "Error, invalid request.", "text/plain");
            return;
        }
        System.out.println("@Parsing ``" + inputSentence + "'' at " + new Date(System.currentTimeMillis()));
        System.out.println("Requested by " + exchange.getRemoteAddress());
        long parsingTime = System.currentTimeMillis();
        Sentence sen = null;
        try {
            sen = this.pipeline.parse(inputSentence);
        }
        catch (Throwable t) {
            t.printStackTrace();
            content_type = "text/plain";
            httpResponse = "Server crashed.";
            this.sendContent(exchange, httpResponse, content_type);
            System.err.println("Server crashed. Exiting.");
            System.exit(1);
        }
        parsingTime = System.currentTimeMillis() - parsingTime;
        if (vars.containsKey("returnType") && vars.get("returnType").equals("html")) {
            boolean performURLLookup = vars.containsKey("doPerformDictionaryLookup");
            boolean includeDependencyGraphImage = vars.containsKey("doRenderDependencyGraph");
            httpResponse = this.getHTMLResponse(sen, parsingTime, performURLLookup, includeDependencyGraphImage);
            content_type = "text/html; charset=UTF-8";
        } else {
            httpResponse = sen.toString();
            content_type = "text/plain";
        }
        System.out.println("Content type returned: " + content_type);
        System.out.println("Sentence returned:");
        System.out.println(sen.toString());
        this.sendContent(exchange, httpResponse, content_type);
    }

    private String getHTMLResponse(Sentence sen, long parsingTime, boolean performURLLookup, boolean includeDependencyGraphImage) {
        StringBuilder ret = new StringBuilder("<html><head>\n<title>Semantic Role Labeler</title>\n<style type=\"text/css\">\n  table { background-color:#000000 }\n  td { background-color: #EEEEEE}\n  th { background-color: #EEEEEE}\n  .topRowCell {border-bottom: 1px solid black}\n  .A0, .C-A0 {background-color:#CCCC00}\n  .A1, .C-A1 {background-color:#CC0000}\n  .A2, .C-A2 {background-color:#00CC00}\n  .A3, .C-A3 {background-color:#0000CC}\n  .AM-NEG {background-color:#CC00CC}\n  .AM-MNR {background-color:#00CCCC}\n  .ARG_DEFAULT {background-color:#CCCCCC}\n</style>\n</head>\n<body>\n");
        ret.append("<table cellpadding=10 cellspacing=1>\n<tr><td class=\"topRowCell\">&nbsp;</td>");
        for (int i = 1; i < sen.size(); ++i) {
            ret.append("<td align=\"center\" class=\"topRowCell\">").append(((Word)sen.get(i)).getForm()).append("</td>");
        }
        StringBuilder errors = new StringBuilder();
        for (Predicate pred : sen.getPredicates()) {
            int indexCount = 1;
            ret.append("\n<tr><td>");
            String URL2 = Language.getLanguage().getLexiconURL(pred);
            if (performURLLookup && URL2 != null && this.isValidURL(URL2)) {
                ret.append("<a href=\"" + URL2 + "\">");
                ret.append(pred.getSense());
                ret.append("</a>");
            } else {
                ret.append(pred.getSense());
            }
            ret.append("</td>\n");
            TreeSet<Yield> yields = new TreeSet<Yield>();
            Map<Word, String> argmap = pred.getArgMap();
            for (Word arg : argmap.keySet()) {
                yields.addAll(arg.getYield(pred, argmap.get(arg), argmap.keySet()).explode());
            }
            for (Yield y : yields) {
                int blankColSpan;
                if (!y.isContinuous()) {
                    errors.append("((Discontinous yield of argument '" + y + "' of predicate '" + pred.getSense() + "'. Yield contains tokens [");
                    for (Word w : y) {
                        errors.append("'" + w.getForm() + "', ");
                    }
                    errors.delete(errors.length() - 2, errors.length());
                    errors.append("])).\n");
                }
                if ((blankColSpan = sen.indexOf(y.first()) - indexCount) > 0) {
                    ret.append("<td colspan=\"").append(blankColSpan).append("\">&nbsp;</td>");
                } else if (blankColSpan < 0) {
                    errors.append("Argument '" + y.getArgLabel() + "' of '" + pred.getSense() + "' at index " + indexCount + " overlaps with previous argument(s), ignored.\n");
                    continue;
                }
                int argColWidth = sen.indexOf(y.last()) - sen.indexOf(y.first()) + 1;
                String argLabel = y.getArgLabel();
                ret.append("<td colspan=\"").append(argColWidth).append("\" class=\"").append(styleSheetArgs.contains(argLabel) ? argLabel : "ARG_DEFAULT").append("\" align=\"center\">").append(argLabel).append("</td>");
                indexCount += argColWidth;
                indexCount += blankColSpan;
            }
            if (indexCount < sen.size()) {
                ret.append("<td colspan=\"" + (sen.size() - indexCount) + "\">&nbsp;</td>");
            }
            ret.append("</tr>");
        }
        ret.append("\n</table><br/>\n");
        ret.append("Parsing sentence required " + parsingTime + "ms.<br/>\n");
        if (errors.length() > 0) {
            ret.append("<br/><hr><br/><font color=\"#FF0000\">Errors</font><br/>");
            ret.append(errors.toString().replace("\n", "<br/>"));
            System.err.println(errors.toString().trim());
        }
        ret.append("<br/>\n<hr/>\n<br/>\n");
        if (includeDependencyGraphImage) {
            try {
                ByteArrayOutputStream baos = WhatsWrongHelper.renderPNG(WhatsWrongHelper.getNLPInstance(sen), 1.0);
                String key = this.imageCache.addObject(baos);
                ret.append("<img src=\"/img/" + key + ".png\"/>");
                ret.append("<br/>\n<hr/>\n<br/>\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ret.append("<table><tr><th>ID</th><th>Form</th><th>Lemma</th><th>PLemma</th><th>POS</th><th>PPOS</th><th>Feats</th><th>PFeats</th><th>Head</th><th>PHead</th><th>Deprel</th><th>PDeprel</th><th>IsPred</th><th>Pred</th>");
        for (int i = 0; i < sen.getPredicates().size(); ++i) {
            ret.append("<th>Args: " + sen.getPredicates().get(i).getSense() + "</th>");
        }
        ret.append("</tr>\n");
        for (String line : sen.toString().split("\n")) {
            ret.append("<tr>");
            int tokIdx = 0;
            for (String token : line.split("\t")) {
                if (tokIdx % 2 == 0 && tokIdx > 1 && tokIdx < 12) {
                    token = "_";
                }
                ret.append("<td>").append(token).append("</td>");
                ++tokIdx;
            }
            ret.append("</tr>\n");
        }
        ret.append("</table>\n<br/><hr/><br/>");
        ret.append((String)DefaultHandler.pages.get("default"));
        ret.append("</body></html>");
        return ret.toString();
    }

    private boolean isValidURL(String url) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setRequestMethod("HEAD");
            conn.connect();
            return conn.getResponseCode() == 200;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    static {
        styleSheetArgs.add("A0");
        styleSheetArgs.add("C-A0");
        styleSheetArgs.add("A1");
        styleSheetArgs.add("C-A1");
        styleSheetArgs.add("A2");
        styleSheetArgs.add("C-A2");
        styleSheetArgs.add("A3");
        styleSheetArgs.add("C-A3");
        styleSheetArgs.add("AM-NEG");
        styleSheetArgs.add("AM-MNR");
    }
}

