/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import se.lth.cs.srl.http.ImageCache;

public class ImageRequestHandler
implements HttpHandler {
    private ImageCache imageCache;

    public ImageRequestHandler(ImageCache imageCache) {
        this.imageCache = imageCache;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        URI u = exchange.getRequestURI();
        String path = u.getPath();
        String key = path.substring(path.lastIndexOf("/") + 1, path.length() - 4);
        ByteArrayOutputStream baos = (ByteArrayOutputStream)this.imageCache.getObject(key);
        byte[] bytes = baos.toByteArray();
        exchange.getResponseHeaders().add("Content-type", "image/png");
        exchange.sendResponseHeaders(200, bytes.length);
        BufferedOutputStream os = new BufferedOutputStream(exchange.getResponseBody());
        ((OutputStream)os).write(bytes);
        ((OutputStream)os).close();
    }
}

