/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;

public class ImageCache {
    private Map<String, Entry> cache;
    private Random generator;
    private CleanUpThread cleanUpThread;
    private LinkedList<Entry> entryQueue;
    private int maximumSize;
    private long entryLifeTime;

    public ImageCache(long entryLifeTime, long cleanUpCycleTime, int maximumSize) {
        this.entryLifeTime = entryLifeTime;
        this.maximumSize = maximumSize;
        this.cache = new HashMap<String, Entry>();
        this.generator = new Random();
        this.cleanUpThread = new CleanUpThread(cleanUpCycleTime);
        this.entryQueue = new LinkedList();
        this.cleanUpThread.start();
    }

    public synchronized Object getObject(String key) {
        Entry e = this.cache.get(key);
        if (e != null) {
            return e.object;
        }
        return null;
    }

    public synchronized String addObject(Object obj) {
        String key = Integer.toString(this.getRandomKey());
        Entry e = new Entry(key, obj);
        this.cache.put(key, e);
        this.entryQueue.add(e);
        if (this.getSize() > this.maximumSize) {
            this.cleanUpThread.interrupt();
        }
        return key;
    }

    private int getRandomKey() {
        int i;
        while (this.cache.containsKey(Integer.toString(i = this.generator.nextInt()))) {
        }
        return i;
    }

    public synchronized void killCleanUpThread() {
        this.cleanUpThread.kill();
        this.cleanUpThread.interrupt();
    }

    public synchronized int getSize() {
        int queueSize;
        int cacheSize = this.cache.size();
        if (cacheSize != (queueSize = this.entryQueue.size())) {
            throw new Error("Cache and queue don't have equal size in " + ImageCache.class.getName() + ", there must be an error in the implementation!");
        }
        return cacheSize;
    }

    private class CleanUpThread
    extends Thread {
        private long cleanUpCycleTime;
        private boolean alive;

        public CleanUpThread(long cleanUpCycleTime) {
            this.cleanUpCycleTime = cleanUpCycleTime;
            this.alive = true;
        }

        public void kill() {
            this.alive = false;
        }

        @Override
        public void run() {
            while (this.alive) {
                Entry first;
                while (!(ImageCache.this.entryQueue.isEmpty() || (first = (Entry)ImageCache.this.entryQueue.getFirst()).earliestTimeOfDeath >= System.currentTimeMillis() && ImageCache.this.entryQueue.size() <= ImageCache.this.maximumSize)) {
                    Entry e = (Entry)ImageCache.this.entryQueue.removeFirst();
                    ImageCache.this.cache.remove(e.key);
                }
                try {
                    Thread.sleep(this.cleanUpCycleTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Entry {
        private long birth = System.currentTimeMillis();
        private long earliestTimeOfDeath;
        private String key;
        private Object object;

        public Entry(String key, Object value) {
            this.earliestTimeOfDeath = this.birth + ImageCache.this.entryLifeTime;
            this.key = key;
            this.object = value;
        }
    }
}

