/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.http;

import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.net.InetSocketAddress;
import java.util.Date;
import se.lth.cs.srl.CompletePipeline;
import se.lth.cs.srl.http.DefaultHandler;
import se.lth.cs.srl.http.ImageCache;
import se.lth.cs.srl.http.ImageRequestHandler;
import se.lth.cs.srl.http.ParseRequestHandler;
import se.lth.cs.srl.http.ParserStatusHandler;
import se.lth.cs.srl.options.HttpOptions;
import se.lth.cs.srl.util.FileExistenceVerifier;

public class HttpPipeline {
    private static boolean ready = false;
    private static HttpServer server;
    private static ParseRequestHandler parseHandler;
    private static ParserStatusHandler statusHandler;
    private static ImageRequestHandler imgHandler;
    private static DefaultHandler defaultHandler;
    public static Date serverStart;

    public static void main(String[] args) {
        block3: {
            try {
                serverStart = new Date(System.currentTimeMillis());
                HttpOptions options = new HttpOptions();
                options.parseCmdLineArgs(args);
                String error = FileExistenceVerifier.verifyCompletePipelineAllNecessaryModelFiles(options);
                if (error != null) {
                    System.err.println(error);
                    System.err.println("Aborting.");
                    System.exit(1);
                }
                defaultHandler = new DefaultHandler(options.l);
                server = options.https ? HttpsServer.create(new InetSocketAddress(options.port), 0) : HttpServer.create(new InetSocketAddress(options.port), 0);
                server.createContext("/", defaultHandler);
                server.start();
                System.out.println("Server up and listening on port " + options.port);
                System.out.println("Setting up pipeline");
                CompletePipeline pipeline = CompletePipeline.getCompletePipeline(options);
                ImageCache imageCache = new ImageCache(3600000L, 3600000L, 1000);
                parseHandler = new ParseRequestHandler(defaultHandler, pipeline, imageCache);
                server.createContext("/parse", parseHandler);
                statusHandler = new ParserStatusHandler(pipeline);
                server.createContext("/status", statusHandler);
                imgHandler = new ImageRequestHandler(imageCache);
                server.createContext("/img", imgHandler);
                ready = true;
                System.out.println("Server loaded successfully, ready to parse!");
            }
            catch (Exception e) {
                System.out.println("Caught exception while setting up server, exiting.");
                e.printStackTrace(System.out);
                System.out.println();
                if (server == null) break block3;
                server.stop(0);
            }
        }
    }

    public static boolean isReady() {
        return ready;
    }
}

