/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.lth.cs.srl.Learn;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.features.Feature;
import se.lth.cs.srl.features.FeatureFile;
import se.lth.cs.srl.features.FeatureGenerator;
import se.lth.cs.srl.features.FeatureName;
import se.lth.cs.srl.features.FeatureSet;
import se.lth.cs.srl.io.AllCoNLL09Reader;
import se.lth.cs.srl.io.CoNLL09Writer;
import se.lth.cs.srl.io.DepsOnlyCoNLL09Reader;
import se.lth.cs.srl.options.FeatureSelectionOptions;
import se.lth.cs.srl.pipeline.Pipeline;
import se.lth.cs.srl.pipeline.Step;
import se.lth.cs.srl.util.scorer.AbstractScorer;
import se.lth.cs.srl.util.scorer.PredicateIdentificationScorer;

public class SelectFeatures {
    private static FeatureSelectionOptions options;
    private static FeatureGenerator fg;
    private static final FeatureName[] noArgsSingleFeatures;
    private static final FeatureName[] noArgsSingleFeatures_Feats;
    private static final FeatureName[] argsSingleFeatures;
    private static final FeatureName[] argsSingleFeatures_Feats;

    public static void printMemUsage() {
        System.gc();
        long free = Runtime.getRuntime().freeMemory();
        long total = Runtime.getRuntime().totalMemory();
        long used = total - free;
        System.out.println("Total memory: " + total / 1024L + "kb");
        System.out.println("Free memory:  " + free / 1024L + "kb");
        System.out.println("Used memory:  " + used / 1024L + "kb");
    }

    public static void main(String[] args) throws IOException {
        int i;
        options = new FeatureSelectionOptions(args);
        Learn.learnOptions = options.getLearnOptions();
        File corpusDir = new File(SelectFeatures.options.tempDir, "corpora");
        File ffDir = new File(SelectFeatures.options.tempDir, "features");
        corpusDir.mkdir();
        ffDir.mkdir();
        SelectFeatures.printMemUsage();
        List<Sentence> sentences = SelectFeatures.readSentences(options);
        SelectFeatures.printMemUsage();
        fg = new FeatureGenerator();
        List<Feature> startingFeatures = SelectFeatures.getStartSetFromFile(fg);
        SelectionState startState = SelectFeatures.getStartingState(fg, startingFeatures);
        SelectFeatures.printMemUsage();
        fg.buildFeatureMaps(sentences);
        SelectFeatures.printMemUsage();
        List<List<Sentence>> partitions = SelectFeatures.partitionSentences(sentences, options);
        SelectFeatures.printMemUsage();
        CorpusStruct.parts = new ArrayList<File>();
        int size = partitions.size();
        for (i = 0; i < size; ++i) {
            File save = new File(corpusDir, "gold-" + i);
            CorpusStruct.parts.add(save);
            CoNLL09Writer writer = new CoNLL09Writer(save);
            for (Sentence s : partitions.get(i)) {
                writer.write(s);
            }
            writer.close();
        }
        SelectFeatures.printMemUsage();
        CorpusStruct.testSets = partitions;
        CorpusStruct.trainingSets = new ArrayList<List<Sentence>>();
        size = partitions.size();
        for (i = 0; i < size; ++i) {
            ArrayList trainSet = new ArrayList();
            for (int j = 0; j < size; ++j) {
                SelectFeatures.printMemUsage();
                if (i == j) continue;
                trainSet.addAll(partitions.get(j));
            }
            CorpusStruct.trainingSets.add(trainSet);
        }
        int count = 0;
        SelectFeatures.printMemUsage();
        double increase = 999.0;
        while (increase > SelectFeatures.options.threshold) {
            increase = SelectFeatures.iterate(startState);
            FeatureFile.writeToFile(startState.current.get(SelectFeatures.options.POSPrefix), SelectFeatures.options.POSPrefix, startState.comments, new File(ffDir, (Object)((Object)SelectFeatures.options.step) + "-fs-" + ++count));
        }
        SelectFeatures.printMemUsage();
        if (!SelectFeatures.options.quadratic) {
            SelectFeatures.options.quadratic = true;
            fg = new FeatureGenerator();
            SelectFeatures.printMemUsage();
            SelectionState qstate = SelectFeatures.getStartingState(fg, startState.current.get(SelectFeatures.options.POSPrefix));
            qstate.score = startState.score;
            qstate.comments = startState.comments;
            SelectFeatures.printMemUsage();
            fg.buildFeatureMaps(sentences);
            SelectFeatures.printMemUsage();
            increase = 1.0;
            while (increase > SelectFeatures.options.threshold) {
                increase = SelectFeatures.iterate(qstate);
                FeatureFile.writeToFile(qstate.current.get(SelectFeatures.options.POSPrefix), SelectFeatures.options.POSPrefix, qstate.comments, new File(ffDir, (Object)((Object)SelectFeatures.options.step) + "-fs-" + ++count));
            }
        }
    }

    private static double iterate(SelectionState inputState) throws IOException {
        int size = inputState.additional.size();
        double[] scores = new double[size];
        HashMap<Step, FeatureSet> featureSets = new HashMap<Step, FeatureSet>();
        FeatureSet featureSet = new FeatureSet(inputState.current);
        featureSets.put(SelectFeatures.options.step, featureSet);
        AbstractScorer scorer = SelectFeatures.getScorer(SelectFeatures.options.step);
        int k_max = SelectFeatures.options.crossValidated ? SelectFeatures.options.partitions : 1;
        List featureList = (List)featureSet.get(SelectFeatures.options.POSPrefix);
        for (int k = 0; k < k_max; ++k) {
            int i = 0;
            while (i < size) {
                featureList.add(inputState.additional.get(i));
                scorer.reset();
                DepsOnlyCoNLL09Reader reader = new DepsOnlyCoNLL09Reader(CorpusStruct.parts.get(k));
                Iterator it = reader.iterator();
                featureSets.put(SelectFeatures.options.step, featureSet);
                Pipeline p = Pipeline.trainNewPipeline((Iterable<Sentence>)CorpusStruct.trainingSets.get(k), fg, null, featureSets);
                for (Sentence gold : CorpusStruct.testSets.get(k)) {
                    Sentence parsed = (Sentence)it.next();
                    p.parseSentence(parsed);
                    scorer.accScore(gold, parsed);
                }
                int n = i++;
                scores[n] = scores[n] + scorer.getAvgScore();
                featureList.remove(featureList.size() - 1);
            }
            System.out.println("Cross: " + k);
        }
        double bestScore = 0.0;
        int bestIndex = -1;
        int length = scores.length;
        for (int i = 0; i < length; ++i) {
            double avg = scores[i] / (double)k_max;
            if (!(avg > bestScore)) continue;
            bestScore = avg;
            bestIndex = i;
        }
        double increase = bestScore - inputState.score;
        if (increase > 0.0) {
            inputState.score = bestScore;
            Feature newFeature = inputState.additional.remove(bestIndex);
            inputState.current.get(SelectFeatures.options.POSPrefix).add(newFeature);
            inputState.comments.add("F1: " + bestScore + ", increase: " + increase);
        } else {
            System.out.println("negative increase.");
        }
        return increase;
    }

    private static AbstractScorer getScorer(Step step) {
        switch (step) {
            case pi: {
                return new PredicateIdentificationScorer();
            }
        }
        throw new Error("You are wrong here, check your code");
    }

    private static List<Feature> getStartSetFromFile(FeatureGenerator fg) throws IOException {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (SelectFeatures.options.startingFeatureFile != null) {
            Map<String, List<String>> fnameMap = FeatureFile.readFile(SelectFeatures.options.startingFeatureFile);
            List<String> fnames = fnameMap.get(SelectFeatures.options.POSPrefix);
            if (fnames == null) {
                throw new Error("The feature file provided does not contain the POSPrefix we want to explore. Aborting.");
            }
            for (String name : fnames) {
                Feature f = fg.getFeature(name, SelectFeatures.options.step == Step.pi, SelectFeatures.options.POSPrefix);
                features.add(f);
            }
        }
        return features;
    }

    private static SelectionState getStartingState(FeatureGenerator fg, List<Feature> startFeatures) throws IOException {
        SelectionState state = new SelectionState();
        state.current = new HashMap<String, List<Feature>>();
        state.additional = new ArrayList<Feature>();
        state.comments = new ArrayList<String>();
        ArrayList<String> except = new ArrayList<String>();
        for (Feature f : startFeatures) {
            except.add(f.getName());
        }
        Collection<Feature> allFeatures = SelectFeatures.getAllFeatures(fg, except);
        for (Feature f : allFeatures) {
            if (!startFeatures.contains(f)) {
                state.additional.add(f);
                continue;
            }
            System.out.println("We shouldnt end up here... Look into this.");
        }
        state.current.put(SelectFeatures.options.POSPrefix, startFeatures);
        int size = startFeatures.size();
        for (int i = 0; i < size; ++i) {
            state.comments.add(null);
        }
        return state;
    }

    private static Collection<Feature> getAllFeatures(FeatureGenerator fg, List<String> except) {
        ArrayList singleNames = new ArrayList();
        Collections.addAll(singleNames, noArgsSingleFeatures);
        if (SelectFeatures.options.includeFeats) {
            Collections.addAll(singleNames, noArgsSingleFeatures_Feats);
        }
        if (SelectFeatures.options.step == Step.ai || SelectFeatures.options.step == Step.ac) {
            Collections.addAll(singleNames, argsSingleFeatures);
            if (SelectFeatures.options.includeFeats) {
                Collections.addAll(singleNames, argsSingleFeatures_Feats);
            }
        }
        HashSet<Feature> ret = new HashSet<Feature>();
        for (FeatureName fn : singleNames) {
            if (except.contains(fn.toString())) continue;
            Feature f = fg.getFeature(fn, SelectFeatures.options.step == Step.pi, SelectFeatures.options.POSPrefix);
            ret.add(f);
        }
        if (SelectFeatures.options.quadratic) {
            for (FeatureName fn1 : singleNames) {
                for (FeatureName fn2 : singleNames) {
                    if (fn1 == fn2) continue;
                    try {
                        if (except.contains(FeatureGenerator.getCanonicalName(fn1, fn2))) continue;
                        Feature f = fg.getQFeature(fn1, fn2, SelectFeatures.options.step == Step.pi, SelectFeatures.options.POSPrefix);
                        ret.add(f);
                    }
                    catch (IllegalArgumentException e) {}
                }
            }
        }
        return ret;
    }

    private static List<Sentence> readSentences(FeatureSelectionOptions options) {
        ArrayList<Sentence> ret = new ArrayList<Sentence>();
        AllCoNLL09Reader reader = new AllCoNLL09Reader(options.trainingCorpus);
        for (Sentence s : reader) {
            if (options.dropSentencesWithoutPredicates && s.getPredicates().size() <= 0) continue;
            ret.add(s);
        }
        reader.close();
        return ret;
    }

    private static List<List<Sentence>> partitionSentences(List<Sentence> sentences, FeatureSelectionOptions options) {
        ArrayList<List<Sentence>> ret = new ArrayList<List<Sentence>>();
        for (int i = 0; i < options.partitions; ++i) {
            ret.add(new ArrayList());
        }
        if (options.randomizeInput) {
            Collections.shuffle(sentences);
        }
        int count = 0;
        for (Sentence s : sentences) {
            ((List)ret.get(count % options.partitions)).add(s);
            ++count;
        }
        return ret;
    }

    static {
        noArgsSingleFeatures = new FeatureName[]{FeatureName.PredWord, FeatureName.PredLemma, FeatureName.PredPOS, FeatureName.PredDeprel, FeatureName.PredParentWord, FeatureName.PredParentPOS, FeatureName.DepSubCat, FeatureName.ChildDepSet, FeatureName.ChildPOSSet, FeatureName.ChildWordSet};
        noArgsSingleFeatures_Feats = new FeatureName[]{FeatureName.PredFeats, FeatureName.PredParentFeats};
        argsSingleFeatures = new FeatureName[0];
        argsSingleFeatures_Feats = new FeatureName[0];
    }

    public static class CorpusStruct {
        public static List<File> parts;
        public static List<List<Sentence>> trainingSets;
        public static List<List<Sentence>> testSets;
    }

    public static class SelectionState {
        public Map<String, List<Feature>> current;
        public List<Feature> additional;
        public double score = 0.0;
        public List<String> comments;
    }
}

