/*
 * Decompiled with CFR 0.152.
 */
package se.lth.cs.srl.features;

import java.io.Serializable;
import se.lth.cs.srl.corpus.Sentence;
import se.lth.cs.srl.corpus.Word;
import se.lth.cs.srl.features.TargetWord;

public abstract class WordExtractor
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract Word getWord(Sentence var1, int var2, int var3);

    public abstract Word getWord(Word var1, Word var2);

    public static WordExtractor getExtractor(TargetWord tw) {
        switch (tw) {
            case Pred: {
                return new Pred();
            }
            case PredParent: {
                return new PredParent();
            }
            case Arg: {
                return new Arg();
            }
            case LeftDep: {
                return new LeftDep();
            }
            case RightDep: {
                return new RightDep();
            }
            case LeftSibling: {
                return new LeftSibling();
            }
            case RightSibling: {
                return new RightSibling();
            }
        }
        throw new Error("You are wrong here, check your code.");
    }

    private static class RightDep
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private RightDep() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return ((Word)s.get(argIndex)).getRightmostDep();
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return arg.getRightmostDep();
        }
    }

    private static class LeftDep
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private LeftDep() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return ((Word)s.get(argIndex)).getLeftmostDep();
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return arg.getLeftmostDep();
        }
    }

    private static class RightSibling
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private RightSibling() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return ((Word)s.get(argIndex)).getRightSibling();
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return arg.getRightSibling();
        }
    }

    private static class LeftSibling
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private LeftSibling() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return ((Word)s.get(argIndex)).getLeftSibling();
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return arg.getLeftSibling();
        }
    }

    private static class Arg
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private Arg() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return (Word)s.get(argIndex);
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return arg;
        }
    }

    private static class PredParent
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private PredParent() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return ((Word)s.get(predIndex)).getHead();
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return pred.getHead();
        }
    }

    private static class Pred
    extends WordExtractor {
        private static final long serialVersionUID = 1L;

        private Pred() {
        }

        @Override
        public Word getWord(Sentence s, int predIndex, int argIndex) {
            return (Word)s.get(predIndex);
        }

        @Override
        public Word getWord(Word pred, Word arg) {
            return pred;
        }
    }
}

